/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Defaults;
import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.BiMap;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Range;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMapDifference;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultimap;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@Beta
public final class ArbitraryInstances {
    private static final Ordering<Field> BY_FIELD_NAME = new Ordering<Field>(){

        public int compare(Field left, Field right) {
            return left.getName().compareTo(right.getName());
        }
    };
    private static final ClassToInstanceMap<Object> DEFAULTS = ImmutableClassToInstanceMap.builder().put(Object.class, (Object)"").put(Number.class, (Object)0).put(UnsignedInteger.class, (Object)UnsignedInteger.ZERO).put(UnsignedLong.class, (Object)UnsignedLong.ZERO).put(BigInteger.class, (Object)BigInteger.ZERO).put(BigDecimal.class, (Object)BigDecimal.ZERO).put(CharSequence.class, (Object)"").put(String.class, (Object)"").put(Pattern.class, (Object)Pattern.compile("")).put(MatchResult.class, (Object)Pattern.compile("").matcher("").toMatchResult()).put(TimeUnit.class, (Object)TimeUnit.SECONDS).put(Charset.class, (Object)Charsets.UTF_8).put(Currency.class, (Object)Currency.getInstance(Locale.US)).put(Locale.class, (Object)Locale.US).put(CharMatcher.class, (Object)CharMatcher.NONE).put(Joiner.class, (Object)Joiner.on((char)',')).put(Splitter.class, (Object)Splitter.on((char)',')).put(Optional.class, (Object)Optional.absent()).put(Predicate.class, (Object)Predicates.alwaysTrue()).put(Equivalence.class, (Object)Equivalence.equals()).put(Ticker.class, (Object)Ticker.systemTicker()).put(Stopwatch.class, (Object)Stopwatch.createUnstarted()).put(InputStream.class, (Object)new ByteArrayInputStream(new byte[0])).put(ByteArrayInputStream.class, (Object)new ByteArrayInputStream(new byte[0])).put(Readable.class, (Object)new StringReader("")).put(Reader.class, (Object)new StringReader("")).put(StringReader.class, (Object)new StringReader("")).put(Buffer.class, (Object)ByteBuffer.allocate(0)).put(CharBuffer.class, (Object)CharBuffer.allocate(0)).put(ByteBuffer.class, (Object)ByteBuffer.allocate(0)).put(ShortBuffer.class, (Object)ShortBuffer.allocate(0)).put(IntBuffer.class, (Object)IntBuffer.allocate(0)).put(LongBuffer.class, (Object)LongBuffer.allocate(0)).put(FloatBuffer.class, (Object)FloatBuffer.allocate(0)).put(DoubleBuffer.class, (Object)DoubleBuffer.allocate(0)).put(File.class, (Object)new File("")).put(Iterator.class, (Object)Iterators.emptyIterator()).put(PeekingIterator.class, (Object)Iterators.peekingIterator((Iterator)Iterators.emptyIterator())).put(ListIterator.class, (Object)ImmutableList.of().listIterator()).put(Iterable.class, (Object)ImmutableSet.of()).put(Collection.class, (Object)ImmutableList.of()).put(ImmutableCollection.class, (Object)ImmutableList.of()).put(List.class, (Object)ImmutableList.of()).put(ImmutableList.class, (Object)ImmutableList.of()).put(Set.class, (Object)ImmutableSet.of()).put(ImmutableSet.class, (Object)ImmutableSet.of()).put(SortedSet.class, (Object)ImmutableSortedSet.of()).put(ImmutableSortedSet.class, (Object)ImmutableSortedSet.of()).put(NavigableSet.class, (Object)Sets.unmodifiableNavigableSet((NavigableSet)Sets.newTreeSet())).put(Map.class, (Object)ImmutableMap.of()).put(ImmutableMap.class, (Object)ImmutableMap.of()).put(SortedMap.class, (Object)ImmutableSortedMap.of()).put(ImmutableSortedMap.class, (Object)ImmutableSortedMap.of()).put(NavigableMap.class, (Object)Maps.unmodifiableNavigableMap((NavigableMap)Maps.newTreeMap())).put(Multimap.class, (Object)ImmutableMultimap.of()).put(ImmutableMultimap.class, (Object)ImmutableMultimap.of()).put(ListMultimap.class, (Object)ImmutableListMultimap.of()).put(ImmutableListMultimap.class, (Object)ImmutableListMultimap.of()).put(SetMultimap.class, (Object)ImmutableSetMultimap.of()).put(ImmutableSetMultimap.class, (Object)ImmutableSetMultimap.of()).put(SortedSetMultimap.class, (Object)Multimaps.unmodifiableSortedSetMultimap((SortedSetMultimap)TreeMultimap.create())).put(Multiset.class, (Object)ImmutableMultiset.of()).put(ImmutableMultiset.class, (Object)ImmutableMultiset.of()).put(SortedMultiset.class, (Object)ImmutableSortedMultiset.of()).put(ImmutableSortedMultiset.class, (Object)ImmutableSortedMultiset.of()).put(BiMap.class, (Object)ImmutableBiMap.of()).put(ImmutableBiMap.class, (Object)ImmutableBiMap.of()).put(Table.class, (Object)ImmutableTable.of()).put(ImmutableTable.class, (Object)ImmutableTable.of()).put(RowSortedTable.class, (Object)Tables.unmodifiableRowSortedTable((RowSortedTable)TreeBasedTable.create())).put(ClassToInstanceMap.class, (Object)ImmutableClassToInstanceMap.builder().build()).put(ImmutableClassToInstanceMap.class, (Object)ImmutableClassToInstanceMap.builder().build()).put(Comparable.class, (Object)ByToString.access$100()).put(Comparator.class, (Object)AlwaysEqual.access$000()).put(Ordering.class, (Object)AlwaysEqual.access$000()).put(Range.class, (Object)Range.all()).put(MapConstraint.class, (Object)MapConstraints.notNull()).put(MapDifference.class, (Object)Maps.difference((Map)ImmutableMap.of(), (Map)ImmutableMap.of())).put(SortedMapDifference.class, (Object)Maps.difference((SortedMap)ImmutableSortedMap.of(), (Map)ImmutableSortedMap.of())).put(AnnotatedElement.class, Object.class).put(GenericDeclaration.class, Object.class).put(Type.class, Object.class).build();
    private static final ConcurrentMap<Class<?>, Class<?>> implementations = Maps.newConcurrentMap();
    private static final Logger logger;

    private static <T> void setImplementation(Class<T> type, Class<? extends T> implementation) {
        Preconditions.checkArgument((type != implementation ? 1 : 0) != 0, (String)"Don't register %s to itself!", (Object[])new Object[]{type});
        Preconditions.checkArgument((!DEFAULTS.containsKey(type) ? 1 : 0) != 0, (String)"A default value was already registered for %s", (Object[])new Object[]{type});
        Preconditions.checkArgument((implementations.put(type, implementation) == null ? 1 : 0) != 0, (String)"Implementation for %s was already registered", (Object[])new Object[]{type});
    }

    @Nullable
    private static <T> Class<? extends T> getImplementation(Class<T> type) {
        return (Class)implementations.get(type);
    }

    @Nullable
    public static <T> T get(Class<T> type) {
        Constructor<T> constructor;
        Object defaultValue = DEFAULTS.getInstance(type);
        if (defaultValue != null) {
            return (T)defaultValue;
        }
        Class<T> implementation = ArbitraryInstances.getImplementation(type);
        if (implementation != null) {
            return ArbitraryInstances.get(implementation);
        }
        if (type.isEnum()) {
            T[] enumConstants = type.getEnumConstants();
            return enumConstants.length == 0 ? null : (T)enumConstants[0];
        }
        if (type.isArray()) {
            return ArbitraryInstances.createEmptyArray(type);
        }
        Object jvmDefault = Defaults.defaultValue((Class)Primitives.unwrap(type));
        if (jvmDefault != null) {
            return (T)jvmDefault;
        }
        if (Modifier.isAbstract(type.getModifiers()) || !Modifier.isPublic(type.getModifiers())) {
            return ArbitraryInstances.arbitraryConstantInstanceOrNull(type);
        }
        try {
            constructor = type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return ArbitraryInstances.arbitraryConstantInstanceOrNull(type);
        }
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.WARNING, "Exception while invoking default constructor.", e.getCause());
            return ArbitraryInstances.arbitraryConstantInstanceOrNull(type);
        }
    }

    @Nullable
    private static <T> T arbitraryConstantInstanceOrNull(Class<T> type) {
        Field[] fields = type.getDeclaredFields();
        Arrays.sort(fields, BY_FIELD_NAME);
        for (Field field : fields) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || field.getGenericType() != field.getType() || !type.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                T constant = type.cast(field.get(null));
                if (constant == null) continue;
                return constant;
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
        return null;
    }

    private static <T> T createEmptyArray(Class<T> arrayType) {
        return arrayType.cast(Array.newInstance(arrayType.getComponentType(), 0));
    }

    private ArbitraryInstances() {
    }

    static {
        ArbitraryInstances.setImplementation(Appendable.class, StringBuilder.class);
        ArbitraryInstances.setImplementation(BlockingQueue.class, LinkedBlockingDeque.class);
        ArbitraryInstances.setImplementation(BlockingDeque.class, LinkedBlockingDeque.class);
        ArbitraryInstances.setImplementation(ConcurrentMap.class, ConcurrentHashMap.class);
        ArbitraryInstances.setImplementation(ConcurrentNavigableMap.class, ConcurrentSkipListMap.class);
        ArbitraryInstances.setImplementation(CountDownLatch.class, Dummies.DummyCountDownLatch.class);
        ArbitraryInstances.setImplementation(Deque.class, ArrayDeque.class);
        ArbitraryInstances.setImplementation(OutputStream.class, ByteArrayOutputStream.class);
        ArbitraryInstances.setImplementation(PrintStream.class, Dummies.InMemoryPrintStream.class);
        ArbitraryInstances.setImplementation(PrintWriter.class, Dummies.InMemoryPrintWriter.class);
        ArbitraryInstances.setImplementation(Queue.class, ArrayDeque.class);
        ArbitraryInstances.setImplementation(Random.class, Dummies.DeterministicRandom.class);
        ArbitraryInstances.setImplementation(ScheduledThreadPoolExecutor.class, Dummies.DummyScheduledThreadPoolExecutor.class);
        ArbitraryInstances.setImplementation(ThreadPoolExecutor.class, Dummies.DummyScheduledThreadPoolExecutor.class);
        ArbitraryInstances.setImplementation(Writer.class, StringWriter.class);
        ArbitraryInstances.setImplementation(Runnable.class, Dummies.DummyRunnable.class);
        ArbitraryInstances.setImplementation(ThreadFactory.class, Dummies.DummyThreadFactory.class);
        ArbitraryInstances.setImplementation(Executor.class, Dummies.DummyExecutor.class);
        logger = Logger.getLogger(ArbitraryInstances.class.getName());
    }

    private static final class AlwaysEqual
    extends Ordering<Object>
    implements Serializable {
        private static final AlwaysEqual INSTANCE = new AlwaysEqual();

        private AlwaysEqual() {
        }

        public int compare(Object o1, Object o2) {
            return 0;
        }

        public String toString() {
            return "ALWAYS_EQUAL";
        }

        private Object readResolve() {
            return INSTANCE;
        }

        static /* synthetic */ AlwaysEqual access$000() {
            return INSTANCE;
        }
    }

    private static final class ByToString
    implements Comparable<Object>,
    Serializable {
        private static final ByToString INSTANCE = new ByToString();

        private ByToString() {
        }

        @Override
        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return "BY_TO_STRING";
        }

        private Object readResolve() {
            return INSTANCE;
        }

        static /* synthetic */ ByToString access$100() {
            return INSTANCE;
        }
    }

    private static final class Dummies {
        private Dummies() {
        }

        public static final class DummyExecutor
        implements Executor,
        Serializable {
            @Override
            public void execute(Runnable command) {
            }
        }

        public static final class DummyThreadFactory
        implements ThreadFactory,
        Serializable {
            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        }

        public static final class DummyRunnable
        implements Runnable,
        Serializable {
            @Override
            public void run() {
            }
        }

        public static final class DummyCountDownLatch
        extends CountDownLatch {
            public DummyCountDownLatch() {
                super(0);
            }
        }

        public static final class DummyScheduledThreadPoolExecutor
        extends ScheduledThreadPoolExecutor {
            public DummyScheduledThreadPoolExecutor() {
                super(1);
            }
        }

        public static final class DeterministicRandom
        extends Random {
            public DeterministicRandom() {
                super(0L);
            }
        }

        public static final class InMemoryPrintWriter
        extends PrintWriter {
            public InMemoryPrintWriter() {
                super(new StringWriter());
            }
        }

        public static final class InMemoryPrintStream
        extends PrintStream {
            public InMemoryPrintStream() {
                super(new ByteArrayOutputStream());
            }
        }
    }
}

