/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.IteratorFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

@GwtCompatible
abstract class AbstractIteratorTester<E, I extends Iterator<E>> {
    private Stimulus<E, ? super I>[] stimuli;
    private final Iterator<E> elementsToInsert;
    private final Set<IteratorFeature> features;
    private final List<E> expectedElements;
    private final int startIndex;
    private final KnownOrder knownOrder;
    private static final IteratorOperation REMOVE_METHOD = new IteratorOperation(){

        @Override
        public Object execute(Iterator<?> iterator) {
            iterator.remove();
            return null;
        }
    };
    private static final IteratorOperation NEXT_METHOD = new IteratorOperation(){

        @Override
        public Object execute(Iterator<?> iterator) {
            return iterator.next();
        }
    };
    private static final IteratorOperation PREVIOUS_METHOD = new IteratorOperation(){

        @Override
        public Object execute(Iterator<?> iterator) {
            return ((ListIterator)iterator).previous();
        }
    };
    Stimulus<E, Iterator<E>> hasNext = new Stimulus<E, Iterator<E>>(this, "hasNext"){

        @Override
        void executeAndCompare(ListIterator<E> reference, Iterator<E> target) {
            Assert.assertEquals((boolean)reference.hasNext(), (boolean)target.hasNext());
        }
    };
    Stimulus<E, Iterator<E>> next = new Stimulus<E, Iterator<E>>("next"){

        @Override
        void executeAndCompare(ListIterator<E> reference, Iterator<E> target) {
            AbstractIteratorTester.this.internalExecuteAndCompare(reference, target, NEXT_METHOD);
        }
    };
    Stimulus<E, Iterator<E>> remove = new Stimulus<E, Iterator<E>>("remove"){

        @Override
        void executeAndCompare(ListIterator<E> reference, Iterator<E> target) {
            AbstractIteratorTester.this.internalExecuteAndCompare(reference, target, REMOVE_METHOD);
        }
    };
    Stimulus<E, ListIterator<E>> hasPrevious = new Stimulus<E, ListIterator<E>>(this, "hasPrevious"){

        @Override
        void executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            Assert.assertEquals((boolean)reference.hasPrevious(), (boolean)target.hasPrevious());
        }
    };
    Stimulus<E, ListIterator<E>> nextIndex = new Stimulus<E, ListIterator<E>>(this, "nextIndex"){

        @Override
        void executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            Assert.assertEquals((int)reference.nextIndex(), (int)target.nextIndex());
        }
    };
    Stimulus<E, ListIterator<E>> previousIndex = new Stimulus<E, ListIterator<E>>(this, "previousIndex"){

        @Override
        void executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            Assert.assertEquals((int)reference.previousIndex(), (int)target.previousIndex());
        }
    };
    Stimulus<E, ListIterator<E>> previous = new Stimulus<E, ListIterator<E>>("previous"){

        @Override
        void executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            AbstractIteratorTester.this.internalExecuteAndCompare(reference, target, PREVIOUS_METHOD);
        }
    };
    Stimulus<E, ListIterator<E>> add = new Stimulus<E, ListIterator<E>>("add"){

        @Override
        void executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            AbstractIteratorTester.this.internalExecuteAndCompare(reference, target, AbstractIteratorTester.this.newAddMethod());
        }
    };
    Stimulus<E, ListIterator<E>> set = new Stimulus<E, ListIterator<E>>("set"){

        @Override
        void executeAndCompare(ListIterator<E> reference, ListIterator<E> target) {
            AbstractIteratorTester.this.internalExecuteAndCompare(reference, target, AbstractIteratorTester.this.newSetMethod());
        }
    };

    AbstractIteratorTester(int steps, Iterable<E> elementsToInsertIterable, Iterable<? extends IteratorFeature> features, Iterable<E> expectedElements, KnownOrder knownOrder, int startIndex) {
        this.stimuli = new Stimulus[steps];
        if (!elementsToInsertIterable.iterator().hasNext()) {
            throw new IllegalArgumentException();
        }
        this.elementsToInsert = Helpers.cycle(elementsToInsertIterable);
        this.features = Helpers.copyToSet(features);
        this.expectedElements = Helpers.copyToList(expectedElements);
        this.knownOrder = knownOrder;
        this.startIndex = startIndex;
    }

    protected abstract Iterable<? extends Stimulus<E, ? super I>> getStimulusValues();

    protected abstract I newTargetIterator();

    protected void verify(List<E> elements) {
    }

    public final void test() {
        try {
            this.recurse(0);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(Arrays.toString(this.stimuli), e);
        }
    }

    public void testForEachRemaining() {
        for (int i = 0; i < this.expectedElements.size() - 1; ++i) {
            ArrayList targetElements = new ArrayList();
            I iterator = this.newTargetIterator();
            for (int j = 0; j < i; ++j) {
                targetElements.add(iterator.next());
            }
            iterator.forEachRemaining(targetElements::add);
            if (this.knownOrder == KnownOrder.KNOWN_ORDER) {
                Assert.assertEquals(this.expectedElements, targetElements);
                continue;
            }
            Helpers.assertEqualIgnoringOrder(this.expectedElements, targetElements);
        }
    }

    private void recurse(int level) {
        if (level == this.stimuli.length) {
            this.compareResultsForThisListOfStimuli();
        } else {
            for (Stimulus<E, I> stimulus : this.getStimulusValues()) {
                this.stimuli[level] = stimulus;
                this.recurse(level + 1);
            }
        }
    }

    private void compareResultsForThisListOfStimuli() {
        int removes = Collections.frequency(Arrays.asList(this.stimuli), this.remove);
        if (!this.features.contains((Object)IteratorFeature.SUPPORTS_REMOVE) && removes > 1 || this.stimuli.length >= 5 && removes > 2) {
            return;
        }
        MultiExceptionListIterator reference = new MultiExceptionListIterator(this.expectedElements);
        I target = this.newTargetIterator();
        for (int i = 0; i < this.stimuli.length; ++i) {
            try {
                this.stimuli[i].executeAndCompare(reference, target);
                this.verify(reference.getElements());
                continue;
            }
            catch (AssertionFailedError cause) {
                String string = String.valueOf(AbstractIteratorTester.subListCopy(this.stimuli, i + 1));
                Helpers.fail(cause, new StringBuilder(20 + String.valueOf(string).length()).append("failed with stimuli ").append(string).toString());
            }
        }
    }

    private static List<Object> subListCopy(Object[] source, int size) {
        Object[] copy = new Object[size];
        System.arraycopy(source, 0, copy, 0, size);
        return Arrays.asList(copy);
    }

    private <T extends Iterator<E>> void internalExecuteAndCompare(T reference, T target, IteratorOperation method) {
        Object referenceReturnValue = null;
        PermittedMetaException referenceException = null;
        Object targetReturnValue = null;
        RuntimeException targetException = null;
        try {
            targetReturnValue = method.execute(target);
        }
        catch (RuntimeException e) {
            targetException = e;
        }
        try {
            if (method == NEXT_METHOD && targetException == null && this.knownOrder == KnownOrder.UNKNOWN_ORDER) {
                Object targetReturnValueFromNext = targetReturnValue;
                MultiExceptionListIterator multiExceptionListIterator = (MultiExceptionListIterator)reference;
                multiExceptionListIterator.promoteToNext(targetReturnValueFromNext);
            }
            referenceReturnValue = method.execute(reference);
        }
        catch (PermittedMetaException e) {
            referenceException = e;
        }
        catch (UnknownElementException e) {
            Helpers.fail(e, e.getMessage());
        }
        if (referenceException == null) {
            if (targetException != null) {
                Helpers.fail(targetException, "Target threw exception when reference did not");
            }
            Assert.assertEquals((Object)referenceReturnValue, (Object)targetReturnValue);
            return;
        }
        if (targetException == null) {
            String string = String.valueOf(referenceException);
            Assert.fail((String)new StringBuilder(23 + String.valueOf(string).length()).append("Target failed to throw ").append(string).toString());
        }
        referenceException.assertPermitted(targetException);
    }

    private final IteratorOperation newAddMethod() {
        final E toInsert = this.elementsToInsert.next();
        return new IteratorOperation(this){

            @Override
            public Object execute(Iterator<?> iterator) {
                ListIterator rawIterator = (ListIterator)iterator;
                rawIterator.add(toInsert);
                return null;
            }
        };
    }

    private final IteratorOperation newSetMethod() {
        final E toInsert = this.elementsToInsert.next();
        return new IteratorOperation(this){

            @Override
            public Object execute(Iterator<?> iterator) {
                ListIterator li = (ListIterator)iterator;
                li.set(toInsert);
                return null;
            }
        };
    }

    List<Stimulus<E, Iterator<E>>> iteratorStimuli() {
        return Arrays.asList(this.hasNext, this.next, this.remove);
    }

    List<Stimulus<E, ListIterator<E>>> listIteratorStimuli() {
        return Arrays.asList(this.hasPrevious, this.nextIndex, this.previousIndex, this.previous, this.add, this.set);
    }

    static abstract class Stimulus<E, T extends Iterator<E>> {
        private final String toString;

        protected Stimulus(String toString) {
            this.toString = toString;
        }

        abstract void executeAndCompare(ListIterator<E> var1, T var2);

        public String toString() {
            return this.toString;
        }
    }

    private static interface IteratorOperation {
        public Object execute(Iterator<?> var1);
    }

    public static enum KnownOrder {
        KNOWN_ORDER,
        UNKNOWN_ORDER;

    }

    protected final class MultiExceptionListIterator
    implements ListIterator<E> {
        final Stack<E> nextElements = new Stack();
        final Stack<E> previousElements = new Stack();
        Stack<E> stackWithLastReturnedElementAtTop = null;

        MultiExceptionListIterator(List<E> expectedElements) {
            Helpers.addAll(this.nextElements, Helpers.reverse(expectedElements));
            for (int i = 0; i < AbstractIteratorTester.this.startIndex; ++i) {
                this.previousElements.push(this.nextElements.pop());
            }
        }

        @Override
        public void add(E e) {
            if (!AbstractIteratorTester.this.features.contains((Object)IteratorFeature.SUPPORTS_ADD)) {
                throw PermittedMetaException.UOE;
            }
            this.previousElements.push(e);
            this.stackWithLastReturnedElementAtTop = null;
        }

        @Override
        public boolean hasNext() {
            return !this.nextElements.isEmpty();
        }

        @Override
        public boolean hasPrevious() {
            return !this.previousElements.isEmpty();
        }

        @Override
        public E next() {
            return this.transferElement(this.nextElements, this.previousElements);
        }

        @Override
        public int nextIndex() {
            return this.previousElements.size();
        }

        @Override
        public E previous() {
            return this.transferElement(this.previousElements, this.nextElements);
        }

        @Override
        public int previousIndex() {
            return this.nextIndex() - 1;
        }

        @Override
        public void remove() {
            this.throwIfInvalid(IteratorFeature.SUPPORTS_REMOVE);
            this.stackWithLastReturnedElementAtTop.pop();
            this.stackWithLastReturnedElementAtTop = null;
        }

        @Override
        public void set(E e) {
            this.throwIfInvalid(IteratorFeature.SUPPORTS_SET);
            this.stackWithLastReturnedElementAtTop.pop();
            this.stackWithLastReturnedElementAtTop.push(e);
        }

        void promoteToNext(E e) {
            if (!this.nextElements.remove(e)) {
                throw new UnknownElementException(this.nextElements, e);
            }
            this.nextElements.push(e);
        }

        private E transferElement(Stack<E> source, Stack<E> destination) {
            if (source.isEmpty()) {
                throw PermittedMetaException.NSEE;
            }
            destination.push(source.pop());
            this.stackWithLastReturnedElementAtTop = destination;
            return destination.peek();
        }

        private void throwIfInvalid(IteratorFeature methodFeature) {
            if (!AbstractIteratorTester.this.features.contains((Object)methodFeature)) {
                if (this.stackWithLastReturnedElementAtTop == null) {
                    throw PermittedMetaException.UOE_OR_ISE;
                }
                throw PermittedMetaException.UOE;
            }
            if (this.stackWithLastReturnedElementAtTop == null) {
                throw PermittedMetaException.ISE;
            }
        }

        private List<E> getElements() {
            ArrayList elements = new ArrayList();
            Helpers.addAll(elements, this.previousElements);
            Helpers.addAll(elements, Helpers.reverse(this.nextElements));
            return elements;
        }
    }

    private static final class UnknownElementException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        private UnknownElementException(Collection<?> expected, Object actual) {
            String string = String.valueOf(actual);
            String string2 = String.valueOf(expected);
            super(new StringBuilder(49 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Returned value '").append(string).append("' not found. Remaining elements: ").append(string2).toString());
        }
    }

    private static abstract class PermittedMetaException
    extends RuntimeException {
        static final PermittedMetaException UOE_OR_ISE = new PermittedMetaException("UnsupportedOperationException or IllegalStateException"){

            @Override
            boolean isPermitted(RuntimeException exception) {
                return exception instanceof UnsupportedOperationException || exception instanceof IllegalStateException;
            }
        };
        static final PermittedMetaException UOE = new PermittedMetaException("UnsupportedOperationException"){

            @Override
            boolean isPermitted(RuntimeException exception) {
                return exception instanceof UnsupportedOperationException;
            }
        };
        static final PermittedMetaException ISE = new PermittedMetaException("IllegalStateException"){

            @Override
            boolean isPermitted(RuntimeException exception) {
                return exception instanceof IllegalStateException;
            }
        };
        static final PermittedMetaException NSEE = new PermittedMetaException("NoSuchElementException"){

            @Override
            boolean isPermitted(RuntimeException exception) {
                return exception instanceof NoSuchElementException;
            }
        };
        private static final long serialVersionUID = 0L;

        private PermittedMetaException(String message) {
            super(message);
        }

        abstract boolean isPermitted(RuntimeException var1);

        void assertPermitted(RuntimeException exception) {
            if (!this.isPermitted(exception)) {
                String string = exception.getClass().getSimpleName();
                String string2 = this.getMessage();
                String message = new StringBuilder(32 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Exception ").append(string).append(" was thrown; expected ").append(string2).toString();
                Helpers.fail(exception, message);
            }
        }
    }
}

