/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent.collector;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.collector.AbstractConcurrentCollector;
import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import com.helger.commons.lang.GenericReflection;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCollectorSingle<DATATYPE>
extends AbstractConcurrentCollector<DATATYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentCollectorSingle.class);
    private IConcurrentPerformer<DATATYPE> m_aPerformer;

    public ConcurrentCollectorSingle() {
        this(100);
    }

    public ConcurrentCollectorSingle(@Nonnegative int n) {
        super(n);
    }

    public ConcurrentCollectorSingle(@Nonnull BlockingQueue<Object> blockingQueue) {
        super(blockingQueue);
    }

    @Nullable
    public final IConcurrentPerformer<DATATYPE> getPerformer() {
        return this.m_aPerformer;
    }

    @Nonnull
    public final ConcurrentCollectorSingle<DATATYPE> setPerformer(@Nonnull IConcurrentPerformer<DATATYPE> iConcurrentPerformer) {
        if (this.m_aPerformer != null) {
            throw new IllegalStateException("Another performer is already set!");
        }
        this.m_aPerformer = ValueEnforcer.notNull(iConcurrentPerformer, "Performer");
        return this;
    }

    private void _perform(DATATYPE DATATYPE) {
        try {
            this.m_aPerformer.runAsync(DATATYPE);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to perform actions on object with performer " + String.valueOf(this.m_aPerformer) + " - object has been lost!", (Throwable)exception);
        }
    }

    @Override
    public final void collect() {
        if (this.m_aPerformer == null) {
            throw new IllegalStateException("No performer set!");
        }
        try {
            Object e;
            while ((e = this.m_aQueue.take()) != STOP_QUEUE_OBJECT) {
                this._perform(GenericReflection.uncheckedCast(e));
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error("Error taking elements from queue - queue has been interrupted!!!", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (Throwable throwable) {
            LOGGER.error("Error taking elements from queue - queue has been stopped!!!", throwable);
        }
    }
}

