/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.resourcebundle;

import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.system.EJavaVersion;
import com.helger.commons.text.resourcebundle.Utf8ResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ResourceBundleHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleHelper.class);
    private static final ResourceBundleHelper INSTANCE = new ResourceBundleHelper();

    private ResourceBundleHelper() {
    }

    @Nullable
    public static ResourceBundle getResourceBundle(@Nonnull String string, @Nonnull Locale locale) {
        return ResourceBundleHelper.getResourceBundle(string, locale, ClassLoaderHelper.getDefaultClassLoader());
    }

    @Nullable
    public static ResourceBundle getResourceBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        try {
            return ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Nullable
    public static ResourceBundle getUtf8ResourceBundle(@Nonnull String string, @Nonnull Locale locale) {
        return ResourceBundleHelper.getUtf8ResourceBundle(string, locale, ClassLoaderHelper.getDefaultClassLoader());
    }

    @Nullable
    public static ResourceBundle getUtf8ResourceBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        try {
            if (EJavaVersion.JDK_9.isSupportedVersion()) {
                return ResourceBundle.getBundle(string, locale, classLoader);
            }
            return Utf8ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Nullable
    public static String getString(@Nullable ResourceBundle resourceBundle, @Nonnull @PropertyKey String string) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String getString(@Nonnull String string, @Nonnull Locale locale, @Nonnull @PropertyKey String string2) {
        return ResourceBundleHelper.getString(ResourceBundleHelper.getResourceBundle(string, locale), string2);
    }

    @Nullable
    public static String getString(@Nonnull String string, @Nonnull Locale locale, @Nonnull @PropertyKey String string2, @Nonnull ClassLoader classLoader) {
        return ResourceBundleHelper.getString(ResourceBundleHelper.getResourceBundle(string, locale, classLoader), string2);
    }

    @Nullable
    public static String getUtf8String(@Nonnull String string, @Nonnull Locale locale, @Nonnull @PropertyKey String string2) {
        return ResourceBundleHelper.getString(ResourceBundleHelper.getUtf8ResourceBundle(string, locale), string2);
    }

    @Nullable
    public static String getUtf8String(@Nonnull String string, @Nonnull Locale locale, @Nonnull @PropertyKey String string2, @Nonnull ClassLoader classLoader) {
        return ResourceBundleHelper.getString(ResourceBundleHelper.getUtf8ResourceBundle(string, locale, classLoader), string2);
    }

    public static void clearCache() {
        ResourceBundleHelper.clearCache(ClassLoaderHelper.getDefaultClassLoader());
    }

    public static void clearCache(@Nonnull ClassLoader classLoader) {
        ResourceBundle.clearCache(classLoader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache was cleared: " + ResourceBundle.class.getName() + "; classloader=" + String.valueOf(classLoader));
        }
    }
}

