/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.log.ConditionalLogger;
import com.helger.commons.log.IHasConditionalLogger;
import com.helger.commons.typeconvert.ITypeConverter;
import com.helger.commons.typeconvert.ITypeConverterProvider;
import com.helger.commons.typeconvert.TypeConverterException;
import com.helger.commons.typeconvert.TypeConverterProviderBestMatch;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class TypeConverter
implements IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeConverter.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER, false);
    private static final TypeConverter INSTANCE = new TypeConverter();

    private TypeConverter() {
    }

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(boolean bl, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convert((Object)bl, clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(byte by, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convert((Object)by, clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(char c, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convert(Character.valueOf(c), clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(double d, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convert((Object)d, clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(float f, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convert(Float.valueOf(f), clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(int n, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convert((Object)n, clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(long l, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convert((Object)l, clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(short s, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convert((Object)s, clazz);
    }

    public static boolean convertToBoolean(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Boolean.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Boolean bl = TypeConverter.convert(object, Boolean.class);
        return bl;
    }

    public static boolean convertToBoolean(@Nullable Object object, boolean bl) {
        Boolean bl2 = TypeConverter.convert(object, Boolean.class, null);
        return bl2 == null ? bl : bl2;
    }

    public static byte convertToByte(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Byte.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Byte by = TypeConverter.convert(object, Byte.class);
        return by;
    }

    public static byte convertToByte(@Nullable Object object, byte by) {
        Byte by2 = TypeConverter.convert(object, Byte.class, null);
        return by2 == null ? by : by2;
    }

    public static char convertToChar(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Character.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Character c = TypeConverter.convert(object, Character.class);
        return c.charValue();
    }

    public static char convertToChar(@Nullable Object object, char c) {
        Character c2 = TypeConverter.convert(object, Character.class, null);
        return c2 == null ? c : c2.charValue();
    }

    public static double convertToDouble(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Double.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Double d = TypeConverter.convert(object, Double.class);
        return d;
    }

    public static double convertToDouble(@Nullable Object object, double d) {
        Double d2 = TypeConverter.convert(object, Double.class, null);
        return d2 == null ? d : d2;
    }

    public static float convertToFloat(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Float.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Float f = TypeConverter.convert(object, Float.class);
        return f.floatValue();
    }

    public static float convertToFloat(@Nullable Object object, float f) {
        Float f2 = TypeConverter.convert(object, Float.class, null);
        return f2 == null ? f : f2.floatValue();
    }

    public static int convertToInt(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Integer.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Integer n = TypeConverter.convert(object, Integer.class);
        return n;
    }

    public static int convertToInt(@Nullable Object object, int n) {
        Integer n2 = TypeConverter.convert(object, Integer.class, null);
        return n2 == null ? n : n2;
    }

    public static long convertToLong(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Long.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Long l = TypeConverter.convert(object, Long.class);
        return l;
    }

    public static long convertToLong(@Nullable Object object, long l) {
        Long l2 = TypeConverter.convert(object, Long.class, null);
        return l2 == null ? l : l2;
    }

    public static short convertToShort(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Short.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Short s = TypeConverter.convert(object, Short.class);
        return s;
    }

    public static short convertToShort(@Nullable Object object, short s) {
        Short s2 = TypeConverter.convert(object, Short.class, null);
        return s2 == null ? s : s2;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(@Nullable Object object, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convert(TypeConverterProviderBestMatch.getInstance(), object, clazz);
    }

    @Nullable
    private static Class<?> _getUsableClass(@Nullable Class<?> clazz) {
        Class<?> clazz2 = ClassHelper.getPrimitiveWrapperClass(clazz);
        return clazz2 != null ? clazz2 : clazz;
    }

    @Nonnull
    private static Object _performConversion(@Nonnull ITypeConverterProvider iTypeConverterProvider, @Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull Object object) {
        Object object2;
        ITypeConverter<Object, Object> iTypeConverter = iTypeConverterProvider.getTypeConverter(clazz, clazz2);
        if (iTypeConverter == null) {
            CONDLOG.warn(() -> "No type converter from '" + clazz.getName() + "' to '" + clazz2.getName() + "' was found (using provider '" + iTypeConverterProvider.getClass().getName() + "')");
            throw new TypeConverterException(clazz, clazz2, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        try {
            object2 = iTypeConverter.apply(object);
        }
        catch (RuntimeException runtimeException) {
            throw new TypeConverterException(clazz, clazz2, TypeConverterException.EReason.CONVERSION_FAILED, runtimeException);
        }
        if (object2 == null) {
            CONDLOG.warn(() -> "Type conversion from '" + String.valueOf(object) + "' of class '" + clazz.getName() + "' to '" + clazz2.getName() + "' with converter '" + iTypeConverter.toString() + "' failed; null was returned from converter!");
            throw new TypeConverterException(clazz, clazz2, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return object2;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(@Nonnull ITypeConverterProvider iTypeConverterProvider, @Nullable Object object, @Nonnull Class<DSTTYPE> clazz) {
        Class<?> clazz2;
        ValueEnforcer.notNull(iTypeConverterProvider, "TypeConverterProvider");
        ValueEnforcer.notNull(clazz, "DstClass");
        if (object == null) {
            return null;
        }
        Class<?> clazz3 = object.getClass();
        Object object2 = ClassHelper.areConvertibleClasses(clazz3, clazz2 = TypeConverter._getUsableClass(clazz)) ? object : TypeConverter._performConversion(iTypeConverterProvider, clazz3, clazz2, object);
        return GenericReflection.uncheckedCast(object2);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(@Nullable Object object, @Nonnull Class<DSTTYPE> clazz, @Nullable DSTTYPE DSTTYPE) {
        return TypeConverter.convert(TypeConverterProviderBestMatch.getInstance(), object, clazz, DSTTYPE);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(@Nonnull ITypeConverterProvider iTypeConverterProvider, @Nullable Object object, @Nonnull Class<DSTTYPE> clazz, @Nullable DSTTYPE DSTTYPE) {
        try {
            return TypeConverter.convert(TypeConverterProviderBestMatch.getInstance(), object, clazz);
        }
        catch (TypeConverterException typeConverterException) {
            return DSTTYPE;
        }
    }
}

