/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mjiip.v_2_3;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.xmlschema.parser.SchemaConstraintChecker;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jvnet.jaxb2.maven2.IOptionsFactory;
import org.jvnet.jaxb2.maven2.RawXJC2Mojo;
import org.jvnet.mjiip.v_2_3.LoggingCodeWriter;
import org.jvnet.mjiip.v_2_3.LoggingErrorReceiver;
import org.jvnet.mjiip.v_2_3.OptionsFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class XJC23Mojo
extends RawXJC2Mojo<Options> {
    private final IOptionsFactory<Options> optionsFactory = new OptionsFactory();

    protected IOptionsFactory<Options> getOptionsFactory() {
        return this.optionsFactory;
    }

    public void doExecute(Options options) throws MojoExecutionException {
        Model model = this.loadModel(options);
        Outline outline = this.generateCode(model);
        this.writeCode(outline);
    }

    protected Model loadModel(Options options) throws MojoExecutionException {
        Object[] objectArray;
        if (this.getVerbose()) {
            objectArray = options.getGrammars();
            this.getLog().debug((CharSequence)("Parsing " + objectArray.length + " input schema(s)..."));
            this.getLog().debug((CharSequence)("Input schemas: " + Arrays.toString(objectArray)));
            for (Object object : objectArray) {
                this.getLog().debug((CharSequence)"  Next InputSource");
                if (((InputSource)object).getPublicId() != null) {
                    this.getLog().debug((CharSequence)("    publicID: " + ((InputSource)object).getPublicId()));
                }
                if (((InputSource)object).getSystemId() != null) {
                    this.getLog().debug((CharSequence)("    systemID: " + ((InputSource)object).getSystemId()));
                }
                if (((InputSource)object).getEncoding() == null) continue;
                this.getLog().debug((CharSequence)("    encoding: " + ((InputSource)object).getEncoding()));
            }
            this.getLog().debug((CharSequence)("Entity resolver: " + options.entityResolver));
        }
        objectArray = new LoggingErrorReceiver("Error while parsing schema(s).", this.getLog(), this.getVerbose());
        Model model = options.getGrammars();
        this.getLog().debug((CharSequence)"Starting SchemaConstraintChecker");
        if (!SchemaConstraintChecker.check((InputSource[])model, (ErrorReceiver)objectArray, (EntityResolver)this.getEntityResolver(), (boolean)false)) {
            this.getLog().error((CharSequence)"SchemaConstraintChecker failed");
        } else {
            this.getLog().debug((CharSequence)"SchemaConstraintChecker finished successfully");
        }
        model = ModelLoader.load((Options)options, (JCodeModel)new JCodeModel(), (ErrorReceiver)objectArray);
        if (model == null) {
            throw new MojoExecutionException("Unable to parse input schema(s). Error messages should have been provided.");
        }
        try {
            Field field = model.getClass().getDeclaredField("schemaComponent");
            XSSchemaSet xSSchemaSet = (XSSchemaSet)field.get(model);
            if (this.getVerbose()) {
                this.getLog().info((CharSequence)("schemaComponent = " + xSSchemaSet));
            }
            if (xSSchemaSet != null) {
                Object object;
                object = xSSchemaSet.iterateSchema();
                while (object.hasNext()) {
                    XSSchema xSSchema = (XSSchema)object.next();
                    if (!this.getVerbose()) continue;
                    this.getLog().info((CharSequence)("  XSSchema = " + xSSchema));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return model;
    }

    protected Outline generateCode(Model model) throws MojoExecutionException {
        Outline outline;
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Compiling input schema(s)...");
        }
        if ((outline = model.generateCode(model.options, (ErrorReceiver)new LoggingErrorReceiver("Error while generating code.", this.getLog(), this.getVerbose()))) == null) {
            throw new MojoExecutionException("Failed to compile input schema(s)! Error messages should have been provided.");
        }
        return outline;
    }

    protected void writeCode(Outline outline) throws MojoExecutionException {
        if (this.getWriteCode()) {
            Model model = outline.getModel();
            JCodeModel jCodeModel = model.codeModel;
            File file = model.options.targetDir;
            if (this.getVerbose()) {
                this.getLog().info((CharSequence)MessageFormat.format("Writing output to [{0}].", file.getAbsolutePath()));
            }
            try {
                if (this.getCleanPackageDirectories()) {
                    if (this.getVerbose()) {
                        this.getLog().info((CharSequence)"Cleaning package directories.");
                    }
                    this.cleanPackageDirectories(file, jCodeModel);
                }
                LoggingCodeWriter loggingCodeWriter = new LoggingCodeWriter(model.options.createCodeWriter(), this.getLog(), this.getVerbose());
                jCodeModel.build((CodeWriter)loggingCodeWriter);
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Unable to write files: " + iOException.getMessage(), (Exception)iOException);
            }
        } else {
            this.getLog().info((CharSequence)"The [writeCode] setting is set to false, the code will not be written.");
        }
    }

    private void cleanPackageDirectories(File file, JCodeModel jCodeModel) {
        Iterator iterator = jCodeModel.packages();
        while (iterator.hasNext()) {
            JPackage jPackage = (JPackage)iterator.next();
            File file2 = jPackage.isUnnamed() ? file : new File(file, jPackage.name().replace('.', File.separatorChar));
            if (!file2.isDirectory()) continue;
            if (XJC23Mojo.isRelevantPackage(jPackage)) {
                if (this.getVerbose()) {
                    this.getLog().info((CharSequence)MessageFormat.format("Cleaning directory [{0}] of the package [{1}].", file2.getAbsolutePath(), jPackage.name()));
                }
                this.cleanPackageDirectory(file2);
                continue;
            }
            if (!this.getVerbose()) continue;
            this.getLog().info((CharSequence)MessageFormat.format("Skipping directory [{0}] of the package [{1}] as it does not contain generated classes or resources.", file2.getAbsolutePath(), jPackage.name()));
        }
    }

    private static boolean isRelevantPackage(JPackage jPackage) {
        if (jPackage.propertyFiles().hasNext()) {
            return true;
        }
        Iterator iterator = jPackage.classes();
        while (iterator.hasNext()) {
            JDefinedClass jDefinedClass = (JDefinedClass)iterator.next();
            if (jDefinedClass.isHidden()) continue;
            return true;
        }
        return false;
    }
}

