/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.jaxws.AbstractWsGenMojo;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="wsgen", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class MainWsGenMojo
extends AbstractWsGenMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File destDir;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/wsgen")
    private File sourceDestDir;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/wsdl")
    private File resourceDestDir;
    @Parameter(defaultValue="**/*")
    private String includeFiles;
    @Parameter(defaultValue="**/.svn/**, **/.git/**")
    private String excludeFiles;

    @Override
    protected File getDestDir() {
        return this.destDir;
    }

    @Override
    protected File getSourceDestDir() {
        return this.sourceDestDir;
    }

    @Override
    protected File getResourceDestDir() {
        return this.resourceDestDir;
    }

    @Override
    protected File getDefaultSrcOut() {
        return new File(this.project.getBuild().getDirectory(), "generated-sources/wsgen");
    }

    @Override
    protected File getClassesDir() {
        return new File(this.project.getBuild().getOutputDirectory());
    }

    @Override
    public void executeJaxws() throws MojoExecutionException, MojoFailureException {
        super.executeJaxws();
        if (this.genWsdl) {
            try {
                this.attachWsdl();
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Failed to execute wsgen", (Exception)iOException);
            }
        }
    }

    private void attachWsdl() throws IOException {
        File file = new File(this.project.getBuild().getDirectory());
        if (!"war".equalsIgnoreCase(this.project.getPackaging())) {
            file = new File(this.project.getBuild().getOutputDirectory(), "META-INF/wsdl");
        } else {
            String string = null;
            Plugin plugin = (Plugin)this.project.getBuild().getPluginsAsMap().get("org.apache.maven.plugins:maven-war-plugin");
            for (PluginExecution pluginExecution : plugin.getExecutions()) {
                String string2 = this.getWebappDirectory(pluginExecution.getConfiguration());
                if (string2 == null) continue;
                string = string2;
                break;
            }
            if (string == null) {
                string = this.getWebappDirectory(plugin.getConfiguration());
            }
            file = string != null ? new File(string) : new File(file, this.project.getBuild().getFinalName());
            file = new File(file, "WEB-INF/wsdl");
        }
        if (!file.mkdirs() && !file.exists()) {
            this.getLog().warn((CharSequence)("Cannot create directory: " + file.getAbsolutePath()));
        }
        this.getLog().debug((CharSequence)("Packaging WSDL(s) to: " + file));
        FileUtils.copyDirectory((File)this.getResourceDestDir(), (File)file, (String)this.includeFiles, (String)this.excludeFiles);
    }

    private String getWebappDirectory(Object object) {
        if (object == null) {
            return null;
        }
        Xpp3Dom xpp3Dom = ((Xpp3Dom)object).getChild("webappDirectory");
        return xpp3Dom != null ? xpp3Dom.getValue() : null;
    }
}

