/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.alm.octane;

import com.hpe.alm.octane.infra.ErrorHandler;
import com.hpe.alm.octane.infra.FeatureElement;
import com.hpe.alm.octane.infra.OutputFile;
import com.hpe.alm.octane.infra.StepElement;
import com.hpe.alm.octane.infra.TestSourcesModel;
import com.hpe.alm.octane.infra.TestTracker;
import cucumber.api.PickleStepTestStep;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import gherkin.pickles.PickleTag;
import java.net.URL;
import java.time.Instant;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OctaneGherkinFormatter
implements EventListener {
    private OutputFile outputFile;
    private TestSourcesModel testSources = new TestSourcesModel();
    private TestTracker testTracker = new TestTracker();

    public OctaneGherkinFormatter(URL output) {
        this.outputFile = new OutputFile(output);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this::handleSourceRead);
        publisher.registerHandlerFor(TestCaseStarted.class, this::handleCaseStarted);
        publisher.registerHandlerFor(TestStepStarted.class, this::handleStepStarted);
        publisher.registerHandlerFor(TestStepFinished.class, this::handleStepFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::handleRunFinished);
    }

    private void handleSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleCaseStarted(TestCaseStarted event) {
        if (this.testTracker.getCurrentFeature() == null || !this.testTracker.getCurrentFeature().getPath().equals(event.testCase.getUri())) {
            FeatureElement feature = new FeatureElement();
            feature.setPath(event.testCase.getUri());
            feature.setStarted(Instant.now().toEpochMilli());
            feature.setFileContent(this.testSources.getFeatureFileContent(event.testCase.getUri()));
            feature.setName(this.testSources.getFeatureName(event.testCase.getUri()));
            for (PickleTag tag : event.testCase.getTags()) {
                if (!tag.getName().startsWith("@TID")) continue;
                feature.setTag(tag.getName());
                break;
            }
            this.testTracker.setCurrentFeature(feature);
        }
        this.testTracker.setCurrentScenario(event.testCase.getName());
    }

    private void handleStepStarted(TestStepStarted event) {
        if (event.testStep instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.testStep;
            String keyword = this.testSources.getKeywordFromSource(this.testTracker.getCurrentFeature().getPath(), testStep.getStepLine());
            String stepName = keyword + testStep.getStepText();
            this.testTracker.setCurrentStep(new StepElement(stepName));
        }
    }

    private void handleStepFinished(TestStepFinished event) {
        if (event.testStep instanceof PickleStepTestStep) {
            this.testTracker.getCurrentStep().setDuration(event.result.getDuration());
            this.testTracker.getCurrentStep().setStatus(event.result.getStatus().lowerCaseName());
            if (event.result.getErrorMessage() != null) {
                this.testTracker.getCurrentStep().setErrorMessage(event.result.getErrorMessage());
            }
        }
    }

    private void handleRunFinished(TestRunFinished event) {
        Document doc = this.getDocument();
        Element rootElement = doc.createElement("features");
        rootElement.setAttribute("version", "1");
        doc.appendChild(rootElement);
        this.testTracker.getFeatures().forEach(featureElement -> rootElement.appendChild(featureElement.toXMLElement(doc)));
        this.outputFile.write(doc);
    }

    private Document getDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            ErrorHandler.error("Failed to create result xml document.", e);
            return null;
        }
    }
}

