/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.alm.octane.infra;

import com.hpe.alm.octane.infra.ErrorHandler;
import com.hpe.alm.octane.infra.ResultFileOutputStream;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class OutputFile {
    URL url;

    public OutputFile(URL url) {
        this.url = url;
    }

    public void write(Document doc) {
        try (ResultFileOutputStream outputStream = new ResultFileOutputStream(this.url);){
            DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
            LSSerializer serializer = impl.createLSSerializer();
            serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            LSOutput output = impl.createLSOutput();
            output.setByteStream(outputStream);
            serializer.write(doc, output);
        }
        catch (Exception e) {
            ErrorHandler.error("Failed to write the result XML to the file system.", e);
        }
    }
}

