/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.alm.octane.infra;

import com.hpe.alm.octane.infra.ErrorHandler;
import cucumber.api.event.TestSourceRead;
import gherkin.AstBuilder;
import gherkin.GherkinDialect;
import gherkin.GherkinDialectProvider;
import gherkin.Parser;
import gherkin.ParserException;
import gherkin.TokenMatcher;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Node;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableRow;
import java.util.HashMap;
import java.util.Map;

public class TestSourcesModel {
    private final Map<String, TestSourceRead> pathToReadEventMap = new HashMap<String, TestSourceRead>();
    private final Map<String, GherkinDocument> pathToAstMap = new HashMap<String, GherkinDocument>();
    private final Map<String, Map<Integer, AstNode>> pathToNodeMap = new HashMap<String, Map<Integer, AstNode>>();

    public void addTestSourceReadEvent(String path, TestSourceRead event) {
        this.pathToReadEventMap.put(path, event);
    }

    Feature getFeature(String path) {
        if (!this.pathToAstMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        return this.pathToAstMap.containsKey(path) ? this.pathToAstMap.get(path).getFeature() : null;
    }

    public String getKeywordFromSource(String uri, int stepLine) {
        Feature feature = this.getFeature(uri);
        if (feature != null) {
            TestSourceRead event = this.getTestSourceReadEvent(uri);
            String trimmedSourceLine = event.source.split("\n")[stepLine - 1].trim();
            GherkinDialect dialect = new GherkinDialectProvider(feature.getLanguage()).getDefaultDialect();
            for (String keyword : dialect.getStepKeywords()) {
                if (!trimmedSourceLine.startsWith(keyword)) continue;
                return keyword;
            }
        }
        return "";
    }

    private TestSourceRead getTestSourceReadEvent(String uri) {
        return this.pathToReadEventMap.getOrDefault(uri, null);
    }

    public String getFeatureFileContent(String uri) {
        return this.pathToReadEventMap.containsKey(uri) ? this.pathToReadEventMap.get((Object)uri).source : null;
    }

    public String getFeatureName(String uri) {
        Feature feature = this.getFeature(uri);
        return feature != null ? feature.getName() : "";
    }

    private void parseGherkinSource(String path) {
        if (this.pathToReadEventMap.containsKey(path)) {
            Parser parser = new Parser((Parser.Builder)new AstBuilder());
            TokenMatcher matcher = new TokenMatcher();
            try {
                GherkinDocument gherkinDocument = (GherkinDocument)parser.parse(this.pathToReadEventMap.get((Object)path).source, (Parser.ITokenMatcher)matcher);
                this.pathToAstMap.put(path, gherkinDocument);
                HashMap<Integer, AstNode> nodeMap = new HashMap<Integer, AstNode>();
                AstNode currentParent = new AstNode((Node)gherkinDocument.getFeature(), null);
                for (ScenarioDefinition child : gherkinDocument.getFeature().getChildren()) {
                    this.processScenarioDefinition(nodeMap, child, currentParent);
                }
                this.pathToNodeMap.put(path, nodeMap);
            }
            catch (ParserException e) {
                ErrorHandler.error("Failed to parse gherkin source", (Exception)((Object)e));
            }
        }
    }

    private void processScenarioDefinition(Map<Integer, AstNode> nodeMap, ScenarioDefinition child, AstNode currentParent) {
        AstNode childNode = new AstNode((Node)child, currentParent);
        nodeMap.put(child.getLocation().getLine(), childNode);
        for (Step step : child.getSteps()) {
            nodeMap.put(step.getLocation().getLine(), new AstNode((Node)step, childNode));
        }
        if (child instanceof ScenarioOutline) {
            this.processScenarioOutlineExamples(nodeMap, (ScenarioOutline)child, childNode);
        }
    }

    private void processScenarioOutlineExamples(Map<Integer, AstNode> nodeMap, ScenarioOutline scenarioOutline, AstNode childNode) {
        for (Examples examples : scenarioOutline.getExamples()) {
            AstNode examplesNode = new AstNode((Node)examples, childNode);
            TableRow headerRow = examples.getTableHeader();
            AstNode headerNode = new AstNode((Node)headerRow, examplesNode);
            nodeMap.put(headerRow.getLocation().getLine(), headerNode);
            for (int i = 0; i < examples.getTableBody().size(); ++i) {
                TableRow examplesRow = (TableRow)examples.getTableBody().get(i);
                ExamplesRowWrapperNode rowNode = new ExamplesRowWrapperNode((Node)examplesRow, i);
                AstNode expandedScenarioNode = new AstNode(rowNode, examplesNode);
                nodeMap.put(examplesRow.getLocation().getLine(), expandedScenarioNode);
            }
        }
    }

    class ExamplesRowWrapperNode
    extends Node {
        final int bodyRowIndex;

        ExamplesRowWrapperNode(Node examplesRow, int bodyRowIndex) {
            super(examplesRow.getLocation());
            this.bodyRowIndex = bodyRowIndex;
        }
    }

    class AstNode {
        final Node node;
        final AstNode parent;

        AstNode(Node node, AstNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }
}

