/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.alm.octane.infra;

import com.hpe.alm.octane.infra.ErrorHandler;
import com.hpe.alm.octane.infra.FeatureElement;
import com.hpe.alm.octane.infra.ScenarioElement;
import com.hpe.alm.octane.infra.StepElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestTracker {
    private List<FeatureElement> features = new ArrayList<FeatureElement>();
    private FeatureElement currentFeature;
    private ScenarioElement currentScenario;
    private int outlineIndex = 0;

    public void setCurrentFeature(FeatureElement feature) {
        this.features.add(feature);
        this.currentFeature = feature;
    }

    public FeatureElement getCurrentFeature() {
        return this.currentFeature;
    }

    public void setCurrentScenario(String scenarioName) {
        if (this.isOutlineScenario(scenarioName)) {
            if (this.isFirstOutlineScenario(this.currentScenario)) {
                this.currentScenario.setOutlineIndex(++this.outlineIndex);
            }
            this.currentScenario = new ScenarioElement(scenarioName, ++this.outlineIndex);
        } else {
            this.outlineIndex = 0;
            this.currentScenario = new ScenarioElement(scenarioName, this.outlineIndex);
        }
        this.currentFeature.addScenario(this.currentScenario);
    }

    private boolean isOutlineScenario(String scenarioName) {
        return this.currentScenario != null && this.currentScenario.getName().equals(scenarioName);
    }

    private boolean isFirstOutlineScenario(ScenarioElement scenario) {
        return scenario.getOutlineIndex() == 0;
    }

    public void setCurrentStep(StepElement step) {
        if (this.currentScenario == null) {
            ErrorHandler.error("Flow error - Tried to set step when there is no current scenario");
        }
        this.currentScenario.addStep(step);
    }

    public StepElement getCurrentStep() {
        if (this.currentScenario == null) {
            ErrorHandler.error("Flow error - Tried to get current step when there is no current scenario");
        }
        if (this.currentScenario.getSteps().size() < 1) {
            ErrorHandler.error("Flow error - Tried to get current step when there are no steps in the current scenario");
        }
        return this.currentScenario.getSteps().get(this.currentScenario.getSteps().size() - 1);
    }

    public List<FeatureElement> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }
}

