/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.maven.plugin.targets;

import com.hcl.appscan.maven.plugin.IMavenConstants;
import com.hcl.appscan.maven.plugin.targets.MavenJavaTarget;
import com.hcl.appscan.maven.plugin.util.MavenUtil;
import com.hcl.appscan.sdk.scanners.sast.targets.JEETarget;
import java.io.File;
import org.apache.maven.project.MavenProject;

public class MavenJEETarget
extends JEETarget
implements IMavenConstants {
    private static String DEFAULT_JSP_COMPILER = "Default Tomcat JSP Compiler";
    private MavenProject m_project;
    private MavenJavaTarget m_target;

    public MavenJEETarget(MavenProject project) {
        this.m_project = project;
        this.m_target = new MavenJavaTarget(project);
    }

    public String getJSPCompiler() {
        String jspCompiler = System.getProperty("jspCompiler");
        if (jspCompiler != null && jspCompiler != "true" && !jspCompiler.trim().isEmpty()) {
            return jspCompiler;
        }
        return DEFAULT_JSP_COMPILER;
    }

    public File getTargetFile() {
        String packaging = this.m_project.getPackaging();
        String finalName = null;
        String extension = "." + packaging;
        if (packaging.equalsIgnoreCase("war")) {
            finalName = MavenUtil.getPluginConfigurationProperty(this.m_project, "org.apache.maven.plugins:maven-war-plugin", "warName");
            extension = ".war";
        } else if (packaging.equalsIgnoreCase("ear")) {
            finalName = MavenUtil.getPluginConfigurationProperty(this.m_project, "org.apache.maven.plugins:maven-ear-plugin", "finalName");
            extension = ".ear";
        }
        if (finalName == null) {
            finalName = this.m_project.getBuild().getFinalName();
        }
        return new File(this.m_project.getBuild().getDirectory(), finalName + extension);
    }

    public String getClasspath() {
        return this.m_target.getClasspath();
    }

    public String getJava() {
        return this.m_target.getJava();
    }
}

