/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.maven.plugin.targets;

import com.hcl.appscan.maven.plugin.IMavenConstants;
import com.hcl.appscan.maven.plugin.targets.TargetFactory;
import com.hcl.appscan.sdk.scanners.sast.targets.ISASTTarget;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;

public class MavenTarget
implements ISASTTarget,
IMavenConstants {
    private MavenProject m_project;
    private ISASTTarget m_target;

    public MavenTarget(MavenProject project) {
        this.m_project = project;
        this.m_target = TargetFactory.create(project);
    }

    public MavenProject getProject() {
        return this.m_project;
    }

    public String getTarget() {
        return this.m_target.getTarget();
    }

    public Set<String> getExclusionPatterns() {
        return this.m_target.getExclusionPatterns();
    }

    public Set<String> getInclusionPatterns() {
        return this.m_target.getInclusionPatterns();
    }

    public boolean outputsOnly() {
        return this.m_target.outputsOnly();
    }

    public File getTargetFile() {
        return this.m_target.getTargetFile();
    }

    public Map<String, String> getProperties() {
        Map buildInfos = this.m_target.getProperties();
        buildInfos.put("src_root", this.getSourceDirs());
        return buildInfos;
    }

    protected String getSourceDirs() {
        String sourceDirs = "";
        for (String root : this.m_project.getCompileSourceRoots()) {
            sourceDirs = sourceDirs + root + File.pathSeparator;
        }
        if (sourceDirs.endsWith(File.pathSeparator)) {
            return sourceDirs.substring(0, sourceDirs.length() - 1);
        }
        return sourceDirs;
    }
}

