/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.jdbc.JdbcDatabaseConnection;
import com.j256.ormlite.jdbc.db.DatabaseTypeUtils;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.IOUtils;
import com.j256.ormlite.support.BaseConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseConnectionProxyFactory;
import java.io.Closeable;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class JdbcConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    private static Logger logger = LoggerFactory.getLogger(JdbcConnectionSource.class);
    private String url;
    private String username;
    private String password;
    protected DatabaseConnection connection;
    protected DatabaseType databaseType;
    protected boolean initialized = false;
    private static DatabaseConnectionProxyFactory connectionProxyFactory;

    public JdbcConnectionSource() {
    }

    public JdbcConnectionSource(String url) throws SQLException {
        this(url, null, null, null);
    }

    public JdbcConnectionSource(String url, DatabaseType databaseType) throws SQLException {
        this(url, null, null, databaseType);
    }

    public JdbcConnectionSource(String url, String username, String password) throws SQLException {
        this(url, username, password, null);
    }

    public JdbcConnectionSource(String url, String username, String password, DatabaseType databaseType) throws SQLException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.databaseType = databaseType;
        this.initialize();
    }

    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.url == null) {
            throw new SQLException("url was never set on " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        if (this.databaseType == null) {
            this.databaseType = DatabaseTypeUtils.createDatabaseType(this.url);
        }
        this.databaseType.loadDriver();
        this.databaseType.setDriver(DriverManager.getDriver(this.url));
        this.initialized = true;
    }

    public void close() throws IOException {
        if (!this.initialized) {
            throw new IOException(((Object)((Object)this)).getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.connection != null) {
            this.connection.close();
            logger.debug("closed connection #{}", (Object)this.connection.hashCode());
            this.connection = null;
        }
    }

    public void closeQuietly() {
        IOUtils.closeQuietly((Closeable)((Object)this));
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DatabaseConnection getReadOnlyConnection(String tableName) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(((Object)((Object)this)).getClass().getSimpleName() + " was not initialized properly");
        }
        return this.getReadWriteConnection(tableName);
    }

    public DatabaseConnection getReadWriteConnection(String tableName) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(((Object)((Object)this)).getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                throw new SQLException("Connection has already been closed");
            }
            return this.connection;
        }
        this.connection = this.makeConnection(logger);
        return this.connection;
    }

    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(((Object)((Object)this)).getClass().getSimpleName() + " was not initialized properly");
        }
    }

    public boolean saveSpecialConnection(DatabaseConnection connection) throws SQLException {
        return true;
    }

    public void clearSpecialConnection(DatabaseConnection connection) {
    }

    public DatabaseType getDatabaseType() {
        if (!this.initialized) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " was not initialized properly");
        }
        return this.databaseType;
    }

    public boolean isOpen(String tableName) {
        return this.connection != null;
    }

    public boolean isSingleConnection(String tableName) {
        return true;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public static void setDatabaseConnectionProxyFactory(DatabaseConnectionProxyFactory connectionProxyFactory) {
        JdbcConnectionSource.connectionProxyFactory = connectionProxyFactory;
    }

    protected DatabaseConnection makeConnection(Logger logger) throws SQLException {
        Properties properties = new Properties();
        if (this.username != null) {
            properties.setProperty("user", this.username);
        }
        if (this.password != null) {
            properties.setProperty("password", this.password);
        }
        JdbcDatabaseConnection connection = new JdbcDatabaseConnection(DriverManager.getConnection(this.url, properties));
        connection.setAutoCommit(true);
        if (connectionProxyFactory != null) {
            connection = connectionProxyFactory.createProxy((DatabaseConnection)connection);
        }
        logger.debug("opened connection to {} got #{}", (Object)this.url, (Object)connection.hashCode());
        return connection;
    }
}

