/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.jdbc.JdbcDatabaseConnection;
import com.j256.ormlite.jdbc.db.DatabaseTypeUtils;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.IOUtils;
import com.j256.ormlite.support.BaseConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    private static Logger logger = LoggerFactory.getLogger(DataSourceConnectionSource.class);
    private DataSource dataSource;
    private DatabaseType databaseType;
    private String databaseUrl;
    private boolean initialized;
    private boolean isSingleConnection;

    public DataSourceConnectionSource() {
    }

    public DataSourceConnectionSource(DataSource dataSource, String databaseUrl) throws SQLException {
        this.dataSource = dataSource;
        this.databaseUrl = databaseUrl;
        this.initialize();
    }

    public DataSourceConnectionSource(DataSource dataSource, DatabaseType databaseType) throws SQLException {
        this.dataSource = dataSource;
        this.databaseType = databaseType;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.dataSource == null) {
            throw new IllegalStateException("dataSource was never set on " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        if (this.databaseType == null) {
            if (this.databaseUrl == null) {
                throw new IllegalStateException("either the databaseUri or the databaseType must be set on " + ((Object)((Object)this)).getClass().getSimpleName());
            }
            this.databaseType = DatabaseTypeUtils.createDatabaseType(this.databaseUrl);
        }
        this.databaseType.loadDriver();
        if (this.databaseUrl != null) {
            this.databaseType.setDriver(DriverManager.getDriver(this.databaseUrl));
        }
        JdbcDatabaseConnection jdbcConn1 = null;
        JdbcDatabaseConnection jdbcConn2 = null;
        try {
            Connection conn1 = this.dataSource.getConnection();
            Connection conn2 = this.dataSource.getConnection();
            if (conn1 == null || conn2 == null) {
                this.isSingleConnection = true;
            } else {
                jdbcConn1 = new JdbcDatabaseConnection(conn1);
                jdbcConn2 = new JdbcDatabaseConnection(conn2);
                this.isSingleConnection = this.isSingleConnection(jdbcConn1, jdbcConn2);
            }
        }
        finally {
            IOUtils.closeQuietly(jdbcConn1);
            IOUtils.closeQuietly(jdbcConn2);
        }
        this.initialized = true;
    }

    public DatabaseConnection getReadOnlyConnection(String tableName) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(((Object)((Object)this)).getClass().getSimpleName() + ".initialize() was not called");
        }
        return this.getReadWriteConnection(tableName);
    }

    public DatabaseConnection getReadOnlyConnection(String tableName, String username, String password) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(((Object)((Object)this)).getClass().getSimpleName() + ".initialize() was not called");
        }
        return this.getReadWriteConnection(tableName, username, password);
    }

    public DatabaseConnection getReadWriteConnection(String tableName) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(((Object)((Object)this)).getClass().getSimpleName() + ".initialize() was not called");
        }
        DatabaseConnection saved = this.getSavedConnection();
        if (saved != null) {
            return saved;
        }
        return new JdbcDatabaseConnection(this.dataSource.getConnection());
    }

    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(((Object)((Object)this)).getClass().getSimpleName() + ".initialize() was not called");
        }
        if (!this.isSavedConnection(connection)) {
            IOUtils.closeThrowSqlException((Closeable)connection, (String)"SQL connection");
        }
    }

    public DatabaseConnection getReadWriteConnection(String tableName, String username, String password) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(((Object)((Object)this)).getClass().getSimpleName() + ".initialize() was not called");
        }
        DatabaseConnection saved = this.getSavedConnection();
        if (saved != null) {
            return saved;
        }
        return new JdbcDatabaseConnection(this.dataSource.getConnection(username, password));
    }

    public boolean saveSpecialConnection(DatabaseConnection connection) throws SQLException {
        return this.saveSpecial(connection);
    }

    public void clearSpecialConnection(DatabaseConnection connection) {
        this.clearSpecial(connection, logger);
    }

    public void close() throws IOException {
        if (!this.initialized) {
            throw new IOException(((Object)((Object)this)).getClass().getSimpleName() + ".initialize() was not called");
        }
    }

    public void closeQuietly() {
        IOUtils.closeQuietly((Closeable)((Object)this));
    }

    public DatabaseType getDatabaseType() {
        if (!this.initialized) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + ".initialize() was not called");
        }
        return this.databaseType;
    }

    public boolean isOpen(String tableName) {
        return true;
    }

    public boolean isSingleConnection(String tableName) {
        return this.isSingleConnection;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }
}

