/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.aj.LogHelper;
import com.jcabi.aspects.aj.MethodCacher;
import com.jcabi.aspects.aj.NamedThreads;
import com.jcabi.log.VerboseRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class UpdateMethodCacher {
    private final transient ConcurrentMap<MethodCacher.Key, MethodCacher.Tunnel> tunnels;
    private final transient ScheduledExecutorService cleaner;
    private final transient BlockingQueue<MethodCacher.Key> updatekeys;
    private final transient ScheduledExecutorService updater;

    public UpdateMethodCacher(ConcurrentMap<MethodCacher.Key, MethodCacher.Tunnel> tls, BlockingQueue<MethodCacher.Key> ukeys) {
        this.tunnels = tls;
        this.updatekeys = ukeys;
        this.cleaner = Executors.newSingleThreadScheduledExecutor(new NamedThreads("cacheable-clean", "automated cleaning of expired @Cacheable values"));
        this.updater = Executors.newSingleThreadScheduledExecutor(new NamedThreads("cacheable-update", "async update of expired @Cacheable values"));
    }

    public void start() {
        this.cleaner.scheduleWithFixedDelay(new VerboseRunnable(new Runnable(){

            @Override
            public void run() {
                UpdateMethodCacher.this.clean();
            }
        }), 1L, 1L, TimeUnit.SECONDS);
        this.updater.schedule(new VerboseRunnable(new Runnable(){

            @Override
            public void run() {
                UpdateMethodCacher.this.update();
            }
        }), 0L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        ConcurrentMap<MethodCacher.Key, MethodCacher.Tunnel> concurrentMap = this.tunnels;
        synchronized (concurrentMap) {
            for (MethodCacher.Key key : this.tunnels.keySet()) {
                if (!((MethodCacher.Tunnel)this.tunnels.get(key)).expired() || ((MethodCacher.Tunnel)this.tunnels.get(key)).asyncUpdate()) continue;
                MethodCacher.Tunnel tunnel = (MethodCacher.Tunnel)this.tunnels.remove(key);
                LogHelper.log(key.getLevel(), this, "%s:%s expired in cache", key, tunnel);
            }
        }
    }

    private void update() {
        while (true) {
            try {
                while (true) {
                    MethodCacher.Key key;
                    MethodCacher.Tunnel tunnel;
                    if ((tunnel = (MethodCacher.Tunnel)this.tunnels.get(key = this.updatekeys.take())) == null || !tunnel.expired()) {
                        continue;
                    }
                    MethodCacher.Tunnel newTunnel = tunnel.copy();
                    newTunnel.through();
                    this.tunnels.put(key, newTunnel);
                }
            }
            catch (InterruptedException ex) {
                LogHelper.log(4, this, "%s:%s", ex.getMessage(), ex);
                continue;
            }
            catch (Throwable ex) {
                LogHelper.log(4, this, "Exception message is %s, Exception is %s", ex.getMessage(), ex);
                continue;
            }
            break;
        }
    }
}

