/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.Pull;
import com.jcabi.github.PullComment;
import com.jcabi.github.PullComments;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkPullComment;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.xembly.Directives;

@Immutable
final class MkPullComments
implements PullComments {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates repo;
    private final transient Pull owner;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    MkPullComments(MkStorage stg, String login, Coordinates rep, Pull pull) throws IOException {
        MkStorage mkStorage = stg;
        String string = login;
        Coordinates coordinates = rep;
        Pull pull2 = pull;
        Object[] objectArray = new Object[]{mkStorage, string, coordinates, pull2};
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, objectArray);
        try {
            JoinPoint joinPoint2 = Factory.makeJP(ajc$tjp_0, this, this);
            try {
            }
            finally {
                ImmutabilityChecker.aspectOf().after(joinPoint2);
            }
            this.storage = stg;
            this.self = login;
            this.repo = rep;
            this.owner = pull;
            this.storage.apply(new Directives().xpath(String.format("/github/repos/repo[@coords='%s']/pulls/pull[number='%d']", this.repo, this.owner.number())).addIf("comments"));
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    @Override
    public Pull pull() {
        return this.owner;
    }

    @Override
    public PullComment get(int number) {
        return new MkPullComment(this.storage, this.repo, this.owner, number);
    }

    @Override
    public Iterable<PullComment> iterate(Map<String, String> params) {
        return new MkIterable<PullComment>(this.storage, String.format("/github/repos/repo[@coords='%s']/pulls/pull/comments", this.repo), new MkIterable.Mapping<PullComment>(){

            @Override
            public PullComment map(XML xml) {
                return MkPullComments.this.get(Integer.parseInt(xml.xpath("comment/id/text()").get(0)));
            }
        });
    }

    @Override
    public Iterable<PullComment> iterate(int number, Map<String, String> params) {
        return new MkIterable<PullComment>(this.storage, String.format("%s/comment", this.xpath()), new MkIterable.Mapping<PullComment>(){

            @Override
            public PullComment map(XML xml) {
                return MkPullComments.this.get(Integer.parseInt(xml.xpath("id/text()").get(0)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PullComment post(String body, String commit, String path, int position) throws IOException {
        int number;
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().nodes(String.format("%s/comment/id/text()", this.xpath())).size();
            this.storage.apply(new Directives().xpath(this.xpath()).add("comment").add("id").set(Integer.toString(number)).up().add("url").set("http://localhost/1").up().add("diff_hunk").set("@@ -16,33 +16,40 @@ public...").up().add("path").set(path).up().add("position").set(Integer.toString(position)).up().add("original_position").set(Integer.toString(number)).up().add("commit_id").set(commit).up().add("original_commit_id").set(commit).up().add("body").set(body).up().add("created_at").set(new Github.Time().toString()).up().add("published_at").set(new Github.Time().toString()).up().add("user").add("login").set(this.self).up().add("pull_request_url").set("http://localhost/2").up());
        }
        finally {
            this.storage.unlock();
        }
        return this.get(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PullComment reply(String body, int comment) throws IOException {
        this.storage.lock();
        try {
            JsonObject orig = this.get(comment).json();
            PullComment reply = this.post(body, orig.getString("commit_id"), orig.getString("path"), comment);
            reply.patch(Json.createObjectBuilder().add("original_position", String.valueOf(comment)).build());
            PullComment pullComment = reply;
            return pullComment;
        }
        finally {
            this.storage.unlock();
        }
    }

    @Override
    public void remove(int number) throws IOException {
        this.storage.apply(new Directives().xpath(String.format("%s/comment[id='%d']", this.xpath(), number)).remove());
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/pulls/pull[number='%d']/comments", this.repo, this.owner.number());
    }

    public String toString() {
        return "MkPullComments(storage=" + this.storage + ", self=" + this.self + ", repo=" + this.repo + ", owner=" + this.owner + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkPullComments)) {
            return false;
        }
        MkPullComments other = (MkPullComments)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$repo = this.repo;
        Coordinates other$repo = other.repo;
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        Pull this$owner = this.owner;
        Pull other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $repo = this.repo;
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        Pull $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }

    static {
        MkPullComments.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MkPullComments.java", MkPullComments.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.github.PullComments", "", "", ""), 93);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.jcabi.github.mock.MkPullComments", "com.jcabi.github.mock.MkStorage:java.lang.String:com.jcabi.github.Coordinates:com.jcabi.github.Pull", "stg:login:rep:pull", "java.io.IOException"), 93);
    }
}

