/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@Immutable
public final class CarefulWire
implements Wire {
    private final transient Wire origin;
    private final transient int threshold;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public CarefulWire(Wire wire, int thrshld) {
        Wire wire2 = wire;
        int n = thrshld;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, this, this, wire2, Conversions.intObject(n));
        try {
            JoinPoint joinPoint2 = Factory.makeJP(ajc$tjp_0, this, this);
            try {
            }
            finally {
                ImmutabilityChecker.aspectOf().after(joinPoint2);
            }
            this.origin = wire;
            this.threshold = thrshld;
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        long now;
        long reset;
        Response resp = this.origin.send(req, home, method, headers, content, connect, read);
        int remaining = this.remainingHeader(resp);
        if (remaining < this.threshold && (reset = this.resetHeader(resp)) > (now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()))) {
            long length = reset - now;
            Logger.info(this, "Remaining number of requests per hour is less than %d. Waiting for %d seconds.", this.threshold, length);
            try {
                TimeUnit.SECONDS.sleep(length);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
        }
        return resp;
    }

    private String headerOrNull(Response resp, String headername) {
        List<String> values = resp.headers().get(headername);
        String value = null;
        if (values != null && !values.isEmpty()) {
            value = values.get(0);
        }
        return value;
    }

    private int remainingHeader(Response resp) {
        String remainingstr = this.headerOrNull(resp, "X-RateLimit-Remaining");
        int remaining = Integer.MAX_VALUE;
        if (remainingstr != null) {
            remaining = Integer.parseInt(remainingstr);
        }
        return remaining;
    }

    private long resetHeader(Response resp) {
        String resetstr = this.headerOrNull(resp, "X-RateLimit-Reset");
        long reset = 0L;
        if (resetstr != null) {
            reset = Long.parseLong(resetstr);
        }
        return reset;
    }

    public String toString() {
        return "CarefulWire(origin=" + this.origin + ", threshold=" + this.threshold + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CarefulWire)) {
            return false;
        }
        CarefulWire other = (CarefulWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        return this.threshold == other.threshold;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        result = result * 59 + this.threshold;
        return result;
    }

    static {
        CarefulWire.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CarefulWire.java", CarefulWire.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.http.Wire", "", "", ""), 96);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.github.wire.CarefulWire", "com.jcabi.http.Wire:int", "wire:thrshld", ""), 96);
    }
}

