/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.mock;

import com.jcabi.http.mock.GrizzlyQuery;
import com.jcabi.http.mock.MkAnswer;
import com.jcabi.http.mock.MkQuery;
import com.jcabi.log.Logger;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;

final class MkGrizzlyAdapter
extends GrizzlyAdapter {
    private static final String ENCODING = "UTF-8";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final transient Queue<QueryWithAnswer> queue = new ConcurrentLinkedQueue<QueryWithAnswer>();
    private final transient Queue<Conditional> conditionals = new ConcurrentLinkedQueue<Conditional>();

    MkGrizzlyAdapter() {
    }

    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            GrizzlyQuery query = new GrizzlyQuery(request);
            Iterator iter = this.conditionals.iterator();
            boolean matched = false;
            while (iter.hasNext()) {
                Conditional cond = (Conditional)iter.next();
                if (!cond.matches(query)) continue;
                matched = true;
                MkAnswer answer = cond.answer();
                this.queue.add(new QueryWithAnswer(query, answer));
                for (String name : answer.headers().keySet()) {
                    for (String value : answer.headers().get(name)) {
                        response.addHeader(name, value);
                    }
                }
                response.addHeader("Server", String.format("%s query #%d, %d answer(s) left", ((Object)((Object)this)).getClass().getName(), this.queue.size(), this.conditionals.size()));
                response.setStatus(answer.status());
                byte[] body = answer.body().getBytes(CHARSET);
                response.getStream().write(body);
                response.setContentLength(body.length);
                if (cond.decrement() != 0) break;
                iter.remove();
                break;
            }
            if (!matched) {
                throw new NoSuchElementException("No matching answers found.");
            }
        }
        catch (Throwable ex) {
            MkGrizzlyAdapter.fail(response, ex);
        }
    }

    public void next(MkAnswer answer, Matcher<MkQuery> query, int count) {
        this.conditionals.add(new Conditional(answer, query, count));
    }

    public MkQuery take() {
        return this.queue.remove().que;
    }

    public MkQuery take(Matcher<MkAnswer> matcher) {
        MkQuery result = null;
        Iterator iter = this.queue.iterator();
        while (iter.hasNext()) {
            QueryWithAnswer candidate = (QueryWithAnswer)iter.next();
            if (!matcher.matches(candidate.answer())) continue;
            result = candidate.query();
            iter.remove();
            break;
        }
        if (result == null) {
            throw new NoSuchElementException("No matching results found");
        }
        return result;
    }

    public Collection<MkQuery> takeAll(Matcher<MkAnswer> matcher) {
        LinkedList<MkQuery> results = new LinkedList<MkQuery>();
        Iterator iter = this.queue.iterator();
        while (iter.hasNext()) {
            QueryWithAnswer candidate = (QueryWithAnswer)iter.next();
            if (!matcher.matches(candidate.answer())) continue;
            results.add(candidate.query());
            iter.remove();
        }
        if (results.isEmpty()) {
            throw new NoSuchElementException("No matching results found");
        }
        return results;
    }

    public int queries() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fail(GrizzlyResponse<?> response, Throwable failure) {
        PrintWriter writer;
        response.setStatus(500);
        try {
            writer = new PrintWriter(new OutputStreamWriter(response.getStream(), ENCODING));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        try {
            writer.print(Logger.format("%[exception]s", failure));
        }
        finally {
            writer.close();
        }
    }

    private static final class QueryWithAnswer {
        private final transient MkAnswer answr;
        private final transient MkQuery que;

        QueryWithAnswer(MkQuery qry, MkAnswer ans) {
            this.answr = ans;
            this.que = qry;
        }

        public MkQuery query() {
            return this.que;
        }

        public MkAnswer answer() {
            return this.answr;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryWithAnswer)) {
                return false;
            }
            QueryWithAnswer other = (QueryWithAnswer)o;
            MkAnswer this$answr = this.answr;
            MkAnswer other$answr = other.answr;
            if (this$answr == null ? other$answr != null : !this$answr.equals(other$answr)) {
                return false;
            }
            MkQuery this$que = this.que;
            MkQuery other$que = other.que;
            return !(this$que == null ? other$que != null : !this$que.equals(other$que));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MkAnswer $answr = this.answr;
            result = result * 59 + ($answr == null ? 43 : $answr.hashCode());
            MkQuery $que = this.que;
            result = result * 59 + ($que == null ? 43 : $que.hashCode());
            return result;
        }
    }

    private static final class Conditional {
        private final transient MkAnswer answr;
        private final transient Matcher<MkQuery> condition;
        private final transient AtomicInteger count;

        Conditional(MkAnswer ans, Matcher<MkQuery> matcher, int times) {
            this.answr = ans;
            this.condition = matcher;
            if (times < 1) {
                throw new IllegalArgumentException("Answer must be returned at least once.");
            }
            this.count = new AtomicInteger(times);
        }

        public MkAnswer answer() {
            return this.answr;
        }

        public boolean matches(MkQuery query) {
            return this.condition.matches(query);
        }

        public int decrement() {
            return this.count.decrementAndGet();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conditional)) {
                return false;
            }
            Conditional other = (Conditional)o;
            MkAnswer this$answr = this.answr;
            MkAnswer other$answr = other.answr;
            if (this$answr == null ? other$answr != null : !this$answr.equals(other$answr)) {
                return false;
            }
            Matcher<MkQuery> this$condition = this.condition;
            Matcher<MkQuery> other$condition = other.condition;
            return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MkAnswer $answr = this.answr;
            result = result * 59 + ($answr == null ? 43 : $answr.hashCode());
            Matcher<MkQuery> $condition = this.condition;
            result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
            return result;
        }
    }
}

