/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.response;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.response.AbstractResponse;
import com.jcabi.http.response.RestResponse;
import com.jcabi.immutable.ArrayMap;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
public final class WebLinkingResponse
extends AbstractResponse {
    private static final String HEADER = "Link";
    private static final String REL = "rel";

    public WebLinkingResponse(Response resp) {
        super(resp);
    }

    public Request follow(String rel) throws IOException {
        Link link = this.links().get(rel);
        if (link == null) {
            throw new IOException(String.format("Link with rel=\"%s\" doesn't exist, use #hasLink()", rel));
        }
        return new RestResponse(this).jump(link.uri());
    }

    public Map<String, Link> links() throws IOException {
        ConcurrentHashMap<String, Link> links = new ConcurrentHashMap<String, Link>(0);
        Collection headers = this.headers().get(HEADER);
        if (headers != null) {
            for (String header : headers) {
                for (String part : header.split(",")) {
                    SimpleLink link = new SimpleLink(part.trim());
                    String rel = (String)link.get(REL);
                    if (rel == null) continue;
                    links.put(rel, link);
                }
            }
        }
        return links;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebLinkingResponse)) {
            return false;
        }
        WebLinkingResponse other = (WebLinkingResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WebLinkingResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Immutable
    private static final class SimpleLink
    implements Link {
        private static final Pattern PTN = Pattern.compile("<([^>]+)>\\s*;(.*)");
        private final transient String addr;
        private final transient ArrayMap<String, String> params;

        SimpleLink(String text) throws IOException {
            Matcher matcher = PTN.matcher(text);
            if (!matcher.matches()) {
                throw new IOException(String.format("Link header value doesn't comply to RFC-5988: \"%s\"", text));
            }
            this.addr = matcher.group(1);
            ConcurrentHashMap<String, String> args = new ConcurrentHashMap<String, String>(0);
            for (String pair : matcher.group(2).trim().split("\\s*;\\s*")) {
                String[] parts = pair.split("=");
                args.put(parts[0].trim().toLowerCase(Locale.ENGLISH), parts[1].trim().replaceAll("(^\"|\"$)", ""));
            }
            this.params = new ArrayMap(args);
        }

        @Override
        public URI uri() {
            return URI.create(this.addr);
        }

        @Override
        public int size() {
            return this.params.size();
        }

        @Override
        public boolean isEmpty() {
            return this.params.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.params.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.params.containsValue(value);
        }

        @Override
        public String get(Object key) {
            return this.params.get(key);
        }

        @Override
        public String put(String key, String value) {
            throw new UnsupportedOperationException("#put()");
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException("#remove()");
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map) {
            throw new UnsupportedOperationException("#putAll()");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("#clear()");
        }

        @Override
        public Set<String> keySet() {
            return this.params.keySet();
        }

        @Override
        public Collection<String> values() {
            return this.params.values();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.params.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof SimpleLink;
        }

        @Override
        public int hashCode() {
            int result = 1;
            return result;
        }
    }

    @Immutable
    public static interface Link
    extends Map<String, String> {
        public URI uri();
    }
}

