/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.RequestBody;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

@Immutable
public final class VerboseWire
implements Wire {
    private final transient Wire origin;

    public VerboseWire(Wire wire) {
        this.origin = wire;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1000];
        int bytes = content.read(buffer);
        while (bytes != -1) {
            output.write(buffer, 0, bytes);
            bytes = content.read(buffer);
        }
        output.flush();
        Response response = this.origin.send(req, home, method, headers, new ByteArrayInputStream(output.toByteArray()), connect, read);
        StringBuilder text = new StringBuilder(0);
        for (Map.Entry<String, String> header : headers) {
            text.append(header.getKey()).append(": ").append(header.getValue()).append('\n');
        }
        text.append('\n').append(new RequestBody.Printable(output.toByteArray()).toString());
        Logger.info(this, "#send(%s %s):\nHTTP Request (%s):\n%s\nHTTP Response (%s):\n%s", method, home, req.getClass().getName(), VerboseWire.indent(text.toString()), response.getClass().getName(), VerboseWire.indent(response.toString()));
        return response;
    }

    private static String indent(String text) {
        return "  " + text.replaceAll("(\n|\n\r)", "$1  ");
    }

    public String toString() {
        return "VerboseWire(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerboseWire)) {
            return false;
        }
        VerboseWire other = (VerboseWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

