/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.Colors;
import com.jcabi.log.ControlSequenceIndicatorFormatted;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ConversionPattern {
    private static final Pattern METAS = Pattern.compile("%color(?:-([a-z]+|[0-9]{1,3};[0-9]{1,3};[0-9]{1,3}))?\\{(.*?)\\}");
    private final transient String pattern;
    private final transient Colors colors;

    public ConversionPattern(String pat, Colors col) {
        this.pattern = pat;
        this.colors = col;
    }

    public String generate() {
        Matcher matcher = METAS.matcher(this.pattern);
        StringBuffer buf = new StringBuffer(0);
        while (matcher.find()) {
            matcher.appendReplacement(buf, "");
            buf.append(this.csi()).append(this.colors.ansi(matcher.group(1))).append('m').append(matcher.group(2)).append(this.csi()).append('m');
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    private String csi() {
        return new ControlSequenceIndicatorFormatted("%s").format();
    }
}

