/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.immutable.Array;
import com.jcabi.immutable.ArrayMap;
import com.jcabi.log.Logger;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.NamespaceContext;

public final class XPathContext
implements NamespaceContext {
    private final transient ArrayMap<String, String> map;
    private final transient Array<NamespaceContext> contexts;

    public XPathContext() {
        this(new ArrayMap<String, String>().with("xhtml", "http://www.w3.org/1999/xhtml").with("xs", "http://www.w3.org/2001/XMLSchema").with("xsi", "http://www.w3.org/2001/XMLSchema-instance").with("xsl", "http://www.w3.org/1999/XSL/Transform").with("svg", "http://www.w3.org/2000/svg"), new Array<NamespaceContext>());
    }

    public XPathContext(Object ... namespaces) {
        this(XPathContext.namespacesAsMap(namespaces), new Array<NamespaceContext>());
    }

    private XPathContext(ArrayMap<String, String> old, String prefix, Object namespace) {
        this(old.with(prefix, namespace.toString()), new Array<NamespaceContext>());
    }

    private XPathContext(ArrayMap<String, String> mapping, Array<NamespaceContext> ctxs) {
        this.map = mapping;
        this.contexts = ctxs;
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String namespace = this.map.get(prefix);
        if (namespace == null) {
            NamespaceContext ctx;
            Iterator<NamespaceContext> i$ = this.contexts.iterator();
            while (i$.hasNext() && (namespace = (ctx = i$.next()).getNamespaceURI(prefix)) == null) {
            }
        }
        if (namespace == null) {
            namespace = prefix.equals("xml") ? "http://www.w3.org/XML/1998/namespace" : (prefix.equals("xmlns") ? "http://www.w3.org/2000/xmlns/" : "");
        }
        return namespace;
    }

    @Override
    public String getPrefix(String namespace) {
        Iterator<String> prefixes = this.getPrefixes(namespace);
        String prefix = null;
        if (prefixes.hasNext()) {
            prefix = prefixes.next();
        }
        return prefix;
    }

    @Override
    public Iterator<String> getPrefixes(String namespace) {
        LinkedList<String> prefixes = new LinkedList<String>();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(namespace)) continue;
            prefixes.add(entry.getKey());
        }
        for (NamespaceContext ctx : this.contexts) {
            Iterator<String> iterator = ctx.getPrefixes(namespace);
            while (iterator.hasNext()) {
                prefixes.add(iterator.next().toString());
            }
        }
        if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            prefixes.add("xml");
        }
        if (namespace.equals("http://www.w3.org/2000/xmlns/")) {
            prefixes.add("xmlns");
        }
        return Collections.unmodifiableList(prefixes).iterator();
    }

    public XPathContext add(String prefix, Object namespace) {
        if (this.map.containsKey(prefix)) {
            throw new IllegalArgumentException(String.format("prefix '%s' already registered for namespace '%s'", prefix, this.map.get(prefix)));
        }
        return new XPathContext(this.map, prefix, namespace);
    }

    public XPathContext merge(NamespaceContext context) {
        XPathContext ctx = new XPathContext(this.map, this.contexts.with(context));
        return ctx;
    }

    private static ArrayMap<String, String> namespacesAsMap(Object ... namespaces) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>(namespaces.length);
        for (int pos = 0; pos < namespaces.length; ++pos) {
            map.put(Logger.format("ns%d", pos + 1), namespaces[pos].toString());
        }
        return new ArrayMap<String, String>(map);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XPathContext)) {
            return false;
        }
        XPathContext other = (XPathContext)o;
        ArrayMap<String, String> this$map = this.map;
        ArrayMap<String, String> other$map = other.map;
        if (this$map == null ? other$map != null : !((Object)this$map).equals(other$map)) {
            return false;
        }
        Array<NamespaceContext> this$contexts = this.contexts;
        Array<NamespaceContext> other$contexts = other.contexts;
        return !(this$contexts == null ? other$contexts != null : !((Object)this$contexts).equals(other$contexts));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ArrayMap<String, String> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        Array<NamespaceContext> $contexts = this.contexts;
        result = result * 59 + ($contexts == null ? 43 : ((Object)$contexts).hashCode());
        return result;
    }
}

