/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import jersey.repackaged.com.google.common.base.Preconditions;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.Closure;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import org.glassfish.jersey.message.internal.OutboundJaxrsResponse;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.process.internal.RequestExecutorFactory;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ChunkedOutput;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.TracingConfig;
import org.glassfish.jersey.server.TracingUtils;
import org.glassfish.jersey.server.internal.BackgroundScheduler;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.ProcessingProviders;
import org.glassfish.jersey.server.internal.ServerTraceEvent;
import org.glassfish.jersey.server.internal.monitoring.EmptyRequestEventBuilder;
import org.glassfish.jersey.server.internal.monitoring.RequestEventBuilder;
import org.glassfish.jersey.server.internal.monitoring.RequestEventImpl;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.UriRoutingContext;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.ExternalRequestContext;
import org.glassfish.jersey.server.spi.ExternalRequestScope;
import org.glassfish.jersey.server.spi.ResponseErrorMapper;
import org.glassfish.jersey.spi.ExceptionMappers;

public class ServerRuntime {
    private final Stage<RequestProcessingContext> requestProcessingRoot;
    private final ProcessingProviders processingProviders;
    private final ServiceLocator locator;
    private final ScheduledExecutorService backgroundScheduler;
    private final RequestScope requestScope;
    private final ExceptionMappers exceptionMappers;
    private final RequestExecutorFactory asyncExecutorFactory;
    private final ApplicationEventListener applicationEventListener;
    private final Configuration configuration;
    private final ExternalRequestScope externalRequestScope;
    private final TracingConfig tracingConfig;
    private final TracingLogger.Level tracingThreshold;
    private final boolean processResponseErrors;
    static final ExternalRequestScope<Object> NOOP_EXTERNAL_REQ_SCOPE = new ExternalRequestScope<Object>(){

        @Override
        public ExternalRequestContext<Object> open() {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public void suspend(ExternalRequestContext<Object> o) {
        }

        @Override
        public void resume(ExternalRequestContext<Object> o) {
        }
    };

    private ServerRuntime(Stage<RequestProcessingContext> requestProcessingRoot, ProcessingProviders processingProviders, ServiceLocator locator, ScheduledExecutorService backgroundScheduler, RequestScope requestScope, ExceptionMappers exceptionMappers, RequestExecutorFactory asyncExecutorFactory, ApplicationEventListener applicationEventListener, ExternalRequestScope externalScope, Configuration configuration) {
        this.requestProcessingRoot = requestProcessingRoot;
        this.processingProviders = processingProviders;
        this.locator = locator;
        this.backgroundScheduler = backgroundScheduler;
        this.requestScope = requestScope;
        this.exceptionMappers = exceptionMappers;
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.applicationEventListener = applicationEventListener;
        this.externalRequestScope = externalScope;
        this.configuration = configuration;
        this.tracingConfig = TracingUtils.getTracingConfig(configuration);
        this.tracingThreshold = TracingUtils.getTracingThreshold(configuration);
        this.processResponseErrors = PropertiesHelper.isProperty(configuration.getProperty("jersey.config.server.exception.processResponseErrors"));
    }

    public void process(final ContainerRequest request) {
        TracingUtils.initTracingSupport(this.tracingConfig, this.tracingThreshold, request);
        TracingUtils.logStart(request);
        UriRoutingContext routingContext = request.getUriRoutingContext();
        RequestEventBuilder monitoringEventBuilder = EmptyRequestEventBuilder.INSTANCE;
        RequestEventListener monitoringEventListener = null;
        if (this.applicationEventListener != null) {
            monitoringEventBuilder = new RequestEventImpl.Builder().setContainerRequest(request).setExtendedUriInfo(routingContext);
            monitoringEventListener = this.applicationEventListener.onRequest(monitoringEventBuilder.build(RequestEvent.Type.START));
        }
        request.setProcessingProviders(this.processingProviders);
        final RequestProcessingContext context = new RequestProcessingContext(this.locator, request, routingContext, monitoringEventBuilder, monitoringEventListener);
        request.checkState();
        final Responder responder = new Responder(context, this);
        RequestScope.Instance requestScopeInstance = this.requestScope.createInstance();
        final AsyncResponderHolder asyncResponderHolder = new AsyncResponderHolder(responder, this.externalRequestScope, requestScopeInstance, this.externalRequestScope.open());
        context.initAsyncContext(asyncResponderHolder);
        this.requestScope.runInScope(requestScopeInstance, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    OutboundJaxrsResponse.Builder.setBaseUri(request.getBaseUri());
                    Ref endpointRef = Refs.emptyRef();
                    RequestProcessingContext data = Stages.process(context, ServerRuntime.this.requestProcessingRoot, endpointRef);
                    Endpoint endpoint = (Endpoint)endpointRef.get();
                    if (endpoint == null) {
                        throw new NotFoundException();
                    }
                    ContainerResponse response = (ContainerResponse)endpoint.apply(data);
                    if (!asyncResponderHolder.isAsync()) {
                        responder.process(response);
                    } else {
                        ServerRuntime.this.externalRequestScope.suspend(asyncResponderHolder.externalContext);
                    }
                }
                catch (Throwable throwable) {
                    responder.process(throwable);
                }
                finally {
                    asyncResponderHolder.release();
                    OutboundJaxrsResponse.Builder.clearBaseUri();
                }
            }
        });
    }

    ScheduledExecutorService getBackgroundScheduler() {
        return this.backgroundScheduler;
    }

    private static void ensureAbsolute(URI location, MultivaluedMap<String, Object> headers, ContainerRequest request) {
        if (location == null || location.isAbsolute()) {
            return;
        }
        headers.putSingle("Location", request.getBaseUri().resolve(location));
    }

    private static class ConnectionCallbackRunner
    extends AbstractCallbackRunner<ConnectionCallback>
    implements ConnectionCallback {
        private static final Logger LOGGER = Logger.getLogger(ConnectionCallbackRunner.class.getName());

        private ConnectionCallbackRunner() {
            super(LOGGER);
        }

        @Override
        public Class<?> getCallbackContract() {
            return ConnectionCallback.class;
        }

        @Override
        public void onDisconnect(final AsyncResponse disconnected) {
            this.executeCallbacks(new Closure<ConnectionCallback>(){

                @Override
                public void invoke(ConnectionCallback callback) {
                    callback.onDisconnect(disconnected);
                }
            });
        }
    }

    private static class CompletionCallbackRunner
    extends AbstractCallbackRunner<CompletionCallback>
    implements CompletionCallback {
        private static final Logger LOGGER = Logger.getLogger(CompletionCallbackRunner.class.getName());

        private CompletionCallbackRunner() {
            super(LOGGER);
        }

        @Override
        public Class<?> getCallbackContract() {
            return CompletionCallback.class;
        }

        @Override
        public void onComplete(final Throwable throwable) {
            this.executeCallbacks(new Closure<CompletionCallback>(){

                @Override
                public void invoke(CompletionCallback callback) {
                    callback.onComplete(throwable);
                }
            });
        }
    }

    static abstract class AbstractCallbackRunner<T> {
        private final Queue<T> callbacks = new ConcurrentLinkedQueue<T>();
        private final Logger logger;

        protected AbstractCallbackRunner(Logger logger) {
            this.logger = logger;
        }

        public final boolean supports(Class<?> callbackClass) {
            return this.getCallbackContract().isAssignableFrom(callbackClass);
        }

        public abstract Class<?> getCallbackContract();

        public boolean register(Object callback) {
            return this.callbacks.offer(callback);
        }

        protected final void executeCallbacks(Closure<T> invoker) {
            for (Object callback : this.callbacks) {
                try {
                    invoker.invoke(callback);
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, LocalizationMessages.ERROR_ASYNC_CALLBACK_FAILED(callback.getClass().getName()), t);
                }
            }
        }
    }

    private static class AsyncResponder
    implements AsyncContext,
    ContainerResponseWriter.TimeoutHandler,
    CompletionCallback {
        private static final Logger LOGGER = Logger.getLogger(AsyncResponder.class.getName());
        private static final TimeoutHandler DEFAULT_TIMEOUT_HANDLER = new TimeoutHandler(){

            @Override
            public void handleTimeout(AsyncResponse asyncResponse) {
                throw new ServiceUnavailableException();
            }
        };
        private final Object stateLock = new Object();
        private AsyncContext.State state = AsyncContext.State.RUNNING;
        private boolean cancelled = false;
        private final Responder responder;
        private final RequestScope.Instance scopeInstance;
        private final ExternalRequestContext<?> foreignScopeInstance;
        private final ExternalRequestScope requestScopeListener;
        private volatile TimeoutHandler timeoutHandler = DEFAULT_TIMEOUT_HANDLER;
        private final List<AbstractCallbackRunner<?>> callbackRunners;

        public AsyncResponder(Responder responder, RequestScope.Instance scopeInstance, ExternalRequestScope requestScopeListener, ExternalRequestContext<?> foreignScopeInstance) {
            this.responder = responder;
            this.scopeInstance = scopeInstance;
            this.foreignScopeInstance = foreignScopeInstance;
            this.requestScopeListener = requestScopeListener;
            this.callbackRunners = Collections.unmodifiableList(Arrays.asList(responder.completionCallbackRunner, responder.connectionCallbackRunner));
            responder.completionCallbackRunner.register(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout(ContainerResponseWriter responseWriter) {
            TimeoutHandler handler = this.timeoutHandler;
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    if (this.state == AsyncContext.State.SUSPENDED) {
                        handler.handleTimeout(this);
                    }
                }
            }
            catch (Throwable throwable) {
                this.resume(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(Throwable throwable) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = AsyncContext.State.COMPLETED;
            }
        }

        @Override
        public void invokeManaged(final Producer<Response> producer) {
            this.responder.runtime.asyncExecutorFactory.getExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    AsyncResponder.this.responder.runtime.requestScope.runInScope(AsyncResponder.this.scopeInstance, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AsyncResponder.this.requestScopeListener.resume(AsyncResponder.this.foreignScopeInstance);
                                Response response = (Response)producer.call();
                                if (response != null) {
                                    AsyncResponder.this.resume(response);
                                }
                            }
                            catch (Throwable t) {
                                AsyncResponder.this.resume(t);
                            }
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean suspend() {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == AsyncContext.State.RUNNING && this.responder.processingContext.request().getResponseWriter().suspend(0L, TimeUnit.SECONDS, this)) {
                    this.state = AsyncContext.State.SUSPENDED;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean resume(final Object response) {
            return this.resume(new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncResponder.this.requestScopeListener.resume(AsyncResponder.this.foreignScopeInstance);
                        Response jaxrsResponse = response instanceof Response ? (Response)response : Response.ok(response).build();
                        ServerRuntime.ensureAbsolute(jaxrsResponse.getLocation(), jaxrsResponse.getHeaders(), AsyncResponder.this.responder.processingContext.request());
                        AsyncResponder.this.responder.process(new ContainerResponse(AsyncResponder.this.responder.processingContext.request(), jaxrsResponse));
                    }
                    catch (Throwable t) {
                        AsyncResponder.this.responder.process(t);
                    }
                }
            });
        }

        @Override
        public boolean resume(final Throwable error) {
            return this.resume(new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncResponder.this.requestScopeListener.resume(AsyncResponder.this.foreignScopeInstance);
                        AsyncResponder.this.responder.process(new MappableException(error));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean resume(Runnable handler) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state != AsyncContext.State.SUSPENDED) {
                    return false;
                }
                this.state = AsyncContext.State.RESUMED;
            }
            try {
                this.responder.runtime.requestScope.runInScope(this.scopeInstance, handler);
            }
            finally {
                this.scopeInstance.release();
            }
            return true;
        }

        @Override
        public boolean cancel() {
            return this.cancel(new Value<Response>(){

                @Override
                public Response get() {
                    return Response.status(Response.Status.SERVICE_UNAVAILABLE).build();
                }
            });
        }

        @Override
        public boolean cancel(final int retryAfter) {
            return this.cancel(new Value<Response>(){

                @Override
                public Response get() {
                    return Response.status(Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", retryAfter).build();
                }
            });
        }

        @Override
        public boolean cancel(final Date retryAfter) {
            return this.cancel(new Value<Response>(){

                @Override
                public Response get() {
                    return Response.status(Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", retryAfter).build();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cancel(final Value<Response> responseValue) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.cancelled) {
                    return true;
                }
                if (this.state != AsyncContext.State.SUSPENDED) {
                    return false;
                }
                this.state = AsyncContext.State.RESUMED;
                this.cancelled = true;
            }
            this.responder.runtime.requestScope.runInScope(this.scopeInstance, new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncResponder.this.requestScopeListener.resume(AsyncResponder.this.foreignScopeInstance);
                        Response response = (Response)responseValue.get();
                        AsyncResponder.this.responder.process(new ContainerResponse(AsyncResponder.this.responder.processingContext.request(), response));
                    }
                    catch (Throwable t) {
                        AsyncResponder.this.responder.process(t);
                    }
                }
            });
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.state == AsyncContext.State.RUNNING;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSuspended() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.state == AsyncContext.State.SUSPENDED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.cancelled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.state == AsyncContext.State.COMPLETED;
            }
        }

        @Override
        public boolean setTimeout(long time, TimeUnit unit) {
            try {
                this.responder.processingContext.request().getResponseWriter().setSuspendTimeout(time, unit);
                return true;
            }
            catch (IllegalStateException ex) {
                LOGGER.log(Level.FINER, "Unable to set timeout on the AsyncResponse.", ex);
                return false;
            }
        }

        @Override
        public void setTimeoutHandler(TimeoutHandler handler) {
            this.timeoutHandler = handler;
        }

        @Override
        public Collection<Class<?>> register(Class<?> callback) {
            Preconditions.checkNotNull(callback, LocalizationMessages.PARAM_NULL("callback"));
            return this.register(Injections.getOrCreate(this.responder.runtime.locator, callback));
        }

        @Override
        public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
            Preconditions.checkNotNull(callback, LocalizationMessages.PARAM_NULL("callback"));
            Preconditions.checkNotNull(callbacks, LocalizationMessages.CALLBACK_ARRAY_NULL());
            for (Class<?> additionalCallback : callbacks) {
                Preconditions.checkNotNull(additionalCallback, LocalizationMessages.CALLBACK_ARRAY_ELEMENT_NULL());
            }
            HashMap results = new HashMap();
            results.put(callback, this.register(callback));
            for (Class<?> c : callbacks) {
                results.put(c, this.register(c));
            }
            return results;
        }

        @Override
        public Collection<Class<?>> register(Object callback) {
            Preconditions.checkNotNull(callback, LocalizationMessages.PARAM_NULL("callback"));
            LinkedList result = new LinkedList();
            for (AbstractCallbackRunner<?> runner : this.callbackRunners) {
                if (!runner.supports(callback.getClass()) || !runner.register(callback)) continue;
                result.add(runner.getCallbackContract());
            }
            return result;
        }

        @Override
        public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
            Preconditions.checkNotNull(callback, LocalizationMessages.PARAM_NULL("callback"));
            Preconditions.checkNotNull(callbacks, LocalizationMessages.CALLBACK_ARRAY_NULL());
            for (Object additionalCallback : callbacks) {
                Preconditions.checkNotNull(additionalCallback, LocalizationMessages.CALLBACK_ARRAY_ELEMENT_NULL());
            }
            HashMap results = new HashMap();
            results.put(callback.getClass(), this.register(callback));
            for (Object c : callbacks) {
                results.put(c.getClass(), this.register(c));
            }
            return results;
        }
    }

    private static class Responder {
        private static final Logger LOGGER = Logger.getLogger(Responder.class.getName());
        private final RequestProcessingContext processingContext;
        private final ServerRuntime runtime;
        private final CompletionCallbackRunner completionCallbackRunner = new CompletionCallbackRunner();
        private final ConnectionCallbackRunner connectionCallbackRunner = new ConnectionCallbackRunner();
        private final TracingLogger tracingLogger;

        public Responder(RequestProcessingContext processingContext, ServerRuntime runtime) {
            this.processingContext = processingContext;
            this.runtime = runtime;
            this.tracingLogger = TracingLogger.getInstance(processingContext.request());
        }

        public void process(ContainerResponse response) {
            this.processingContext.monitoringEventBuilder().setContainerResponse(response);
            response = this.processResponse(response);
            this.release(response);
        }

        private ContainerResponse processResponse(ContainerResponse response) {
            Stage<ContainerResponse> respondingRoot = this.processingContext.createRespondingRoot();
            if (respondingRoot != null) {
                response = Stages.process(response, respondingRoot);
            }
            this.writeResponse(response);
            this.completionCallbackRunner.onComplete(null);
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Throwable throwable) {
            ContainerRequest request = this.processingContext.request();
            this.processingContext.monitoringEventBuilder().setException(throwable, RequestEvent.ExceptionCause.ORIGINAL);
            this.processingContext.triggerEvent(RequestEvent.Type.ON_EXCEPTION);
            ContainerResponse response = null;
            try {
                Response exceptionResponse = this.mapException(throwable);
                try {
                    try {
                        response = this.convertResponse(exceptionResponse);
                        ServerRuntime.ensureAbsolute(response.getLocation(), response.getHeaders(), request);
                        this.processingContext.monitoringEventBuilder().setContainerResponse(response).setResponseSuccessfullyMapped(true);
                    }
                    finally {
                        this.processingContext.triggerEvent(RequestEvent.Type.EXCEPTION_MAPPING_FINISHED);
                    }
                    this.processResponse(response);
                }
                catch (Throwable respError) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_PROCESSING_RESPONSE_FROM_ALREADY_MAPPED_EXCEPTION());
                    this.processingContext.monitoringEventBuilder().setException(respError, RequestEvent.ExceptionCause.MAPPED_RESPONSE);
                    this.processingContext.triggerEvent(RequestEvent.Type.ON_EXCEPTION);
                    throw respError;
                }
                this.release(response);
            }
            catch (Throwable responseError) {
                try {
                    if (!(throwable == responseError || throwable instanceof MappableException && throwable.getCause() == responseError)) {
                        LOGGER.log(Level.FINE, LocalizationMessages.ERROR_EXCEPTION_MAPPING_ORIGINAL_EXCEPTION(), throwable);
                    }
                    if (!this.processResponseError(responseError)) {
                        LOGGER.log(Level.FINE, LocalizationMessages.ERROR_EXCEPTION_MAPPING_THROWN_TO_CONTAINER(), responseError);
                        try {
                            request.getResponseWriter().failure(responseError);
                        }
                        finally {
                            this.completionCallbackRunner.onComplete(responseError);
                        }
                    }
                    this.release(response);
                }
                catch (Throwable throwable2) {
                    this.release(response);
                    throw throwable2;
                }
            }
        }

        private boolean processResponseError(Throwable responseError) {
            boolean processed = false;
            if (this.runtime.processResponseErrors) {
                Iterable<ResponseErrorMapper> mappers = Providers.getAllProviders(this.runtime.locator, ResponseErrorMapper.class);
                try {
                    ResponseErrorMapper mapper;
                    Response processedError = null;
                    Iterator<ResponseErrorMapper> iterator = mappers.iterator();
                    while (iterator.hasNext() && (processedError = (mapper = iterator.next()).toResponse(responseError)) == null) {
                    }
                    if (processedError != null) {
                        this.processResponse(new ContainerResponse(this.processingContext.request(), processedError));
                        processed = true;
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.FINE, LocalizationMessages.ERROR_EXCEPTION_MAPPING_PROCESSED_RESPONSE_ERROR(), throwable);
                }
            }
            return processed;
        }

        private ContainerResponse convertResponse(Response exceptionResponse) {
            ContainerResponse containerResponse = new ContainerResponse(this.processingContext.request(), exceptionResponse);
            containerResponse.setMappedFromException(true);
            return containerResponse;
        }

        private Response mapException(Throwable originalThrowable) throws Throwable {
            LOGGER.log(Level.FINER, LocalizationMessages.EXCEPTION_MAPPING_START(), originalThrowable);
            Throwable throwable = originalThrowable;
            boolean inMappable = false;
            boolean mappingNotFound = false;
            do {
                if (throwable instanceof MappableException) {
                    inMappable = true;
                } else if (inMappable || throwable instanceof WebApplicationException) {
                    WebApplicationException webApplicationException;
                    if (this.runtime.processResponseErrors && throwable instanceof InternalServerErrorException && throwable.getCause() instanceof MessageBodyProviderNotFoundException) {
                        throw throwable;
                    }
                    Response waeResponse = null;
                    if (throwable instanceof WebApplicationException && (waeResponse = (webApplicationException = (WebApplicationException)throwable).getResponse()).hasEntity()) {
                        LOGGER.log(Level.FINE, LocalizationMessages.EXCEPTION_MAPPING_WAE_ENTITY(waeResponse.getStatus()), throwable);
                        return waeResponse;
                    }
                    long timestamp = this.tracingLogger.timestamp(ServerTraceEvent.EXCEPTION_MAPPING);
                    ExceptionMapper<Throwable> mapper = this.runtime.exceptionMappers.findMapping(throwable);
                    if (mapper != null) {
                        this.processingContext.monitoringEventBuilder().setExceptionMapper(mapper);
                        this.processingContext.triggerEvent(RequestEvent.Type.EXCEPTION_MAPPER_FOUND);
                        try {
                            Response mappedResponse = mapper.toResponse(throwable);
                            if (this.tracingLogger.isLogEnabled(ServerTraceEvent.EXCEPTION_MAPPING)) {
                                this.tracingLogger.logDuration(ServerTraceEvent.EXCEPTION_MAPPING, timestamp, mapper, throwable, throwable.getLocalizedMessage(), mappedResponse != null ? mappedResponse.getStatusInfo() : "-no-response-");
                            }
                            if (mappedResponse != null) {
                                return mappedResponse;
                            }
                            return Response.noContent().build();
                        }
                        catch (Throwable mapperThrowable) {
                            LOGGER.log(Level.SEVERE, LocalizationMessages.EXCEPTION_MAPPER_THROWS_EXCEPTION(mapper.getClass()), mapperThrowable);
                            LOGGER.log(Level.SEVERE, LocalizationMessages.EXCEPTION_MAPPER_FAILED_FOR_EXCEPTION(), throwable);
                            return Response.serverError().build();
                        }
                    }
                    if (waeResponse != null) {
                        LOGGER.log(Level.FINE, LocalizationMessages.EXCEPTION_MAPPING_WAE_NO_ENTITY(waeResponse.getStatus()), throwable);
                        return waeResponse;
                    }
                    mappingNotFound = true;
                }
                if (throwable instanceof HeaderValueException && ((HeaderValueException)throwable).getContext() == HeaderValueException.Context.INBOUND) {
                    return Response.status(Response.Status.BAD_REQUEST).build();
                }
                if (inMappable && !mappingNotFound) continue;
                throw throwable;
            } while ((throwable = throwable.getCause()) != null);
            throw originalThrowable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ContainerResponse writeResponse(final ContainerResponse response) {
            boolean close;
            ContainerRequest request = this.processingContext.request();
            final ContainerResponseWriter writer = request.getResponseWriter();
            ServerRuntime.ensureAbsolute(response.getLocation(), response.getHeaders(), response.getRequestContext());
            if (!response.hasEntity()) {
                this.tracingLogger.log(ServerTraceEvent.FINISHED, response.getStatusInfo());
                this.tracingLogger.flush(response.getHeaders());
                writer.writeResponseStatusAndHeaders(0L, response);
                this.setWrittenResponse(response);
                return response;
            }
            Object entity = response.getEntity();
            boolean skipFinally = false;
            final boolean isHead = request.getMethod().equals("HEAD");
            response.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                @Override
                public OutputStream getOutputStream(int contentLength) throws IOException {
                    ServerRuntime.ensureAbsolute(response.getLocation(), response.getHeaders(), response.getRequestContext());
                    OutputStream outputStream = writer.writeResponseStatusAndHeaders(contentLength, response);
                    return isHead ? null : outputStream;
                }
            });
            if ((writer.enableResponseBuffering() || isHead) && !response.isChunked()) {
                response.enableBuffering(this.runtime.configuration);
            }
            try {
                response.setEntityStream(request.getWorkers().writeTo(entity, entity.getClass(), response.getEntityType(), response.getEntityAnnotations(), response.getMediaType(), response.getHeaders(), request.getPropertiesDelegate(), response.getEntityStream(), request.getWriterInterceptors()));
            }
            catch (MappableException mpe) {
                try {
                    if (!(mpe.getCause() instanceof IOException)) throw mpe;
                    this.connectionCallbackRunner.onDisconnect(this.processingContext.asyncContext());
                    throw mpe;
                }
                catch (Throwable throwable) {
                    this.tracingLogger.log(ServerTraceEvent.FINISHED, response.getStatusInfo());
                    this.tracingLogger.flush(response.getHeaders());
                    throw throwable;
                }
            }
            this.tracingLogger.log(ServerTraceEvent.FINISHED, response.getStatusInfo());
            this.tracingLogger.flush(response.getHeaders());
            this.setWrittenResponse(response);
            if (skipFinally) return response;
            boolean bl = close = !response.isChunked();
            if (response.isChunked()) {
                try {
                    response.commitStream();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_COMMITTING_OUTPUT_STREAM(), e);
                    close = true;
                }
                ChunkedOutput chunked = (ChunkedOutput)entity;
                try {
                    chunked.setContext(this.runtime.requestScope, this.runtime.requestScope.referenceCurrent(), request, response, this.connectionCallbackRunner, this.processingContext.asyncContextValue());
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY_CHUNK(), ex);
                    close = true;
                }
                if (!chunked.isClosed() && !writer.suspend(0L, TimeUnit.SECONDS, null)) {
                    LOGGER.fine(LocalizationMessages.ERROR_SUSPENDING_CHUNKED_OUTPUT_RESPONSE());
                }
            }
            if (!close) return response;
            try {
                response.close();
                return response;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_CLOSING_COMMIT_OUTPUT_STREAM(), e);
            }
            return response;
            catch (Throwable ex) {
                try {
                    if (!response.isCommitted()) {
                        skipFinally = true;
                        if (!(ex instanceof RuntimeException)) throw new MappableException(ex);
                        throw (RuntimeException)ex;
                    }
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY(), ex);
                    if (skipFinally) return response;
                    boolean bl2 = close = !response.isChunked();
                }
                catch (Throwable throwable) {
                    boolean close2;
                    if (skipFinally) throw throwable;
                    boolean bl3 = close2 = !response.isChunked();
                    if (response.isChunked()) {
                        try {
                            response.commitStream();
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_COMMITTING_OUTPUT_STREAM(), e);
                            close2 = true;
                        }
                        ChunkedOutput chunked = (ChunkedOutput)entity;
                        try {
                            chunked.setContext(this.runtime.requestScope, this.runtime.requestScope.referenceCurrent(), request, response, this.connectionCallbackRunner, this.processingContext.asyncContextValue());
                        }
                        catch (IOException ex2) {
                            LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY_CHUNK(), ex2);
                            close2 = true;
                        }
                        if (!chunked.isClosed() && !writer.suspend(0L, TimeUnit.SECONDS, null)) {
                            LOGGER.fine(LocalizationMessages.ERROR_SUSPENDING_CHUNKED_OUTPUT_RESPONSE());
                        }
                    }
                    if (!close2) throw throwable;
                    try {
                        response.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_CLOSING_COMMIT_OUTPUT_STREAM(), e);
                    }
                    throw throwable;
                }
                if (response.isChunked()) {
                    try {
                        response.commitStream();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_COMMITTING_OUTPUT_STREAM(), e);
                        close = true;
                    }
                    ChunkedOutput chunked = (ChunkedOutput)entity;
                    try {
                        chunked.setContext(this.runtime.requestScope, this.runtime.requestScope.referenceCurrent(), request, response, this.connectionCallbackRunner, this.processingContext.asyncContextValue());
                    }
                    catch (IOException ex3) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY_CHUNK(), ex3);
                        close = true;
                    }
                    if (!chunked.isClosed() && !writer.suspend(0L, TimeUnit.SECONDS, null)) {
                        LOGGER.fine(LocalizationMessages.ERROR_SUSPENDING_CHUNKED_OUTPUT_RESPONSE());
                    }
                }
                if (!close) return response;
                try {
                    response.close();
                    return response;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_CLOSING_COMMIT_OUTPUT_STREAM(), e);
                }
                return response;
            }
        }

        private void setWrittenResponse(ContainerResponse response) {
            this.processingContext.monitoringEventBuilder().setContainerResponse(response).setSuccess(response.getStatus() < Response.Status.BAD_REQUEST.getStatusCode()).setResponseWritten(true);
        }

        private void release(ContainerResponse responseContext) {
            try {
                this.processingContext.closeableService().close();
                if (responseContext != null && !responseContext.isChunked()) {
                    responseContext.close();
                }
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, LocalizationMessages.RELEASING_REQUEST_PROCESSING_RESOURCES_FAILED(), throwable);
            }
            finally {
                this.runtime.externalRequestScope.close();
                this.processingContext.triggerEvent(RequestEvent.Type.FINISHED);
            }
        }
    }

    private static class AsyncResponderHolder
    implements Value<AsyncContext> {
        private final Responder responder;
        private final ExternalRequestScope externalScope;
        private final RequestScope.Instance scopeInstance;
        private final ExternalRequestContext<?> externalContext;
        private volatile AsyncResponder asyncResponder;

        private AsyncResponderHolder(Responder responder, ExternalRequestScope externalRequestScope, RequestScope.Instance scopeInstance, ExternalRequestContext<?> externalContext) {
            this.responder = responder;
            this.externalScope = externalRequestScope;
            this.scopeInstance = scopeInstance;
            this.externalContext = externalContext;
        }

        @Override
        public AsyncContext get() {
            AsyncResponder ar;
            this.asyncResponder = ar = new AsyncResponder(this.responder, this.scopeInstance, this.externalScope, this.externalContext);
            return ar;
        }

        public boolean isAsync() {
            AsyncResponder ar = this.asyncResponder;
            return ar != null && !ar.isRunning();
        }

        public void release() {
            if (this.asyncResponder == null) {
                this.scopeInstance.release();
            }
        }
    }

    public static class Builder {
        @Inject
        private ServiceLocator locator;
        @Inject
        @BackgroundScheduler
        private ScheduledExecutorService backgroundScheduler;
        @Inject
        private RequestScope requestScope;
        @Inject
        private ExceptionMappers exceptionMappers;
        @Inject
        private RequestExecutorFactory asyncExecutorFactory;
        @Inject
        private Configuration configuration;
        @Inject
        private ExternalRequestScope externalRequestScope;

        public ServerRuntime build(Stage<RequestProcessingContext> processingRoot, ApplicationEventListener eventListener, ProcessingProviders processingProviders) {
            ExternalRequestScope externalScope = this.externalRequestScope != null ? this.externalRequestScope : NOOP_EXTERNAL_REQ_SCOPE;
            return new ServerRuntime(processingRoot, processingProviders, this.locator, this.backgroundScheduler, this.requestScope, this.exceptionMappers, this.asyncExecutorFactory, eventListener, externalScope, this.configuration);
        }
    }
}

