/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xembly.AddDirective;
import org.xembly.AddIfDirective;
import org.xembly.AttrDirective;
import org.xembly.CdataDirective;
import org.xembly.Directive;
import org.xembly.ParsingException;
import org.xembly.PiDirective;
import org.xembly.PopDirective;
import org.xembly.PushDirective;
import org.xembly.RemoveDirective;
import org.xembly.SetDirective;
import org.xembly.StrictDirective;
import org.xembly.SyntaxException;
import org.xembly.UpDirective;
import org.xembly.XemblyLexer;
import org.xembly.XemblyParser;
import org.xembly.XmlContentException;
import org.xembly.XpathDirective;
import org.xembly.XsetDirective;

public final class Directives
implements Iterable<Directive> {
    private static final int MARGIN = 80;
    private final transient Collection<Directive> all = new CopyOnWriteArrayList<Directive>();

    public Directives() {
        this(Collections.emptyList());
    }

    public Directives(String text) throws SyntaxException {
        this(Directives.parse(text));
    }

    public Directives(Iterable<Directive> dirs) {
        this.append(dirs);
    }

    public String toString() {
        StringBuilder text = new StringBuilder(0);
        int width = 0;
        int idx = 0;
        for (Directive dir : this.all) {
            if (idx > 0 && width == 0) {
                text.append('\n').append(idx).append(':');
            }
            String txt = dir.toString();
            text.append(txt).append(';');
            if ((width += txt.length()) > 80) {
                width = 0;
            }
            ++idx;
        }
        return text.toString().trim();
    }

    @Override
    public Iterator<Directive> iterator() {
        return this.all.iterator();
    }

    public static Iterable<Directive> copyOf(Node node) {
        int idx;
        int len;
        Directives dirs = new Directives();
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            len = attrs.getLength();
            for (idx = 0; idx < len; ++idx) {
                Attr attr = (Attr)Attr.class.cast(attrs.item(idx));
                dirs.attr(attr.getNodeName(), attr.getNodeValue());
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            len = children.getLength();
            block8: for (idx = 0; idx < len; ++idx) {
                Node child = children.item(idx);
                switch (child.getNodeType()) {
                    case 1: {
                        dirs.add(child.getNodeName()).append(Directives.copyOf(child)).up();
                        continue block8;
                    }
                    case 2: {
                        dirs.attr(child.getNodeName(), child.getNodeValue());
                        continue block8;
                    }
                    case 3: 
                    case 4: {
                        if (len == 1) {
                            dirs.set(child.getTextContent());
                            continue block8;
                        }
                        if (child.getTextContent().trim().isEmpty()) continue block8;
                        throw new IllegalArgumentException(String.format("TEXT node #%d is not allowed together with other %d nodes in %s", idx, len, child.getNodeName()));
                    }
                    case 7: {
                        dirs.pi(child.getNodeName(), child.getNodeValue());
                        continue block8;
                    }
                    case 6: 
                    case 8: {
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("unsupported type %d of node %s", child.getNodeType(), child.getNodeName()));
                    }
                }
            }
        }
        return dirs;
    }

    public Directives append(Iterable<Directive> dirs) {
        LinkedList<Directive> list = new LinkedList<Directive>();
        for (Directive dir : dirs) {
            list.add(dir);
        }
        this.all.addAll(list);
        return this;
    }

    public Directives add(Object name) {
        try {
            this.all.add(new AddDirective(name.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("failed to understand XML content, ADD(%s)", name), ex);
        }
        return this;
    }

    public <K, V> Directives add(Map<K, V> nodes) {
        for (Map.Entry<K, V> entry : nodes.entrySet()) {
            this.add(entry.getKey().toString()).set(entry.getValue().toString()).up();
        }
        return this;
    }

    public Directives addIf(Object name) {
        try {
            this.all.add(new AddIfDirective(name.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("failed to understand XML content, ADDIF(%s)", name), ex);
        }
        return this;
    }

    public Directives remove() {
        this.all.add(new RemoveDirective());
        return this;
    }

    public Directives attr(Object name, Object value) {
        try {
            this.all.add(new AttrDirective(name.toString(), value.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("failed to understand XML content, ATTR(%s, %s)", name, value), ex);
        }
        return this;
    }

    public Directives pi(Object target, Object data) {
        try {
            this.all.add(new PiDirective(target.toString(), data.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("failed to understand XML content, PI(%s, %s)", target, data), ex);
        }
        return this;
    }

    public Directives set(Object text) {
        try {
            this.all.add(new SetDirective(text.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("failed to understand XML content, SET(%s)", text), ex);
        }
        return this;
    }

    public Directives xset(Object text) {
        try {
            this.all.add(new XsetDirective(text.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("failed to understand XML content, XSET(%s)", text), ex);
        }
        return this;
    }

    public Directives up() {
        this.all.add(new UpDirective());
        return this;
    }

    public Directives xpath(Object path) {
        try {
            this.all.add(new XpathDirective(path.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("failed to understand XML content, XPATH(%s)", path), ex);
        }
        return this;
    }

    public Directives strict(int number) {
        this.all.add(new StrictDirective(number));
        return this;
    }

    public Directives push() {
        this.all.add(new PushDirective());
        return this;
    }

    public Directives pop() {
        this.all.add(new PopDirective());
        return this;
    }

    public Directives cdata(Object text) {
        try {
            this.all.add(new CdataDirective(text.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("failed to understand XML content, CDATA(%s)", text), ex);
        }
        return this;
    }

    private static Collection<Directive> parse(String script) throws SyntaxException {
        ANTLRStringStream input = new ANTLRStringStream(script);
        XemblyLexer lexer = new XemblyLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        XemblyParser parser = new XemblyParser(tokens);
        try {
            return parser.directives();
        }
        catch (RecognitionException ex) {
            throw new SyntaxException(script, ex);
        }
        catch (ParsingException ex) {
            throw new SyntaxException(script, ex);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Directives)) {
            return false;
        }
        Directives other = (Directives)o;
        Collection<Directive> this$all = this.all;
        Collection<Directive> other$all = other.all;
        return !(this$all == null ? other$all != null : !((Object)this$all).equals(other$all));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<Directive> $all = this.all;
        result = result * 59 + ($all == null ? 43 : ((Object)$all).hashCode());
        return result;
    }
}

