/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.CommunicationException;
import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.OperationCancelledException;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventhubs.TimeoutException;
import com.microsoft.azure.eventhubs.TransportType;
import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.BaseLinkHandler;
import com.microsoft.azure.eventhubs.impl.CBSChannel;
import com.microsoft.azure.eventhubs.impl.ClientEntity;
import com.microsoft.azure.eventhubs.impl.ConnectionHandler;
import com.microsoft.azure.eventhubs.impl.DispatchHandler;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.ManagementChannel;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.ProtonUtil;
import com.microsoft.azure.eventhubs.impl.ReactorDispatcher;
import com.microsoft.azure.eventhubs.impl.ReactorHandler;
import com.microsoft.azure.eventhubs.impl.SchedulerProvider;
import com.microsoft.azure.eventhubs.impl.SessionHandler;
import com.microsoft.azure.eventhubs.impl.SessionProvider;
import com.microsoft.azure.eventhubs.impl.SharedAccessSignatureTokenProvider;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import com.microsoft.azure.eventhubs.impl.Timer;
import com.microsoft.azure.eventhubs.impl.WebSocketConnectionHandler;
import java.io.IOException;
import java.nio.channels.UnresolvedAddressException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.reactor.Reactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagingFactory
extends ClientEntity
implements AmqpConnection,
SessionProvider,
SchedulerProvider {
    public static final Duration DefaultOperationTimeout = Duration.ofSeconds(60L);
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(MessagingFactory.class);
    private final String hostName;
    private final CompletableFuture<Void> closeTask;
    private final ConnectionHandler connectionHandler;
    private final LinkedList<Link> registeredLinks;
    private final Object reactorLock;
    private final Object cbsChannelCreateLock;
    private final Object mgmtChannelCreateLock;
    private final SharedAccessSignatureTokenProvider tokenProvider;
    private final ReactorFactory reactorFactory;
    private Reactor reactor;
    private ReactorDispatcher reactorScheduler;
    private Connection connection;
    private CBSChannel cbsChannel;
    private ManagementChannel mgmtChannel;
    private Duration operationTimeout;
    private RetryPolicy retryPolicy;
    private CompletableFuture<MessagingFactory> open;
    private CompletableFuture<?> openTimer;
    private CompletableFuture<?> closeTimer;

    MessagingFactory(ConnectionStringBuilder builder, RetryPolicy retryPolicy, Executor executor, ReactorFactory reactorFactory) {
        super("MessagingFactory".concat(StringUtil.getRandomString()), null, executor);
        this.hostName = builder.getEndpoint().getHost();
        this.reactorFactory = reactorFactory;
        this.operationTimeout = builder.getOperationTimeout();
        this.retryPolicy = retryPolicy;
        this.registeredLinks = new LinkedList();
        this.reactorLock = new Object();
        this.connectionHandler = builder.getTransportType() == TransportType.AMQP ? new ConnectionHandler(this) : new WebSocketConnectionHandler(this);
        this.cbsChannelCreateLock = new Object();
        this.mgmtChannelCreateLock = new Object();
        this.tokenProvider = builder.getSharedAccessSignature() == null ? new SharedAccessSignatureTokenProvider(builder.getSasKeyName(), builder.getSasKey()) : new SharedAccessSignatureTokenProvider(builder.getSharedAccessSignature());
        this.closeTask = new CompletableFuture();
    }

    public static CompletableFuture<MessagingFactory> createFromConnectionString(String connectionString, Executor executor) throws IOException {
        return MessagingFactory.createFromConnectionString(connectionString, RetryPolicy.getDefault(), executor);
    }

    public static CompletableFuture<MessagingFactory> createFromConnectionString(String connectionString, RetryPolicy retryPolicy, Executor executor) throws IOException {
        return MessagingFactory.createFromConnectionString(connectionString, retryPolicy, executor, new ReactorFactory());
    }

    public static CompletableFuture<MessagingFactory> createFromConnectionString(String connectionString, RetryPolicy retryPolicy, Executor executor, ReactorFactory reactorFactory) throws IOException {
        ConnectionStringBuilder builder = new ConnectionStringBuilder(connectionString);
        final MessagingFactory messagingFactory = new MessagingFactory(builder, retryPolicy != null ? retryPolicy : RetryPolicy.getDefault(), executor, reactorFactory);
        messagingFactory.createConnection();
        Timer timer = new Timer(messagingFactory);
        messagingFactory.openTimer = timer.schedule(new Runnable(){

            @Override
            public void run() {
                if (!messagingFactory.open.isDone()) {
                    messagingFactory.open.completeExceptionally(new TimeoutException("Opening MessagingFactory timed out."));
                    messagingFactory.getReactor().stop();
                }
            }
        }, messagingFactory.getOperationTimeout());
        messagingFactory.openTimer.handleAsync((unUsed, exception) -> {
            if (exception != null && !(exception instanceof CancellationException)) {
                messagingFactory.open.completeExceptionally((Throwable)exception);
                messagingFactory.getReactor().stop();
            }
            return null;
        }, messagingFactory.executor);
        return messagingFactory.open;
    }

    public String getHostName() {
        return this.hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reactor getReactor() {
        Object object = this.reactorLock;
        synchronized (object) {
            return this.reactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReactorDispatcher getReactorScheduler() {
        Object object = this.reactorLock;
        synchronized (object) {
            return this.reactorScheduler;
        }
    }

    public SharedAccessSignatureTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    private void createConnection() throws IOException {
        this.open = new CompletableFuture();
        this.startReactor(new ReactorHandler(){

            @Override
            public void onReactorInit(Event e) {
                super.onReactorInit(e);
                Reactor r = e.getReactor();
                MessagingFactory.this.connection = r.connectionToHost(MessagingFactory.this.hostName, MessagingFactory.this.connectionHandler.getPort(), (Handler)MessagingFactory.this.connectionHandler);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReactor(ReactorHandler reactorHandler) throws IOException {
        Reactor newReactor = this.reactorFactory.create(reactorHandler, this.connectionHandler.getMaxFrameSize());
        Object object = this.reactorLock;
        synchronized (object) {
            this.reactor = newReactor;
            this.reactorScheduler = new ReactorDispatcher(newReactor);
            reactorHandler.unsafeSetReactorDispatcher(this.reactorScheduler);
        }
        this.executor.execute(new RunReactor(newReactor, this.executor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CBSChannel getCBSChannel() {
        Object object = this.cbsChannelCreateLock;
        synchronized (object) {
            if (this.cbsChannel == null) {
                this.cbsChannel = new CBSChannel(this, this);
            }
        }
        return this.cbsChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagementChannel getManagementChannel() {
        Object object = this.mgmtChannelCreateLock;
        synchronized (object) {
            if (this.mgmtChannel == null) {
                this.mgmtChannel = new ManagementChannel(this, this);
            }
        }
        return this.mgmtChannel;
    }

    @Override
    public Session getSession(String path, Consumer<Session> onRemoteSessionOpen, BiConsumer<ErrorCondition, Exception> onRemoteSessionOpenError) {
        if (this.getIsClosingOrClosed()) {
            onRemoteSessionOpenError.accept(null, new OperationCancelledException("underlying messagingFactory instance is closed"));
            return null;
        }
        if (this.connection == null || this.connection.getLocalState() == EndpointState.CLOSED || this.connection.getRemoteState() == EndpointState.CLOSED) {
            this.connection = this.getReactor().connectionToHost(this.hostName, this.connectionHandler.getPort(), (Handler)this.connectionHandler);
        }
        Session session = this.connection.session();
        BaseHandler.setHandler((Extendable)session, (Handler)new SessionHandler(path, onRemoteSessionOpen, onRemoteSessionOpenError));
        session.open();
        return session;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public void onOpenComplete(Exception exception) {
        if (exception == null) {
            this.open.complete(this);
            if (this.getIsClosingOrClosed()) {
                this.connection.close();
            }
        } else {
            this.open.completeExceptionally(exception);
        }
        if (this.openTimer != null) {
            this.openTimer.cancel(false);
        }
    }

    @Override
    public void onConnectionError(ErrorCondition error) {
        if (!this.open.isDone()) {
            this.getReactor().stop();
            this.onOpenComplete(ExceptionUtil.toException(error));
        } else {
            Connection currentConnection = this.connection;
            LinkedList<Link> registeredLinksCopy = new LinkedList<Link>(this.registeredLinks);
            LinkedList<Link> closedLinks = new LinkedList<Link>();
            for (Link link : registeredLinksCopy) {
                if (link.getLocalState() == EndpointState.CLOSED || link.getRemoteState() == EndpointState.CLOSED) continue;
                link.close();
                closedLinks.add(link);
            }
            if (currentConnection.getLocalState() != EndpointState.CLOSED) {
                currentConnection.close();
            }
            for (Link link : closedLinks) {
                Handler handler = BaseHandler.getHandler((Extendable)link);
                if (handler == null || !(handler instanceof BaseLinkHandler)) continue;
                BaseLinkHandler linkHandler = (BaseLinkHandler)handler;
                linkHandler.processOnClose(link, error);
            }
        }
        if (this.getIsClosingOrClosed() && !this.closeTask.isDone()) {
            this.getReactor().stop();
        }
    }

    private void onReactorError(Exception cause) {
        if (!this.open.isDone()) {
            this.onOpenComplete(cause);
        } else {
            Connection currentConnection = this.connection;
            try {
                if (this.getIsClosingOrClosed()) {
                    return;
                }
                this.startReactor(new ReactorHandler());
            }
            catch (IOException e) {
                TRACE_LOGGER.error(String.format(Locale.US, "messagingFactory[%s], hostName[%s], error[%s]", this.getClientId(), this.getHostName(), ExceptionUtil.toStackTraceString(e, "Re-starting reactor failed with error")));
                this.onReactorError(cause);
            }
            if (currentConnection.getLocalState() != EndpointState.CLOSED && currentConnection.getRemoteState() != EndpointState.CLOSED) {
                currentConnection.close();
            }
            LinkedList<Link> registeredLinksCopy = new LinkedList<Link>(this.registeredLinks);
            for (Link link : registeredLinksCopy) {
                Handler handler;
                if (link.getLocalState() != EndpointState.CLOSED && link.getRemoteState() != EndpointState.CLOSED) {
                    link.close();
                }
                if ((handler = BaseHandler.getHandler((Extendable)link)) == null || !(handler instanceof BaseLinkHandler)) continue;
                BaseLinkHandler linkHandler = (BaseLinkHandler)handler;
                linkHandler.processOnClose(link, cause);
            }
        }
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        if (!this.getIsClosed()) {
            Timer timer = new Timer(this);
            this.closeTimer = timer.schedule(new Runnable(){

                @Override
                public void run() {
                    if (!MessagingFactory.this.closeTask.isDone()) {
                        MessagingFactory.this.closeTask.completeExceptionally(new TimeoutException("Closing MessagingFactory timed out."));
                        MessagingFactory.this.getReactor().stop();
                    }
                }
            }, this.operationTimeout);
            if (this.closeTimer.isCompletedExceptionally()) {
                this.closeTask.completeExceptionally(ExceptionUtil.getExceptionFromCompletedFuture(this.closeTimer));
            } else {
                try {
                    this.scheduleOnReactorThread(new CloseWork());
                }
                catch (IOException | RejectedExecutionException schedulerException) {
                    this.closeTask.completeExceptionally(schedulerException);
                }
            }
        }
        return this.closeTask;
    }

    @Override
    public void registerForConnectionError(Link link) {
        this.registeredLinks.add(link);
    }

    @Override
    public void deregisterForConnectionError(Link link) {
        this.registeredLinks.remove(link);
    }

    public void scheduleOnReactorThread(DispatchHandler handler) throws IOException, RejectedExecutionException {
        this.getReactorScheduler().invoke(handler);
    }

    public void scheduleOnReactorThread(int delay, DispatchHandler handler) throws IOException, RejectedExecutionException {
        this.getReactorScheduler().invoke(delay, handler);
    }

    private class RunReactor
    implements Runnable {
        private final Reactor rctr;
        private final Executor executor;
        volatile boolean hasStarted;

        public RunReactor(Reactor reactor, Executor executor) {
            this.rctr = reactor;
            this.executor = executor;
            this.hasStarted = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TRACE_LOGGER.isInfoEnabled() && !this.hasStarted) {
                TRACE_LOGGER.info(String.format(Locale.US, "messagingFactory[%s], hostName[%s], info[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), "starting reactor instance."));
            }
            boolean reScheduledReactor = false;
            try {
                if (!this.hasStarted) {
                    this.rctr.start();
                    this.hasStarted = true;
                }
                if (!Thread.interrupted() && this.rctr.process()) {
                    try {
                        this.executor.execute(this);
                        reScheduledReactor = true;
                    }
                    catch (RejectedExecutionException exception) {
                        if (TRACE_LOGGER.isWarnEnabled()) {
                            TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], error[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), ExceptionUtil.toStackTraceString(exception, "scheduling reactor failed")));
                        }
                        this.rctr.attachments().set(RejectedExecutionException.class, RejectedExecutionException.class, (Object)exception);
                    }
                    return;
                }
                this.rctr.stop();
            }
            catch (HandlerException handlerException) {
                Throwable cause = handlerException.getCause();
                if (cause == null) {
                    cause = handlerException;
                }
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], error[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), ExceptionUtil.toStackTraceString(handlerException, "Unhandled exception while processing events in reactor, report this error.")));
                }
                String message = !StringUtil.isNullOrEmpty(cause.getMessage()) ? cause.getMessage() : (!StringUtil.isNullOrEmpty(handlerException.getMessage()) ? handlerException.getMessage() : "Reactor encountered unrecoverable error");
                EventHubException sbException = cause instanceof UnresolvedAddressException ? new CommunicationException(String.format(Locale.US, "%s. This is usually caused by incorrect hostname or network configuration. Check correctness of namespace information. %s", message, ExceptionUtil.getTrackingIDAndTimeToLog()), cause) : new EventHubException(true, String.format(Locale.US, "%s, %s", message, ExceptionUtil.getTrackingIDAndTimeToLog()), cause);
                MessagingFactory.this.onReactorError(sbException);
            }
            finally {
                if (reScheduledReactor) {
                    return;
                }
                this.rctr.free();
                if (MessagingFactory.this.getIsClosingOrClosed() && !MessagingFactory.this.closeTask.isDone()) {
                    MessagingFactory.this.closeTask.complete(null);
                    if (MessagingFactory.this.closeTimer != null) {
                        MessagingFactory.this.closeTimer.cancel(false);
                    }
                }
            }
        }
    }

    private class CloseWork
    extends DispatchHandler {
        private CloseWork() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent() {
            ReactorDispatcher dispatcher = MessagingFactory.this.getReactorScheduler();
            Object object = MessagingFactory.this.cbsChannelCreateLock;
            synchronized (object) {
                if (MessagingFactory.this.cbsChannel != null) {
                    MessagingFactory.this.cbsChannel.close(dispatcher, new OperationResult<Void, Exception>(){

                        @Override
                        public void onComplete(Void result) {
                            if (TRACE_LOGGER.isInfoEnabled()) {
                                TRACE_LOGGER.info(String.format(Locale.US, "messagingFactory[%s], hostName[%s], info[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), "cbsChannel closed"));
                            }
                        }

                        @Override
                        public void onError(Exception error) {
                            if (TRACE_LOGGER.isWarnEnabled()) {
                                TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], cbsChannelCloseError[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), error.getMessage()));
                            }
                        }
                    });
                }
            }
            object = MessagingFactory.this.mgmtChannelCreateLock;
            synchronized (object) {
                if (MessagingFactory.this.mgmtChannel != null) {
                    MessagingFactory.this.mgmtChannel.close(dispatcher, new OperationResult<Void, Exception>(){

                        @Override
                        public void onComplete(Void result) {
                            if (TRACE_LOGGER.isInfoEnabled()) {
                                TRACE_LOGGER.info(String.format(Locale.US, "messagingFactory[%s], hostName[%s], info[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), "mgmtChannel closed"));
                            }
                        }

                        @Override
                        public void onError(Exception error) {
                            if (TRACE_LOGGER.isWarnEnabled()) {
                                TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], mgmtChannelCloseError[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), error.getMessage()));
                            }
                        }
                    });
                }
            }
            if (MessagingFactory.this.connection != null && MessagingFactory.this.connection.getRemoteState() != EndpointState.CLOSED && MessagingFactory.this.connection.getLocalState() != EndpointState.CLOSED) {
                MessagingFactory.this.connection.close();
            }
        }
    }

    public static class ReactorFactory {
        public Reactor create(ReactorHandler reactorHandler, int maxFrameSize) throws IOException {
            return ProtonUtil.reactor(reactorHandler, maxFrameSize);
        }
    }
}

