/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl;

import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.impl.AbstractRepositoryMetadataResolver;
import com.mmnaseri.utils.spring.data.domain.impl.AnnotationRepositoryMetadataResolver;
import com.mmnaseri.utils.spring.data.domain.impl.AssignableRepositoryMetadataResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.repository.RepositoryDefinition;

public class DefaultRepositoryMetadataResolver
extends AbstractRepositoryMetadataResolver {
    private static final Log log = LogFactory.getLog(DefaultRepositoryMetadataResolver.class);
    private final AssignableRepositoryMetadataResolver assignableRepositoryMetadataResolver = new AssignableRepositoryMetadataResolver();
    private final AnnotationRepositoryMetadataResolver annotationRepositoryMetadataResolver = new AnnotationRepositoryMetadataResolver();

    @Override
    protected RepositoryMetadata resolveFromInterface(Class<?> repositoryInterface) {
        if (repositoryInterface.isAnnotationPresent(RepositoryDefinition.class)) {
            log.info((Object)"Since the repository interface was annotated with @RepositoryDefinition we will try to resolve the metadata using the provided annotation");
            return this.annotationRepositoryMetadataResolver.resolve(repositoryInterface);
        }
        log.info((Object)"Since no annotation was found on the repository, we will try to read the metadata from the generic type parameters derived from the Repository interface");
        return this.assignableRepositoryMetadataResolver.resolve(repositoryInterface);
    }
}

