/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.error.DataOperationExecutionException;
import com.mmnaseri.utils.spring.data.proxy.RepositoryConfiguration;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.store.DataStoreOperation;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodInvocationDataStoreOperation<K extends Serializable, E>
implements DataStoreOperation<Object, K, E> {
    private static final Log log = LogFactory.getLog(MethodInvocationDataStoreOperation.class);
    private final Object instance;
    private final Method method;

    public MethodInvocationDataStoreOperation(Object instance, Method method) {
        this.instance = instance;
        this.method = method;
    }

    @Override
    public Object execute(DataStore<K, E> store, RepositoryConfiguration configuration, Invocation invocation) {
        Object result;
        try {
            log.info((Object)("Invoking method " + this.method + " to handle invocation " + invocation));
            result = this.method.invoke(this.instance, invocation.getArguments());
        }
        catch (IllegalAccessException e) {
            throw new DataOperationExecutionException("Failed to access target method: " + this.method, e);
        }
        catch (InvocationTargetException e) {
            throw new DataOperationExecutionException("Method call resulted in internal error: " + this.method, e.getTargetException());
        }
        return result;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return this.method + " on " + this.instance;
    }
}

