/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.dsl.mock;

import com.mmnaseri.utils.spring.data.domain.KeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.ConfigurableSequentialIntegerKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.ConfigurableSequentialLongKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.RandomIntegerKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.RandomLongKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.SequentialIntegerKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.SequentialLongKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.UUIDKeyGenerator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.core.GenericTypeResolver;

class KeyGeneratorProvider {
    private final Map<Class<? extends Serializable>, List<Class<? extends KeyGenerator>>> generators;

    KeyGeneratorProvider() {
        List<Class<? extends KeyGenerator>> discoveredKeyGenerators = this.getKeyGeneratorTypes();
        this.generators = new ConcurrentHashMap<Class<? extends Serializable>, List<Class<? extends KeyGenerator>>>();
        for (Class<? extends KeyGenerator> generatorType : discoveredKeyGenerators) {
            Class keyType = GenericTypeResolver.resolveTypeArgument(generatorType, KeyGenerator.class);
            assert (keyType != null);
            Class<Serializable> actualKeyType = keyType.asSubclass(Serializable.class);
            if (!this.generators.containsKey(actualKeyType)) {
                this.generators.put(actualKeyType, new CopyOnWriteArrayList());
            }
            this.generators.get(actualKeyType).add(generatorType);
        }
    }

    private List<Class<? extends KeyGenerator>> getKeyGeneratorTypes() {
        return Arrays.asList(RandomIntegerKeyGenerator.class, RandomLongKeyGenerator.class, SequentialIntegerKeyGenerator.class, SequentialLongKeyGenerator.class, ConfigurableSequentialIntegerKeyGenerator.class, ConfigurableSequentialLongKeyGenerator.class, UUIDKeyGenerator.class);
    }

    private <S extends Serializable> List<Class<? extends KeyGenerator<S>>> getKeyGenerators(Class<S> keyType) {
        LinkedList<Class<KeyGenerator<S>>> keyGenerators = new LinkedList<Class<KeyGenerator<S>>>();
        if (this.generators.containsKey(keyType)) {
            List<Class<? extends KeyGenerator>> classes = this.generators.get(keyType);
            for (Class<? extends KeyGenerator> type : classes) {
                keyGenerators.add(type);
            }
        }
        for (Class<? extends Serializable> generatorKeyType : this.generators.keySet()) {
            if (!keyType.isAssignableFrom(generatorKeyType)) continue;
            List<Class<? extends KeyGenerator>> classes = this.generators.get(generatorKeyType);
            for (Class<? extends KeyGenerator> type : classes) {
                keyGenerators.add(type);
            }
        }
        return keyGenerators;
    }

    public <S extends Serializable> Class<? extends KeyGenerator<S>> getKeyGenerator(Class<S> keyType) {
        List<Class<KeyGenerator<S>>> generators = this.getKeyGenerators(keyType);
        return generators.isEmpty() ? null : generators.get(0);
    }
}

