/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.store.impl;

import com.mmnaseri.utils.spring.data.error.InvalidArgumentException;
import com.mmnaseri.utils.spring.data.store.DataStoreEvent;
import com.mmnaseri.utils.spring.data.store.DataStoreEventListener;
import com.mmnaseri.utils.spring.data.store.DataStoreEventListenerContext;
import com.mmnaseri.utils.spring.data.store.impl.SmartDataStoreEventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDataStoreEventListenerContext
implements DataStoreEventListenerContext {
    private static final Log log = LogFactory.getLog(DefaultDataStoreEventListenerContext.class);
    private final ConcurrentMap<Class<? extends DataStoreEvent>, List<DataStoreEventListener<?>>> listeners;
    private final DataStoreEventListenerContext parent;

    public DefaultDataStoreEventListenerContext() {
        this(null);
    }

    public DefaultDataStoreEventListenerContext(DataStoreEventListenerContext parent) {
        this.parent = parent;
        this.listeners = new ConcurrentHashMap();
    }

    @Override
    public <E extends DataStoreEvent> void register(DataStoreEventListener<E> listener) {
        SmartDataStoreEventListener<E> eventListener = new SmartDataStoreEventListener<E>(listener);
        this.listeners.putIfAbsent(eventListener.getEventType(), new CopyOnWriteArrayList());
        log.info((Object)("Registering an event listener for type " + eventListener.getEventType()));
        ((List)this.listeners.get(eventListener.getEventType())).add(eventListener);
    }

    @Override
    public void trigger(DataStoreEvent event) {
        if (event == null) {
            log.error((Object)"The data store event that was triggered was a null value");
            throw new InvalidArgumentException("Cannot raise a null event");
        }
        log.info((Object)("Triggering data store event of type " + event.getClass()));
        for (Class eventType : this.listeners.keySet()) {
            if (!eventType.isInstance(event)) continue;
            for (DataStoreEventListener listener : (List)this.listeners.get(eventType)) {
                log.debug((Object)("Triggering event on listener " + ((SmartDataStoreEventListener)listener).getDelegate()));
                listener.onEvent(event);
            }
        }
        if (this.parent != null) {
            log.info((Object)"Going to trigger the same event on the parent context");
            this.parent.trigger(event);
        }
    }

    @Override
    public <E extends DataStoreEvent> List<DataStoreEventListener<? extends E>> getListeners(Class<E> eventType) {
        LinkedList<DataStoreEventListener<DataStoreEventListener<E>>> found = new LinkedList<DataStoreEventListener<DataStoreEventListener<E>>>();
        for (Class supportedType : this.listeners.keySet()) {
            if (!supportedType.isAssignableFrom(eventType)) continue;
            for (DataStoreEventListener listener : (List)this.listeners.get(supportedType)) {
                found.add(((SmartDataStoreEventListener)listener).getDelegate());
            }
        }
        if (this.parent != null) {
            found.addAll(this.parent.getListeners(eventType));
        }
        return found;
    }
}

