/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.store.impl;

import com.mmnaseri.utils.spring.data.error.DataStoreException;
import com.mmnaseri.utils.spring.data.store.DataStore;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryDataStore<K extends Serializable, E>
implements DataStore<K, E> {
    private static final Log log = LogFactory.getLog(MemoryDataStore.class);
    private final ConcurrentMap<K, E> store = new ConcurrentHashMap<K, E>();
    private final Class<E> entityType;

    public MemoryDataStore(Class<E> entityType) {
        this.entityType = entityType;
    }

    @Override
    public boolean hasKey(K key) {
        log.info((Object)("Looking for an object with key " + key));
        return this.store.containsKey(key);
    }

    @Override
    public boolean save(K key, E entity) {
        if (key == null) {
            log.error((Object)"Asked to save an entity with a null key");
            throw new DataStoreException(this.entityType, "Cannot save an entity with a null key");
        }
        if (entity == null) {
            log.error((Object)"Asked to save a null value into the data store");
            throw new DataStoreException(this.entityType, "Cannot save a null entity");
        }
        log.info((Object)("Attempting to save entity with key " + key));
        boolean saved = this.store.put(key, entity) == null;
        log.debug((Object)("Entity was " + (!saved ? "not " : "") + "saved under key " + key));
        return saved;
    }

    @Override
    public boolean delete(K key) {
        if (key == null) {
            log.error((Object)"Asked to delete an entity with a null key for reference");
            throw new DataStoreException(this.entityType, "Cannot delete an entity with a null key");
        }
        if (this.store.containsKey(key)) {
            log.info((Object)("Deleting entity under key " + key));
            this.store.remove(key);
            return true;
        }
        log.info((Object)("No entity was found to delete under key " + key));
        return false;
    }

    @Override
    public E retrieve(K key) {
        if (key == null) {
            log.error((Object)"Asked to retrieve an entity from a null key");
            throw new DataStoreException(this.entityType, "Cannot retrieve an entity with a null key");
        }
        if (this.store.containsKey(key)) {
            log.info((Object)("Retrieving entity from key " + key));
            return (E)this.store.get(key);
        }
        log.info((Object)("No entity was found to return under key " + key));
        return null;
    }

    @Override
    public Collection<K> keys() {
        return new LinkedList(this.store.keySet());
    }

    @Override
    public synchronized Collection<E> retrieveAll() {
        log.info((Object)"Retrieving all entities from the data store");
        return new LinkedList(this.store.values());
    }

    @Override
    public Class<E> getEntityType() {
        return this.entityType;
    }

    @Override
    public void truncate() {
        this.store.clear();
    }
}

