/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl;

import com.mmnaseri.utils.spring.data.domain.IdPropertyResolver;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadataResolver;
import com.mmnaseri.utils.spring.data.domain.impl.id.EntityIdPropertyResolver;
import com.mmnaseri.utils.spring.data.error.RepositoryDefinitionException;
import java.lang.reflect.Modifier;

public abstract class AbstractRepositoryMetadataResolver
implements RepositoryMetadataResolver {
    private final IdPropertyResolver idPropertyResolver = new EntityIdPropertyResolver();

    protected AbstractRepositoryMetadataResolver() {
    }

    @Override
    public final RepositoryMetadata resolve(Class<?> repositoryInterface) {
        if (repositoryInterface == null) {
            throw new RepositoryDefinitionException(null, "Repository interface must not be null");
        }
        if (!Modifier.isInterface(repositoryInterface.getModifiers())) {
            throw new RepositoryDefinitionException(repositoryInterface, "Cannot resolve repository metadata for a class object that isn't an interface");
        }
        if (!Modifier.isPublic(repositoryInterface.getModifiers())) {
            throw new RepositoryDefinitionException(repositoryInterface, "Repository interface needs to be declared as public");
        }
        return this.resolveFromInterface(repositoryInterface);
    }

    protected abstract RepositoryMetadata resolveFromInterface(Class<?> var1);

    protected String resolveIdProperty(Class<?> entityType, Class<?> idType) {
        return this.idPropertyResolver.resolve(entityType, idType);
    }
}

