/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl.adapters;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.error.ResultAdapterFailureException;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.AbstractIterableResultAdapter;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.Future;

public class SimpleIterableResultAdapter
extends AbstractIterableResultAdapter<Object> {
    public SimpleIterableResultAdapter() {
        super(-400);
    }

    @Override
    public boolean accepts(Invocation invocation, Object originalValue) {
        if (!(originalValue instanceof Iterable)) {
            return false;
        }
        Class<?> returnType = invocation.getMethod().getReturnType();
        return !Iterable.class.isAssignableFrom(returnType) && !Iterator.class.isAssignableFrom(returnType) && !Future.class.isAssignableFrom(returnType) && !Optional.class.isAssignableFrom(returnType);
    }

    @Override
    protected Object doAdapt(Invocation invocation, Iterable iterable) {
        Iterator iterator = iterable.iterator();
        if (iterator.hasNext()) {
            Object value = iterator.next();
            if (iterator.hasNext()) {
                throw new ResultAdapterFailureException((Object)iterable, invocation.getMethod().getReturnType(), "Expected only one item but found many");
            }
            if (!PropertyUtils.getTypeOf(invocation.getMethod().getReturnType()).isInstance(value)) {
                throw new ResultAdapterFailureException(value, invocation.getMethod().getReturnType(), "Expected value to be of the indicated type");
            }
            return value;
        }
        return null;
    }
}

