/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.repository;

import com.mmnaseri.utils.spring.data.domain.DataStoreAware;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadataAware;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.gemfire.repository.Wrapper;

public class DefaultGemfireRepository
implements DataStoreAware,
RepositoryMetadataAware {
    private static final Log log = LogFactory.getLog(DefaultGemfireRepository.class);
    private DataStore dataStore;
    private RepositoryMetadata repositoryMetadata;

    public Object save(Wrapper<Object, Object> wrapper) {
        log.info((Object)"Going to save a wrapped data store object");
        Object entity = wrapper.getEntity();
        Object key = wrapper.getKey();
        if (this.repositoryMetadata.getEntityType().isInstance(entity)) {
            log.debug((Object)"Since the entity is of the same type as the actual entity type supported by the data store, we know how to set the key on the wrapped entity.");
            PropertyUtils.setPropertyValue(entity, this.repositoryMetadata.getIdentifierProperty(), key);
        }
        this.dataStore.save(key, entity);
        return entity;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public void setRepositoryMetadata(RepositoryMetadata repositoryMetadata) {
        this.repositoryMetadata = repositoryMetadata;
    }
}

