/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.store.impl;

import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.store.DataStoreEvent;
import com.mmnaseri.utils.spring.data.store.DataStoreEventListener;
import com.mmnaseri.utils.spring.data.store.impl.AuditableWrapper;
import com.mmnaseri.utils.spring.data.store.impl.BeforeInsertDataStoreEvent;
import com.mmnaseri.utils.spring.data.store.impl.BeforeUpdateDataStoreEvent;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import org.springframework.data.domain.Auditable;
import org.springframework.data.domain.AuditorAware;

public class AuditDataEventListener
implements DataStoreEventListener<DataStoreEvent> {
    private final AuditorAware auditorAware;

    public AuditDataEventListener(AuditorAware auditorAware) {
        this.auditorAware = auditorAware;
    }

    @Override
    public void onEvent(DataStoreEvent event) {
        if (event instanceof BeforeInsertDataStoreEvent) {
            Object entity = ((BeforeInsertDataStoreEvent)event).getEntity();
            Auditable wrapper = AuditDataEventListener.getAuditable(entity, event.getRepositoryMetadata());
            wrapper.setCreatedBy(this.auditorAware == null ? null : this.auditorAware.getCurrentAuditor().orElse(null));
            wrapper.setCreatedDate((TemporalAccessor)Instant.now());
        } else if (event instanceof BeforeUpdateDataStoreEvent) {
            Object entity = ((BeforeUpdateDataStoreEvent)event).getEntity();
            Auditable wrapper = AuditDataEventListener.getAuditable(entity, event.getRepositoryMetadata());
            wrapper.setLastModifiedBy(this.auditorAware == null ? null : this.auditorAware.getCurrentAuditor().orElse(null));
            wrapper.setLastModifiedDate((TemporalAccessor)Instant.now());
        }
    }

    public AuditorAware getAuditorAware() {
        return this.auditorAware;
    }

    private static Auditable getAuditable(Object entity, RepositoryMetadata repositoryMetadata) {
        if (entity instanceof Auditable) {
            return (Auditable)entity;
        }
        return new AuditableWrapper(entity, repositoryMetadata);
    }
}

