/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.string.impl;

import com.mmnaseri.utils.spring.data.error.ParserException;
import com.mmnaseri.utils.spring.data.string.DocumentReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDocumentReader
implements DocumentReader {
    private final String document;
    private int cursor;

    public DefaultDocumentReader(String document) {
        this.document = document;
        this.reset();
    }

    @Override
    public String rest() {
        return this.document.substring(this.cursor);
    }

    @Override
    public boolean has(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.rest());
        return matcher.find() && matcher.start() == 0;
    }

    @Override
    public boolean has(String pattern) {
        if (!pattern.startsWith("^")) {
            pattern = "^" + pattern;
        }
        return this.has(Pattern.compile(pattern, 40));
    }

    @Override
    public boolean hasMore() {
        return !this.rest().isEmpty();
    }

    @Override
    public String read(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.rest());
        if (matcher.find() && matcher.start() == 0) {
            this.cursor += matcher.group().length();
            return matcher.group();
        }
        return null;
    }

    @Override
    public String read(String pattern) {
        return this.read(Pattern.compile(pattern, 40));
    }

    @Override
    public String expect(Pattern pattern) {
        String token = this.read(pattern);
        if (token == null) {
            throw new ParserException("Expected pattern '" + pattern.pattern() + "' was not encountered in document: " + this.document);
        }
        return token;
    }

    @Override
    public String expect(String pattern) {
        return this.expect(Pattern.compile(pattern, 40));
    }

    @Override
    public void reset() {
        this.cursor = 0;
    }

    @Override
    public void backtrack(int count) {
        this.cursor -= count;
    }
}

