/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.tools;

import com.mmnaseri.utils.spring.data.query.PropertyDescriptor;
import com.mmnaseri.utils.spring.data.query.impl.ImmutablePropertyDescriptor;
import com.mmnaseri.utils.spring.data.string.impl.DefaultDocumentReader;
import com.mmnaseri.utils.spring.data.tools.StringUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ReflectionUtils;

public final class PropertyUtils {
    private static final Map<Class<?>, Class<?>> types = new HashMap();

    private PropertyUtils() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public static Object getPropertyValue(Object context, String property) {
        void var8_10;
        String[] chain = property.split("\\.");
        ArrayList<AccessibleObject> accessors = new ArrayList<AccessibleObject>();
        Class<?> type = context.getClass();
        StringBuilder path = new StringBuilder();
        String[] stringArray = chain;
        int n = stringArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            String current = stringArray[var8_10];
            if (path.length() > 0) {
                path.append('.');
            }
            path.append(current);
            Method getter = ReflectionUtils.findMethod(type, (String)("get" + StringUtils.capitalize(current)));
            if (getter != null) {
                accessors.add(getter);
                type = getter.getReturnType();
            } else {
                Field field = ReflectionUtils.findField(type, (String)current);
                if (field != null) {
                    field.setAccessible(true);
                    accessors.add(field);
                    type = field.getType();
                } else {
                    throw new IllegalStateException("Cannot find property `" + path + "` on type `" + context.getClass() + "`");
                }
            }
            ++var8_10;
        }
        Object result = context;
        for (Object e : accessors) {
            try {
                if (e instanceof Method) {
                    Method method = (Method)e;
                    result = method.invoke(result, new Object[0]);
                } else {
                    Field field = (Field)e;
                    result = field.get(result);
                }
            }
            catch (Exception e2) {
                throw new IllegalStateException("Failed to access property `" + property + "`", e2);
            }
            if (result != null) continue;
            return null;
        }
        return result;
    }

    public static Object setPropertyValue(Object context, String property, Object value) {
        if (property.contains(".")) {
            String[] split = property.split("\\.", 2);
            Object propertyValue = PropertyUtils.getPropertyValue(context, split[0]);
            if (propertyValue == null) {
                throw new IllegalStateException("Root property " + split[0] + " was null when reading " + property);
            }
            return PropertyUtils.setPropertyValue(propertyValue, split[1], value);
        }
        Method setter = null;
        String setterName = "set" + StringUtils.capitalize(property);
        if (value != null) {
            setter = ReflectionUtils.findMethod(context.getClass(), (String)setterName, (Class[])new Class[]{value.getClass()});
        } else {
            for (Method method : ReflectionUtils.getAllDeclaredMethods(context.getClass())) {
                if (!method.getName().equals(setterName) || method.getParameterTypes().length != 1 || method.getParameterTypes()[0].isPrimitive()) continue;
                setter = method;
                break;
            }
        }
        if (setter != null) {
            try {
                setter.invoke(context, value);
                return context;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to set property value through the setter method " + setter);
            }
        }
        Field field = ReflectionUtils.findField(context.getClass(), (String)property);
        if (field != null) {
            if (Modifier.isFinal(field.getModifiers())) {
                field.setAccessible(true);
            }
            try {
                field.set(context, value);
                return context;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to set property value through the field " + field);
            }
        }
        throw new IllegalStateException("Failed to find property " + property + " on " + context.getClass());
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> domainType, String expression) {
        String followUp;
        String search = expression;
        if (search.contains("_")) {
            String[] split = search.split("_", 2);
            search = split[0];
            followUp = split[1];
        } else {
            followUp = "";
        }
        Class<?> context = domainType;
        DefaultDocumentReader reader = new DefaultDocumentReader(search);
        ArrayList<String> tokens = new ArrayList<String>();
        while (reader.hasMore()) {
            tokens.add(reader.expect("[A-Z][a-z]*"));
        }
        int cursor = 0;
        StringBuilder path = new StringBuilder();
        while (cursor < tokens.size()) {
            boolean found = false;
            for (int i = tokens.size(); i >= cursor; --i) {
                String propertyName = PropertyUtils.getPropertyName(tokens, cursor, i);
                Method getter = ReflectionUtils.findMethod(context, (String)("get" + StringUtils.capitalize(propertyName)));
                if (getter != null) {
                    context = getter.getReturnType();
                    cursor = i;
                    found = true;
                    path.append(".").append(propertyName);
                    break;
                }
                Field field = ReflectionUtils.findField(context, (String)propertyName);
                if (field == null) continue;
                context = field.getType();
                cursor = i;
                found = true;
                path.append(".").append(propertyName);
                break;
            }
            if (found) continue;
            throw new IllegalStateException("Could not find property `" + PropertyUtils.getPropertyName(tokens, cursor, tokens.size()) + "` on `" + context + "`");
        }
        if (!followUp.isEmpty()) {
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(context, followUp);
            return new ImmutablePropertyDescriptor(path.substring(1) + "." + descriptor.getPath(), descriptor.getType());
        }
        return new ImmutablePropertyDescriptor(path.substring(1), context);
    }

    private static String getPropertyName(List<String> tokens, int from, int to) {
        StringBuilder builder = new StringBuilder();
        for (int i = from; i < to; ++i) {
            builder.append(tokens.get(i));
        }
        return StringUtils.uncapitalize(builder.toString());
    }

    public static Class<?> getTypeOf(Class<?> type) {
        if (type.isPrimitive()) {
            return types.get(type);
        }
        return type;
    }

    public static String getPropertyName(Method getter) {
        return StringUtils.uncapitalize(getter.getName().substring(3));
    }

    static {
        types.put(Integer.TYPE, Integer.class);
        types.put(Short.TYPE, Short.class);
        types.put(Long.TYPE, Long.class);
        types.put(Double.TYPE, Double.class);
        types.put(Character.TYPE, Character.class);
        types.put(Float.TYPE, Float.class);
        types.put(Boolean.TYPE, Boolean.class);
        types.put(Byte.TYPE, Byte.class);
    }
}

