/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KillProcess {
    private static final String os = System.getProperty("os.name");

    public static void main(String ... args) {
        KillProcess.gracefullyTerminateOrKillProcessUsingPort(Integer.parseInt(args[0]), args.length > 1 ? Integer.parseInt(args[1]) : 0, true);
    }

    public static void killProcessUsingPort(int port) {
        KillProcess.gracefullyTerminateOrKillProcessUsingPort(port, 0, false);
    }

    public static void gracefullyTerminateOrKillProcessUsingPort(int port, int terminateWaitSeconds, boolean threadDump) {
        try {
            String pid = KillProcess.getProcessPid(port);
            if (pid == null) {
                return;
            }
            if (threadDump) {
                KillProcess.threadDumpProcess(pid);
            }
            if (terminateWaitSeconds > 0) {
                System.err.println("Terminating process " + pid + " that was using the required listen port " + port);
                KillProcess.termProcess(pid);
                for (int i = 0; i < terminateWaitSeconds; ++i) {
                    TimeUnit.SECONDS.sleep(1L);
                    if (KillProcess.getProcessPid(port) != null) continue;
                    return;
                }
            }
            System.err.println("Killing process " + pid + " that was using the required listen port " + port);
            KillProcess.killProcess(pid);
        }
        catch (Exception e) {
            System.err.println("Failed to kill previous process: " + e.getMessage());
        }
    }

    private static String getProcessPid(int port) throws IOException {
        if (KillProcess.macOrLinux()) {
            Pattern pattern = Pattern.compile("^([^ ]+) *([0-9]+) .*LISTEN");
            Matcher matcher = KillProcess.matchProcessOutput(pattern, "lsof", "-iTCP:" + port);
            if (matcher != null) {
                return matcher.group(2);
            }
        } else {
            if (KillProcess.solaris()) {
                Pattern pattern = Pattern.compile("sockname: AF_INET.*::  port: " + port + "$");
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(Paths.get("/proc", new String[0]));){
                    for (Path p : ds) {
                        String pid = p.getName(p.getNameCount() - 1).toString();
                        Matcher matcher = KillProcess.matchProcessOutput(pattern, "pfiles", pid);
                        if (matcher == null) continue;
                        String string = pid;
                        return string;
                    }
                }
            }
            Pattern pattern = Pattern.compile("TCP.*:" + port + " .*LISTENING ([0-9]+)");
            Matcher matcher = KillProcess.matchProcessOutput(pattern, "netstat", "-ano");
            if (matcher != null) {
                return matcher.group(1);
            }
        }
        return null;
    }

    private static boolean macOrLinux() {
        return "Linux".equals(os) || "Mac OS X".equals(os);
    }

    private static boolean solaris() {
        return "SunOS".equals(os);
    }

    public static void termProcess(String pid) throws IOException, InterruptedException {
        new ProcessBuilder(KillProcess.getTermCommand(pid)).start().waitFor();
    }

    public static void killProcess(String pid) throws IOException, InterruptedException {
        new ProcessBuilder(KillProcess.getKillCommand(pid)).start().waitFor();
    }

    public static void threadDumpProcess(String pid) throws IOException, InterruptedException {
        List<String> cmd = KillProcess.getThreadDumpCommand(pid);
        if (cmd != null) {
            new ProcessBuilder(cmd).start().waitFor();
        }
    }

    private static List<String> getTermCommand(String pid) {
        if (KillProcess.macOrLinux() || KillProcess.solaris()) {
            return Arrays.asList("kill", "-TERM", pid);
        }
        return Arrays.asList("taskkill", "/pid", pid, "/t");
    }

    private static List<String> getKillCommand(String pid) {
        if (KillProcess.macOrLinux() || KillProcess.solaris()) {
            return Arrays.asList("kill", "-KILL", pid);
        }
        return Arrays.asList("taskkill", "/pid", pid, "/t", "/f");
    }

    private static List<String> getThreadDumpCommand(String pid) {
        if (KillProcess.macOrLinux() || KillProcess.solaris()) {
            return Arrays.asList("kill", "-QUIT", pid);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Matcher matchProcessOutput(Pattern pattern, String ... args) throws IOException {
        Process process = new ProcessBuilder(args).start();
        try {
            Matcher matcher = KillProcess.getMatcher(process.getInputStream(), pattern);
            return matcher;
        }
        finally {
            process.destroy();
        }
    }

    /*
     * Exception decompiling
     */
    private static Matcher getMatcher(InputStream is, Pattern pattern) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

