/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.BasePrepareStatement;
import com.oceanbase.jdbc.ExceptionInterceptor;
import com.oceanbase.jdbc.Lob;
import com.oceanbase.jdbc.ObLobLocatorV2;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class Blob
extends Lob
implements java.sql.Blob {
    private static final long serialVersionUID = -4736603161284649490L;

    public Blob() {
        this.data = new byte[0];
        this.offset = 0;
        this.length = 0;
    }

    public static Blob getEmptyBLOB() throws SQLException {
        byte[] emptyData = new byte[40];
        emptyData[0] = 33;
        emptyData[1] = 66;
        emptyData[2] = 79;
        emptyData[3] = 76;
        emptyData[4] = 1;
        return new Blob(true, emptyData, null, null);
    }

    public Blob(Blob other) {
        this.data = other.data;
        this.offset = other.offset;
        this.length = other.length;
    }

    public Blob(byte[] bytes) {
        this.data = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public Blob(byte[] bytes, ExceptionInterceptor exceptionInterceptor) {
        this.data = bytes;
        this.offset = 0;
        this.length = bytes.length;
        this.exceptionInterceptor = exceptionInterceptor;
    }

    public Blob(byte[] bytes, int offset, int length) {
        this.data = bytes;
        this.offset = offset;
        this.length = Math.min(bytes.length - offset, length);
    }

    public Blob(boolean hasLocator, byte[] data, String encoding, OceanBaseConnection conn) throws SQLException {
        if (null != conn) {
            this.encoding = "UTF-8";
        } else if (null != encoding) {
            this.encoding = encoding;
        }
        if (null != data) {
            Buffer buffer = new Buffer(data);
            long magicCode = buffer.readLong4BytesV1();
            long version = buffer.readLong4BytesV1();
            if (version == 1L) {
                this.buildObLobLocatorV1(true, buffer, magicCode, version, conn);
            } else if ((version & 0xFFL) == 2L) {
                this.buildObLobLocatorV2(true, buffer, magicCode, version, conn);
            } else {
                throw new SQLException("Unknown version of lob locator!");
            }
        }
    }

    @Override
    public long length() {
        if (this.locator != null && this.locator instanceof ObLobLocatorV2) {
            return this.locator.payloadSize;
        }
        return this.length;
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.length == 0 && !this.isEmptyLob() && this.locator != null && this.locator instanceof ObLobLocatorV2) {
            this.readFromServer();
        }
        if (this.data != null) {
            return new StringReader(new String(this.data, Charset.forName(this.encoding)));
        }
        return null;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (pattern.length == 0) {
            return 0L;
        }
        if (start < 1L) {
            throw ExceptionFactory.INSTANCE.create(String.format("Out of range (position should be > 0, but is %s)", start));
        }
        if (start > (long)this.length) {
            throw ExceptionFactory.INSTANCE.create("Out of range (start > stream size)");
        }
        block0: for (int i = (int)((long)this.offset + start - 1L); i <= this.offset + this.length - pattern.length; ++i) {
            for (int j = 0; j < pattern.length; ++j) {
                if (this.data[i + j] != pattern[j]) continue block0;
            }
            return i + 1 - this.offset;
        }
        return -1L;
    }

    @Override
    public long position(java.sql.Blob pattern, long start) throws SQLException {
        byte[] blobBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(blobBytes, start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("pos should be > 0, first position is 1.");
        }
        if (bytes == null || bytes.length == 0) {
            return 0;
        }
        if (this.locator != null) {
            this.updateBlobToServer(pos, bytes, 0, bytes.length);
            return bytes.length;
        }
        int arrayPos = (int)pos - 1;
        if (this.length > arrayPos + bytes.length) {
            System.arraycopy(bytes, 0, this.data, this.offset + arrayPos, bytes.length);
        } else {
            byte[] newContent = new byte[arrayPos + bytes.length];
            if (Math.min(arrayPos, this.length) > 0) {
                System.arraycopy(this.data, this.offset, newContent, 0, Math.min(arrayPos, this.length));
            }
            System.arraycopy(bytes, 0, newContent, arrayPos, bytes.length);
            this.data = newContent;
            this.length = arrayPos + bytes.length;
            this.offset = 0;
            this.charData = new String(this.data, Charset.forName(this.encoding == null ? "UTF-8" : this.encoding));
        }
        return bytes.length;
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("pos should be > 0, first position is 1.");
        }
        if (this.locator != null) {
            this.updateBlobToServer(pos, bytes, offset, len);
            return len;
        }
        int arrayPos = (int)pos - 1;
        int byteToWrite = Math.min(bytes.length - offset, len);
        if (this.length > arrayPos + byteToWrite) {
            System.arraycopy(bytes, offset, this.data, this.offset + arrayPos, byteToWrite);
        } else {
            byte[] newContent = new byte[arrayPos + byteToWrite];
            if (Math.min(arrayPos, this.length) > 0) {
                System.arraycopy(this.data, this.offset, newContent, 0, Math.min(arrayPos, this.length));
            }
            System.arraycopy(bytes, offset, newContent, arrayPos, byteToWrite);
            this.data = newContent;
            this.length = arrayPos + byteToWrite;
            this.offset = 0;
            this.charData = new String(this.data, Charset.forName(this.encoding == null ? "UTF-8" : this.encoding));
        }
        return byteToWrite;
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len < 0L) {
            if (this.isOracleMode) {
                throw new SQLException("'len' should be >= 0");
            }
            throw new SQLException("\"len\" argument can not be < 1");
        }
        if (len > (long)this.length) {
            throw new SQLException("\"len\" argument can not be larger than the BLOB's length");
        }
        if (this.locator != null) {
            this.trimBlobToServer((int)len);
        } else if (len >= 0L && len < (long)this.length) {
            this.length = (int)len;
        }
    }

    public synchronized void updateBlobToServer(long writeAt, byte[] bytes, int offset, int length) throws SQLException {
        if (this.locator == null || this.locator.connection == null) {
            throw new SQLException("Invalid operation on closed BLOB");
        }
        int writeOffset = (int)writeAt;
        int localOffset = offset;
        try (CallableStatement cstmt = this.locator.connection.prepareCall("{call DBMS_LOB.write( ?, ?, ?, ?)}");){
            int writeAmount;
            ((OceanBaseStatement)((Object)cstmt)).setInternal();
            for (int lengthLeft = length; lengthLeft > 0; lengthLeft -= writeAmount) {
                writeAmount = Math.min(lengthLeft, DBMS_LOB_MAX_AMOUNT);
                byte[] writeBuffer = new byte[writeAmount];
                System.arraycopy(bytes, localOffset, writeBuffer, 0, writeAmount);
                ((BasePrepareStatement)((Object)cstmt)).setLobLocator(1, this);
                cstmt.setInt(2, writeAmount);
                cstmt.setInt(3, writeOffset);
                cstmt.setBytes(4, writeBuffer);
                cstmt.registerOutParameter(1, 2004);
                cstmt.execute();
                writeOffset += writeAmount;
                localOffset += writeAmount;
            }
            Blob r = (Blob)cstmt.getBlob(1);
            if (r == null || r.getLocator() == null) {
                throw new SQLException("Invalid operator on setBytes for BLOB");
            }
            this.copy(r);
        }
    }

    public synchronized void trimBlobToServer(int len) throws SQLException {
        if (this.locator == null || this.locator.connection == null) {
            throw new SQLException("Invalid operation on closed BLOB");
        }
        try (CallableStatement cstmt = this.locator.connection.prepareCall("{call DBMS_LOB.trim( ?, ?)}");){
            ((OceanBaseStatement)((Object)cstmt)).setInternal();
            ((BasePrepareStatement)((Object)cstmt)).setLobLocator(1, this);
            cstmt.setInt(2, len);
            cstmt.registerOutParameter(1, 2004);
            cstmt.execute();
            Blob r = (Blob)cstmt.getBlob(1);
            if (r == null || r.getLocator() == null) {
                throw new SQLException("Invalid operator on trim() for BLOB");
            }
            this.copy(r);
        }
    }

    @Override
    protected synchronized void readFromServer() throws SQLException {
        if (this.locator == null || this.locator.connection == null) {
            throw new SQLException("Invalid operation on closed CLOB");
        }
        this.clearData();
        int offset = 1;
        try {
            CallableStatement cstmt = this.locator.connection.getLobConn().prepareCall("{call DBMS_LOB.READ( ?, ?, ?, ?)}");
            Throwable throwable = null;
            try {
                try {
                    ((OceanBaseStatement)((Object)cstmt)).setInternal();
                    while (true) {
                        cstmt.setBlob(1, (java.sql.Blob)this);
                        cstmt.setInt(2, DBMS_LOB_MAX_AMOUNT);
                        cstmt.setInt(3, offset);
                        cstmt.registerOutParameter(2, 4);
                        cstmt.registerOutParameter(4, 12);
                        cstmt.execute();
                        int amount = cstmt.getInt(2);
                        offset += amount;
                        byte[] outRaw = cstmt.getBytes(4);
                        if (this.data == null || this.data.length == 0) {
                            this.data = outRaw;
                            continue;
                        }
                        byte[] newData = new byte[this.data.length + outRaw.length];
                        System.arraycopy(this.data, 0, newData, 0, this.data.length);
                        System.arraycopy(outRaw, 0, newData, this.data.length, outRaw.length);
                        this.data = newData;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cstmt != null) {
                    if (throwable != null) {
                        try {
                            cstmt.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cstmt.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (SQLException ex) {
            if (!ex.getMessage().contains("no data found")) {
                throw ex;
            }
            this.length = this.data.length;
            return;
        }
    }
}

