/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.extend.datatype.DataTypeUtilities;
import com.oceanbase.jdbc.extend.datatype.Datum;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMP;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class TIMESTAMPLTZ
extends Datum {
    public TIMESTAMPLTZ() {
        super(DataTypeUtilities.initTimestampltz());
    }

    public TIMESTAMPLTZ(byte[] bytes) {
        super(bytes);
    }

    public TIMESTAMPLTZ(Connection connection, Time time) throws SQLException {
        super(DataTypeUtilities.TIMESTMAPLTZToBytes(connection, time));
    }

    public TIMESTAMPLTZ(Connection connection, Date date) throws SQLException {
        super(DataTypeUtilities.TIMESTMAPLTZToBytes(connection, date));
    }

    public TIMESTAMPLTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(DataTypeUtilities.TIMESTMAPLTZToBytes(connection, timestamp));
    }

    public String toResultSetString(Connection connection) throws SQLException {
        return DataTypeUtilities.TIMESTMAPLTZToString(connection, this.getBytes(), true);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Connection connection, String time) throws SQLException {
        return DataTypeUtilities.TIMESTMAPLTZToBytes(connection, Timestamp.valueOf(time));
    }

    @Override
    public Date dateValue() throws SQLException {
        throw new SQLException("Conversion to Date failed");
    }

    public static Date toDate(Connection connection, byte[] bytes) throws SQLException {
        return new Date(DataTypeUtilities.getOriginTime(bytes, TimeZone.getTimeZone(((OceanBaseConnection)connection).getSessionTimeZone()), false));
    }

    public static Time toTime(Connection connection, byte[] bytes) throws SQLException {
        return new Time(DataTypeUtilities.getOriginTime(bytes, TimeZone.getTimeZone(((OceanBaseConnection)connection).getSessionTimeZone())));
    }

    public static Timestamp toTimestamp(Connection connection, byte[] bytes) throws SQLException {
        if (bytes.length < 12) {
            throw new SQLException("invalid bytes length");
        }
        Timestamp timestamp = new Timestamp(DataTypeUtilities.getOriginTime(bytes, TimeZone.getTimeZone(((OceanBaseConnection)connection).getSessionTimeZone())));
        timestamp.setNanos(DataTypeUtilities.getNanos(bytes, 7));
        return timestamp;
    }

    public static Timestamp toTimestamp(Protocol protocol, byte[] bytes) throws SQLException {
        if (bytes.length < 12) {
            throw new SQLException("invalid bytes length");
        }
        Timestamp timestamp = new Timestamp(DataTypeUtilities.getOriginTime(bytes, TimeZone.getTimeZone(protocol.getTimeZone().getID()), false));
        timestamp.setNanos(DataTypeUtilities.getNanos(bytes, 7));
        return timestamp;
    }

    public static Timestamp toTimestamp(Protocol protocol, byte[] bytes, boolean isResult) throws SQLException {
        if (bytes.length < 12) {
            throw new SQLException("invalid bytes length");
        }
        Timestamp timestamp = new Timestamp(DataTypeUtilities.getOriginTime(bytes, TimeZone.getTimeZone(protocol.getTimeZone().getID()), !isResult));
        timestamp.setNanos(DataTypeUtilities.getNanos(bytes, 7));
        return timestamp;
    }

    public static TIMESTAMP toTIMESTAMP(Connection connection, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPLTZ.toTimestamp(connection, bytes));
    }

    public static TIMESTAMP toTIMESTAMP(Protocol protocol, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPLTZ.toTimestamp(protocol, bytes));
    }

    public static TIMESTAMP resultTIMESTAMP(Protocol protocol, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPLTZ.toTimestamp(protocol, bytes, true));
    }

    public static TIMESTAMPTZ toTIMESTAMPTZ(Connection connection, byte[] bytes) throws SQLException {
        return new TIMESTAMPTZ(connection, TIMESTAMPLTZ.toTimestamp(connection, bytes), Calendar.getInstance());
    }

    public Timestamp timestampValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(connection, this.getBytes());
    }

    @Override
    public String stringValue(Connection connection) throws SQLException {
        return DataTypeUtilities.TIMESTMAPLTZToString(connection, this.getBytes(), false);
    }

    public Date dateValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toDate(connection, this.getBytes());
    }

    public Time timeValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toTime(connection, this.getBytes());
    }

    @Override
    public Object toJdbc() throws SQLException {
        return null;
    }

    @Override
    public Object makeJdbcArray(int time) {
        Timestamp[] timestamps = new Timestamp[time];
        return timestamps;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }
}

