/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.console;

import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.console.TTYConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.orient.console.OConsoleDatabaseApp;
import com.orientechnologies.orient.core.command.OCommandExecutorNotFoundException;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.graph.console.OGraphMLReader;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import com.orientechnologies.orient.graph.migration.OGraphMigration;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class OGremlinConsole
extends OConsoleDatabaseApp {
    public OGremlinConsole(String[] args) {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int result;
        try {
            boolean tty = false;
            try {
                if (OGremlinConsole.setTerminalToCBreak()) {
                    tty = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            OGremlinConsole console = new OGremlinConsole(args);
            if (tty) {
                console.setReader((OConsoleReader)new TTYConsoleReader());
            }
            result = console.run();
        }
        finally {
            try {
                OGremlinConsole.stty((String)"echo");
            }
            catch (Exception exception) {}
        }
        System.exit(result);
    }

    @ConsoleCommand(splitInWords=false, description="Execute a GREMLIN script")
    public void gremlin(@ConsoleParameter(name="script-text", description="The script text to execute") String iScriptText) {
        block3: {
            this.checkForDatabase();
            if (iScriptText == null || iScriptText.length() == 0) {
                return;
            }
            this.currentResultSet.clear();
            long start = System.currentTimeMillis();
            try {
                Object result = this.currentDatabase.command((OCommandRequest)new OCommandGremlin(iScriptText)).execute(new Object[0]);
                float elapsedSeconds = (System.currentTimeMillis() - start) / 1000L;
                this.out.println("\n" + result);
                this.out.printf("\nScript executed in %f sec(s).", Float.valueOf(elapsedSeconds));
            }
            catch (OStorageException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof OCommandExecutorNotFoundException)) break block3;
                this.out.printf("\nError: the GREMLIN command executor is not installed, check your configuration", new Object[0]);
            }
        }
    }

    @ConsoleCommand(description="Import a database into the current one", splitInWords=false)
    public void importDatabase(@ConsoleParameter(name="options", description="Import options") String text) throws IOException {
        String options;
        this.checkForDatabase();
        List items = OStringSerializerHelper.smartSplit((String)text, (char)' ', (char[])new char[0]);
        String fileName = items.size() <= 0 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
        String string = options = fileName != null ? text.substring(((String)items.get(0)).length() + ((String)items.get(1)).length() + 1).trim() : text;
        if (fileName != null && fileName.endsWith(".graphml")) {
            this.message("\nImporting GRAPHML database from " + text + "...", new Object[0]);
            try {
                Map opts = this.parseOptions(options);
                OrientGraph g = new OrientGraph(this.currentDatabase);
                g.setUseLog(false);
                g.setWarnOnForceClosingTx(false);
                new OGraphMLReader(g).setOptions(opts).inputGraph((Graph)g, fileName);
                g.commit();
                this.commit();
            }
            catch (ODatabaseImportException e) {
                this.printError((Exception)((Object)e));
            }
        } else {
            super.importDatabase(text);
        }
    }

    @ConsoleCommand(description="Migrates graph from OMVRBTree to ORidBag")
    public void upgradeGraph() {
        OGraphMigration migration = new OGraphMigration(this.getCurrentDatabase(), (OCommandOutputListener)this);
        migration.execute();
        this.message("Graph has been upgraded.", new Object[0]);
    }

    protected void onBefore() {
        super.onBefore();
        this.out.println("\nInstalling extensions for GREMLIN language v." + OGremlinHelper.getEngineVersion());
        OGremlinHelper.global().create();
    }

    protected boolean isCollectingCommands(String iLine) {
        return super.isCollectingCommands(iLine) || iLine.startsWith("gremlin");
    }
}

