/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.script;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.Set;

public class OScriptGraphWrapper
implements TransactionalGraph {
    protected OrientBaseGraph graph;

    public OScriptGraphWrapper(OrientBaseGraph iWrapped) {
        this.graph = iWrapped;
    }

    public Object command(String language, String iText) {
        return this.command(language, iText, null);
    }

    public Object command(String language, String iText, Object[] iArgs) {
        Object result = null;
        result = language.equalsIgnoreCase("sql") ? this.graph.command((OCommandRequest)new OCommandSQL(iText)).execute(iArgs) : (language.equalsIgnoreCase("gremlin") ? this.graph.command((OCommandRequest)new OCommandGremlin(iText)).execute(iArgs) : this.graph.command((OCommandRequest)new OCommandScript(language, iText)).execute(iArgs));
        if (result instanceof Iterable) {
            ArrayList list = new ArrayList();
            for (Object o : (Iterable)result) {
                list.add(o);
            }
            result = list.toArray();
        }
        return result;
    }

    public Features getFeatures() {
        return this.graph.getFeatures();
    }

    public int hashCode() {
        return this.graph.hashCode();
    }

    public void commit() {
        this.graph.commit();
    }

    public void rollback() {
        this.graph.rollback();
    }

    public boolean isAutoStartTx() {
        if (this.graph instanceof OrientGraph) {
            return ((OrientGraph)this.graph).isAutoStartTx();
        }
        return false;
    }

    public void setAutoStartTx(boolean autoStartTx) {
        if (this.graph instanceof OrientGraph) {
            ((OrientGraph)this.graph).setAutoStartTx(autoStartTx);
        }
    }

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (this.graph instanceof OrientGraph) {
            ((OrientGraph)this.graph).stopTransaction(conclusion);
        }
    }

    public boolean equals(Object obj) {
        return this.graph.equals(obj);
    }

    public void drop() {
        this.graph.drop();
    }

    public <T extends Element> Index<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        return this.graph.createIndex(indexName, indexClass, indexParameters);
    }

    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        return this.graph.getIndex(indexName, indexClass);
    }

    public Iterable<Index<? extends Element>> getIndices() {
        return this.graph.getIndices();
    }

    public void dropIndex(String indexName) {
        this.graph.dropIndex(indexName);
    }

    public OrientVertex addVertex(Object id) {
        return this.graph.addVertex(id);
    }

    public OrientVertex addVertex(Object id, Object[] prop) {
        return this.graph.addVertex(id, prop);
    }

    public OrientVertex addTemporaryVertex(String iClassName, Object[] prop) {
        return this.graph.addTemporaryVertex(iClassName, prop);
    }

    public OrientEdge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        return this.graph.addEdge(id, outVertex, inVertex, label);
    }

    public OrientVertex getVertex(Object id) {
        return this.graph.getVertex(id);
    }

    public void removeVertex(Vertex vertex) {
        this.graph.removeVertex(vertex);
    }

    public Iterable<Vertex> getVertices() {
        return this.graph.getVertices();
    }

    public Iterable<Vertex> getVertices(boolean iPolymorphic) {
        return this.graph.getVertices(iPolymorphic);
    }

    public Iterable<Vertex> getVerticesOfClass(String iClassName) {
        return this.graph.getVerticesOfClass(iClassName);
    }

    public Iterable<Vertex> getVerticesOfClass(String iClassName, boolean iPolymorphic) {
        return this.graph.getVerticesOfClass(iClassName, iPolymorphic);
    }

    public Iterable<Vertex> getVertices(String iKey, Object iValue) {
        return this.graph.getVertices(iKey, iValue);
    }

    public Iterable<Edge> getEdges() {
        return this.graph.getEdges();
    }

    public Iterable<Edge> getEdges(boolean iPolymorphic) {
        return this.graph.getEdges(iPolymorphic);
    }

    public Iterable<Edge> getEdgesOfClass(String iClassName) {
        return this.graph.getEdgesOfClass(iClassName);
    }

    public Iterable<Edge> getEdgesOfClass(String iClassName, boolean iPolymorphic) {
        return this.graph.getEdgesOfClass(iClassName, iPolymorphic);
    }

    public Iterable<Edge> getEdges(String iKey, Object iValue) {
        return this.graph.getEdges(iKey, iValue);
    }

    public OrientEdge getEdge(Object id) {
        return this.graph.getEdge(id);
    }

    public void removeEdge(Edge edge) {
        this.graph.removeEdge(edge);
    }

    public OrientBaseGraph reuse(ODatabaseDocumentTx iDatabase) {
        return this.graph.reuse(iDatabase);
    }

    public boolean isClosed() {
        return this.graph.isClosed();
    }

    public void shutdown() {
        this.graph.shutdown();
    }

    public String toString() {
        return this.graph.toString();
    }

    public ODatabaseDocumentTx getRawGraph() {
        return this.graph.getRawGraph();
    }

    public OClass getVertexBaseType() {
        return this.graph.getVertexBaseType();
    }

    public final OClass getVertexType(String iTypeName) {
        return this.graph.getVertexType(iTypeName);
    }

    public OClass createVertexType(String iClassName) {
        return this.graph.createVertexType(iClassName);
    }

    public OClass createVertexType(String iClassName, String iSuperClassName) {
        return this.graph.createVertexType(iClassName, iSuperClassName);
    }

    public OClass createVertexType(String iClassName, OClass iSuperClass) {
        return this.graph.createVertexType(iClassName, iSuperClass);
    }

    public final void dropVertexType(String iTypeName) {
        this.graph.dropVertexType(iTypeName);
    }

    public OClass getEdgeBaseType() {
        return this.graph.getEdgeBaseType();
    }

    public final OClass getEdgeType(String iTypeName) {
        return this.graph.getEdgeType(iTypeName);
    }

    public OClass createEdgeType(String iClassName) {
        return this.graph.createEdgeType(iClassName);
    }

    public OClass createEdgeType(String iClassName, String iSuperClassName) {
        return this.graph.createEdgeType(iClassName, iSuperClassName);
    }

    public OClass createEdgeType(String iClassName, OClass iSuperClass) {
        return this.graph.createEdgeType(iClassName, iSuperClass);
    }

    public final void dropEdgeType(String iTypeName) {
        this.graph.dropEdgeType(iTypeName);
    }

    public OrientElement getElement(Object id) {
        return this.graph.getElement(id);
    }

    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        this.graph.dropKeyIndex(key, elementClass);
    }

    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass, Parameter ... indexParameters) {
        this.graph.createKeyIndex(key, elementClass, indexParameters);
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        return this.graph.getIndexedKeys(elementClass);
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass, boolean includeClassNames) {
        return this.graph.getIndexedKeys(elementClass, includeClassNames);
    }

    public GraphQuery query() {
        return this.graph.query();
    }

    public OTraverse traverse() {
        return this.graph.traverse();
    }

    public OCommandRequest command(OCommandRequest iCommand) {
        return this.graph.command(iCommand);
    }

    public boolean isUseLightweightEdges() {
        return this.graph.isUseLightweightEdges();
    }

    public void setUseLightweightEdges(boolean useDynamicEdges) {
        this.graph.setUseLightweightEdges(useDynamicEdges);
    }

    public boolean isSaveOriginalIds() {
        return this.graph.isSaveOriginalIds();
    }

    public void setSaveOriginalIds(boolean saveIds) {
        this.graph.setSaveOriginalIds(saveIds);
    }

    public long countVertices() {
        return this.graph.countVertices();
    }

    public long countVertices(String iClassName) {
        return this.graph.countVertices(iClassName);
    }

    public long countEdges() {
        return this.graph.countEdges();
    }

    public long countEdges(String iClassName) {
        return this.graph.countEdges(iClassName);
    }

    public boolean isKeepInMemoryReferences() {
        return this.graph.isKeepInMemoryReferences();
    }

    public void setKeepInMemoryReferences(boolean useReferences) {
        this.graph.setKeepInMemoryReferences(useReferences);
    }

    public boolean isUseClassForEdgeLabel() {
        return this.graph.isUseClassForEdgeLabel();
    }

    public void setUseClassForEdgeLabel(boolean useCustomClassesForEdges) {
        this.graph.setUseClassForEdgeLabel(useCustomClassesForEdges);
    }

    public boolean isUseClassForVertexLabel() {
        return this.graph.isUseClassForVertexLabel();
    }

    public void setUseClassForVertexLabel(boolean useCustomClassesForVertex) {
        this.graph.setUseClassForVertexLabel(useCustomClassesForVertex);
    }

    public boolean isUseVertexFieldsForEdgeLabels() {
        return this.graph.isUseVertexFieldsForEdgeLabels();
    }

    public void setUseVertexFieldsForEdgeLabels(boolean useVertexFieldsForEdgeLabels) {
        this.graph.setUseVertexFieldsForEdgeLabels(useVertexFieldsForEdgeLabels);
    }

    public boolean isStandardElementConstraints() {
        return this.graph.isStandardElementConstraints();
    }

    public void setStandardElementConstraints(boolean allowsPropertyValueNull) {
        this.graph.setStandardElementConstraints(allowsPropertyValueNull);
    }

    public OrientConfigurableGraph.THREAD_MODE getThreadMode() {
        return this.graph.getThreadMode();
    }

    public OrientBaseGraph setThreadMode(OrientConfigurableGraph.THREAD_MODE iControl) {
        return (OrientBaseGraph)this.graph.setThreadMode(iControl);
    }
}

