/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFactory;
import com.orientechnologies.orient.graph.sql.OCommandExecutorSQLCreateEdge;
import com.orientechnologies.orient.graph.sql.OCommandExecutorSQLCreateVertex;
import com.orientechnologies.orient.graph.sql.OCommandExecutorSQLDeleteEdge;
import com.orientechnologies.orient.graph.sql.OCommandExecutorSQLDeleteVertex;
import com.orientechnologies.orient.graph.sql.OCommandExecutorSQLMoveVertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OGraphCommandExecutorSQLFactory
implements OCommandExecutorSQLFactory {
    private static final Map<String, Class<? extends OCommandExecutorSQLAbstract>> COMMANDS;

    public static OrientGraph getGraph(boolean autoStartTx, OModifiableBoolean shouldBeShutDown) {
        ODatabaseDocumentTx graphDb;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.get();
        OrientBaseGraph result = OrientBaseGraph.getActiveGraph();
        if (result != null && result instanceof OrientGraph && !(graphDb = result.getRawGraph()).isClosed()) {
            ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)graphDb);
            shouldBeShutDown.setValue(false);
            return (OrientGraph)result;
        }
        ODatabaseRecordThreadLocal.INSTANCE.set(database);
        shouldBeShutDown.setValue(true);
        return new OrientGraph((ODatabaseDocumentTx)database, autoStartTx);
    }

    public static OrientGraphNoTx getGraphNoTx(OModifiableBoolean shouldBeShutDown) {
        ODatabaseDocumentTx graphDb;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.get();
        OrientBaseGraph result = OrientBaseGraph.getActiveGraph();
        if (result != null && result instanceof OrientGraphNoTx && !(graphDb = result.getRawGraph()).isClosed()) {
            ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)graphDb);
            shouldBeShutDown.setValue(false);
            return (OrientGraphNoTx)result;
        }
        shouldBeShutDown.setValue(true);
        ODatabaseRecordThreadLocal.INSTANCE.set(database);
        return new OrientGraphNoTx((ODatabaseDocumentTx)database);
    }

    public static <T> T runInTx(OrientGraph graph, GraphCallBack<T> callBack) {
        ODatabaseDocument databaseRecord = OGraphCommandExecutorSQLFactory.getDatabase();
        boolean txWasActive = databaseRecord.getTransaction().isActive();
        if (!txWasActive) {
            graph.getRawGraph().begin();
        }
        try {
            T result = callBack.call(graph);
            if (!txWasActive) {
                graph.commit();
            }
            return result;
        }
        catch (RuntimeException e) {
            if (!txWasActive) {
                graph.rollback();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInTx(GraphCallBack<T> callBack) {
        OModifiableBoolean shutdownFlag = new OModifiableBoolean();
        ODatabaseDocumentInternal curDb = ODatabaseRecordThreadLocal.INSTANCE.get();
        OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(false, shutdownFlag);
        try {
            T t = OGraphCommandExecutorSQLFactory.runInTx(graph, callBack);
            return t;
        }
        finally {
            if (shutdownFlag.getValue()) {
                graph.shutdown(false, false);
            }
            ODatabaseRecordThreadLocal.INSTANCE.set(curDb);
        }
    }

    public static ODatabaseDocument getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    public Set<String> getCommandNames() {
        return COMMANDS.keySet();
    }

    public OCommandExecutorSQLAbstract createCommand(String name) throws OCommandExecutionException {
        Class<? extends OCommandExecutorSQLAbstract> clazz = COMMANDS.get(name);
        if (clazz == null) {
            throw new OCommandExecutionException("Unknown command name :" + name);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error in creation of command " + name + "(). Probably there is not an empty constructor or the constructor generates errors", (Throwable)e);
        }
    }

    static {
        HashMap<String, Class<OCommandExecutorSQLMoveVertex>> commands = new HashMap<String, Class<OCommandExecutorSQLMoveVertex>>();
        commands.put("CREATE EDGE", OCommandExecutorSQLCreateEdge.class);
        commands.put("DELETE EDGE", OCommandExecutorSQLDeleteEdge.class);
        commands.put("CREATE VERTEX", OCommandExecutorSQLCreateVertex.class);
        commands.put("DELETE VERTEX", OCommandExecutorSQLDeleteVertex.class);
        commands.put("MOVE VERTEX", OCommandExecutorSQLMoveVertex.class);
        COMMANDS = Collections.unmodifiableMap(commands);
    }

    public static interface GraphCallBack<T> {
        public T call(OrientBaseGraph var1);
    }
}

