/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionPathFinder;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;
import java.util.LinkedList;

public class OSQLFunctionDijkstra
extends OSQLFunctionPathFinder {
    public static final String NAME = "dijkstra";
    private String paramWeightFieldName;

    public OSQLFunctionDijkstra() {
        super(NAME, 3, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<OrientVertex> execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        OModifiableBoolean shutdownFlag = new OModifiableBoolean();
        ODatabaseDocumentInternal curDb = ODatabaseRecordThreadLocal.INSTANCE.get();
        OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(false, shutdownFlag);
        try {
            ORecord record = iCurrentRecord != null ? iCurrentRecord.getRecord() : null;
            Object source = iParams[0];
            if (OMultiValue.isMultiValue((Object)source)) {
                if (OMultiValue.getSize((Object)source) > 1) {
                    throw new IllegalArgumentException("Only one sourceVertex is allowed");
                }
                source = OMultiValue.getFirstValue((Object)source);
            }
            this.paramSourceVertex = graph.getVertex(OSQLHelper.getValue((Object)source, (ORecord)record, (OCommandContext)iContext));
            Object dest = iParams[1];
            if (OMultiValue.isMultiValue((Object)dest)) {
                if (OMultiValue.getSize((Object)dest) > 1) {
                    throw new IllegalArgumentException("Only one destinationVertex is allowed");
                }
                dest = OMultiValue.getFirstValue((Object)dest);
            }
            this.paramDestinationVertex = graph.getVertex(OSQLHelper.getValue((Object)dest, (ORecord)record, (OCommandContext)iContext));
            this.paramWeightFieldName = OStringSerializerHelper.getStringContent((Object)iParams[2]);
            if (iParams.length > 3) {
                this.paramDirection = Direction.valueOf((String)iParams[3].toString().toUpperCase());
            }
            LinkedList<OrientVertex> linkedList = super.execute(iContext);
            return linkedList;
        }
        finally {
            if (shutdownFlag.getValue()) {
                graph.shutdown(false);
            }
            ODatabaseRecordThreadLocal.INSTANCE.set(curDb);
        }
    }

    public String getSyntax() {
        return "dijkstra(<sourceVertex>, <destinationVertex>, <weightEdgeFieldName>, [<direction>])";
    }

    @Override
    protected float getDistance(OrientVertex node, OrientVertex target) {
        Object fieldValue;
        Edge e;
        Iterator<Edge> edges = node.getEdges(target, this.paramDirection, new String[0]).iterator();
        if (edges.hasNext() && (e = edges.next()) != null && (fieldValue = e.getProperty(this.paramWeightFieldName)) != null) {
            if (fieldValue instanceof Float) {
                return ((Float)fieldValue).floatValue();
            }
            if (fieldValue instanceof Number) {
                return ((Number)fieldValue).floatValue();
            }
        }
        return 0.0f;
    }

    @Override
    protected boolean isVariableEdgeWeight() {
        return true;
    }
}

