/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionConfigurableAbstract;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.HashSet;

public abstract class OSQLFunctionMove
extends OSQLFunctionConfigurableAbstract {
    public static final String NAME = "move";

    public OSQLFunctionMove() {
        super(NAME, 1, 2);
    }

    public OSQLFunctionMove(String iName, int iMin, int iMax) {
        super(iName, iMin, iMax);
    }

    protected abstract Object move(OrientBaseGraph var1, OIdentifiable var2, String[] var3);

    public String getSyntax() {
        return "Syntax error: " + this.name + "([<labels>])";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        OModifiableBoolean shutdownFlag = new OModifiableBoolean();
        ODatabaseDocumentInternal curDb = ODatabaseRecordThreadLocal.INSTANCE.get();
        final OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(false, shutdownFlag);
        try {
            final String[] labels = iParameters != null && iParameters.length > 0 && iParameters[0] != null ? (String[])OMultiValue.array((Object)iParameters, String.class, (OCallable)new OCallable<Object, Object>(){

                public Object call(Object iArgument) {
                    return OStringSerializerHelper.getStringContent((Object)iArgument);
                }
            }) : null;
            Object object = OSQLEngine.foreachRecord((OCallable)new OCallable<Object, OIdentifiable>(){

                public Object call(OIdentifiable iArgument) {
                    return OSQLFunctionMove.this.move(graph, iArgument, labels);
                }
            }, (Object)iThis, (OCommandContext)iContext);
            return object;
        }
        finally {
            if (shutdownFlag.getValue()) {
                graph.shutdown(false);
            }
            ODatabaseRecordThreadLocal.INSTANCE.set(curDb);
        }
    }

    protected Object v2v(OrientBaseGraph graph, OIdentifiable iRecord, Direction iDirection, String[] iLabels) {
        OrientVertex vertex;
        ODocument rec = (ODocument)iRecord.getRecord();
        if (ODocumentInternal.getImmutableSchemaClass((ODocument)rec) != null && ODocumentInternal.getImmutableSchemaClass((ODocument)rec).isSubClassOf("V") && (vertex = graph.getVertex(rec)) != null) {
            return vertex.getVertices(iDirection, iLabels);
        }
        return null;
    }

    protected Object v2e(OrientBaseGraph graph, OIdentifiable iRecord, Direction iDirection, String[] iLabels) {
        OrientVertex vertex;
        ODocument rec = (ODocument)iRecord.getRecord();
        if (ODocumentInternal.getImmutableSchemaClass((ODocument)rec) != null && ODocumentInternal.getImmutableSchemaClass((ODocument)rec).isSubClassOf("V") && (vertex = graph.getVertex(rec)) != null) {
            return vertex.getEdges(iDirection, iLabels);
        }
        return null;
    }

    protected Object e2v(OrientBaseGraph graph, OIdentifiable iRecord, Direction iDirection, String[] iLabels) {
        OrientEdge edge;
        ODocument rec = (ODocument)iRecord.getRecord();
        if (ODocumentInternal.getImmutableSchemaClass((ODocument)rec) != null && ODocumentInternal.getImmutableSchemaClass((ODocument)rec).isSubClassOf("E") && (edge = graph.getEdge(rec)) != null) {
            if (Direction.BOTH.equals((Object)iDirection)) {
                HashSet<OrientVertex> result = new HashSet<OrientVertex>();
                result.add(edge.getVertex(Direction.OUT));
                result.add(edge.getVertex(Direction.IN));
                return result;
            }
            OrientVertex out = edge.getVertex(iDirection);
            return out;
        }
        return null;
    }
}

