/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OSQLFunctionShortestPath
extends OSQLFunctionMathAbstract {
    public static final String NAME = "shortestPath";
    protected static final float DISTANCE = 1.0f;

    public OSQLFunctionShortestPath() {
        super(NAME, 2, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ORID> execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        OModifiableBoolean shutdownFlag = new OModifiableBoolean();
        ODatabaseDocumentInternal curDb = ODatabaseRecordThreadLocal.INSTANCE.get();
        OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(false, shutdownFlag);
        try {
            OrientVertex destinationVertex;
            ORecord record = iCurrentRecord != null ? iCurrentRecord.getRecord() : null;
            Object source = iParams[0];
            if (OMultiValue.isMultiValue((Object)source)) {
                if (OMultiValue.getSize((Object)source) > 1) {
                    throw new IllegalArgumentException("Only one sourceVertex is allowed");
                }
                source = OMultiValue.getFirstValue((Object)source);
            }
            OrientVertex sourceVertex = graph.getVertex(OSQLHelper.getValue((Object)source, (ORecord)record, (OCommandContext)iContext));
            Object dest = iParams[1];
            if (OMultiValue.isMultiValue((Object)dest)) {
                if (OMultiValue.getSize((Object)dest) > 1) {
                    throw new IllegalArgumentException("Only one destinationVertex is allowed");
                }
                dest = OMultiValue.getFirstValue((Object)dest);
            }
            if (sourceVertex.equals(destinationVertex = graph.getVertex(OSQLHelper.getValue((Object)dest, (ORecord)record, (OCommandContext)iContext)))) {
                ArrayList<ORID> result = new ArrayList<ORID>(1);
                result.add(destinationVertex.getIdentity());
                ArrayList<ORID> arrayList = result;
                return arrayList;
            }
            Direction direction = Direction.BOTH;
            Direction reverseDirection = Direction.BOTH;
            if (iParams.length > 2 && iParams[2] != null) {
                direction = Direction.valueOf((String)iParams[2].toString().toUpperCase());
            }
            if (direction == Direction.OUT) {
                reverseDirection = Direction.IN;
            } else if (direction == Direction.IN) {
                reverseDirection = Direction.OUT;
            }
            Object edgeType = null;
            if (iParams.length > 3) {
                edgeType = iParams[3];
            }
            ArrayDeque<OrientVertex> queue1 = new ArrayDeque<OrientVertex>();
            ArrayDeque<OrientVertex> queue2 = new ArrayDeque<OrientVertex>();
            HashSet<ORID> visited = new HashSet<ORID>();
            HashSet<ORID> leftVisited = new HashSet<ORID>();
            HashSet<ORID> rightVisited = new HashSet<ORID>();
            HashMap<ORID, ORID> previouses = new HashMap<ORID, ORID>();
            HashMap<ORID, ORID> nexts = new HashMap<ORID, ORID>();
            queue1.add(sourceVertex);
            visited.add(sourceVertex.getIdentity());
            queue2.add(destinationVertex);
            visited.add(destinationVertex.getIdentity());
            while (!queue1.isEmpty() || !queue2.isEmpty()) {
                ORID neighborIdentity;
                OrientVertex v;
                Iterable<Vertex> neighbors;
                ArrayDeque<OrientVertex> nextLevelQueue = new ArrayDeque<OrientVertex>();
                while (!queue1.isEmpty()) {
                    OrientVertex current = (OrientVertex)queue1.poll();
                    neighbors = edgeType == null ? current.getVertices(direction, new String[0]) : current.getVertices(direction, "" + edgeType);
                    for (Vertex neighbor : neighbors) {
                        v = (OrientVertex)neighbor;
                        neighborIdentity = v.getIdentity();
                        if (rightVisited.contains(neighborIdentity)) {
                            previouses.put(neighborIdentity, current.getIdentity());
                            List<ORID> list = this.computePath(previouses, nexts, neighborIdentity);
                            return list;
                        }
                        if (visited.contains(neighborIdentity)) continue;
                        previouses.put(neighborIdentity, current.getIdentity());
                        nextLevelQueue.offer(v);
                        visited.add(neighborIdentity);
                        leftVisited.add(neighborIdentity);
                    }
                }
                queue1 = nextLevelQueue;
                nextLevelQueue = new ArrayDeque();
                while (!queue2.isEmpty()) {
                    OrientVertex reverseCurrent = (OrientVertex)queue2.poll();
                    neighbors = edgeType == null ? reverseCurrent.getVertices(reverseDirection, new String[0]) : reverseCurrent.getVertices(reverseDirection, "" + edgeType);
                    for (Vertex neighbor : neighbors) {
                        v = (OrientVertex)neighbor;
                        neighborIdentity = v.getIdentity();
                        if (leftVisited.contains(neighborIdentity)) {
                            nexts.put(neighborIdentity, reverseCurrent.getIdentity());
                            List<ORID> list = this.computePath(previouses, nexts, neighborIdentity);
                            return list;
                        }
                        if (visited.contains(neighborIdentity)) continue;
                        nexts.put(neighborIdentity, reverseCurrent.getIdentity());
                        nextLevelQueue.offer(v);
                        visited.add(neighborIdentity);
                        rightVisited.add(neighborIdentity);
                    }
                }
                queue2 = nextLevelQueue;
            }
            ArrayList<ORID> arrayList = new ArrayList<ORID>();
            return arrayList;
        }
        finally {
            if (shutdownFlag.getValue()) {
                graph.shutdown(false);
            }
            ODatabaseRecordThreadLocal.INSTANCE.set(curDb);
        }
    }

    public String getSyntax() {
        return "shortestPath(<sourceVertex>, <destinationVertex>, [<direction>, [ <edgeTypeAsString> ]])";
    }

    private List<ORID> computePath(Map<ORID, ORID> leftDistances, Map<ORID, ORID> rightDistances, ORID neighbor) {
        ArrayList<ORID> result = new ArrayList<ORID>();
        ORID current = neighbor;
        while (current != null) {
            result.add(0, current);
            current = leftDistances.get(current);
        }
        current = neighbor;
        while (current != null) {
            if ((current = rightDistances.get(current)) == null) continue;
            result.add(current);
        }
        return result;
    }
}

