/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.impls.orient.OrientElementScanIterable;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphCommand;
import com.tinkerpop.blueprints.impls.orient.OrientGraphQuery;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientTransactionalGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionVertex;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public abstract class OrientBaseGraph
extends OrientConfigurableGraph
implements OrientExtendedGraph {
    public static final String CONNECTION_OUT = "out";
    public static final String CONNECTION_IN = "in";
    public static final String CLASS_PREFIX = "class:";
    public static final String CLUSTER_PREFIX = "cluster:";
    public static final String ADMIN = "admin";
    private static volatile ThreadLocal<OrientBaseGraph> activeGraph = new ThreadLocal();
    private static volatile ThreadLocal<Deque<OrientBaseGraph>> initializationStack = new ThreadLocal<Deque<OrientBaseGraph>>(){

        @Override
        protected Deque<OrientBaseGraph> initialValue() {
            return new LinkedList<OrientBaseGraph>();
        }
    };
    private final OPartitionedDatabasePool pool;
    protected ODatabaseDocumentTx database;
    private String url;
    private String username;
    private String password;

    public OrientBaseGraph(ODatabaseDocumentTx iDatabase, String iUserName, String iUserPassword, OrientConfigurableGraph.Settings iConfiguration) {
        this.pool = null;
        this.username = iUserName;
        this.password = iUserPassword;
        this.database = iDatabase;
        OrientBaseGraph.checkForGraphSchema(this.database);
        this.makeActive();
        this.putInInitializationStack();
        this.readDatabaseConfiguration();
        this.configure(iConfiguration);
    }

    public OrientBaseGraph(OPartitionedDatabasePool pool) {
        this.pool = pool;
        this.database = pool.acquire();
        this.makeActive();
        this.putInInitializationStack();
        this.username = this.database.getUser() != null ? this.database.getUser().getName() : null;
        this.readDatabaseConfiguration();
    }

    public OrientBaseGraph(OPartitionedDatabasePool pool, OrientConfigurableGraph.Settings iConfiguration) {
        this.pool = pool;
        this.database = pool.acquire();
        this.makeActive();
        this.putInInitializationStack();
        this.username = this.database.getUser() != null ? this.database.getUser().getName() : null;
        this.readDatabaseConfiguration();
        this.configure(iConfiguration);
    }

    public OrientBaseGraph(String url) {
        this(url, ADMIN, ADMIN);
    }

    public OrientBaseGraph(String url, String username, String password) {
        this.pool = null;
        this.url = OFileUtils.getPath((String)url);
        this.username = username;
        this.password = password;
        this.openOrCreate();
        this.readDatabaseConfiguration();
    }

    public OrientBaseGraph(Configuration configuration) {
        this(configuration.getString("blueprints.orientdb.url", null), configuration.getString("blueprints.orientdb.username", null), configuration.getString("blueprints.orientdb.password", null));
        super.init(configuration);
    }

    public static OrientBaseGraph getActiveGraph() {
        return activeGraph.get();
    }

    public static void clearInitStack() {
        ODatabaseRecordThreadLocal dbtl;
        ThreadLocal<OrientBaseGraph> ag;
        ThreadLocal<Deque<OrientBaseGraph>> is = initializationStack;
        if (is != null) {
            is.get().clear();
        }
        if ((ag = activeGraph) != null) {
            ag.set(null);
        }
        if ((dbtl = ODatabaseRecordThreadLocal.INSTANCE) != null) {
            dbtl.set(null);
        }
    }

    public static void encodeClassNames(String ... iLabels) {
        if (iLabels != null) {
            for (int i = 0; i < iLabels.length; ++i) {
                iLabels[i] = OrientBaseGraph.encodeClassName(iLabels[i]);
            }
        }
    }

    public static void getEdgeClassNames(OrientBaseGraph graph, String ... iLabels) {
        if (iLabels != null && graph.isUseClassForEdgeLabel()) {
            for (int i = 0; i < iLabels.length; ++i) {
                OrientEdgeType edgeType = graph.getEdgeType(iLabels[i]);
                if (edgeType == null) continue;
                iLabels[i] = edgeType.getName();
            }
        }
    }

    public static String encodeClassName(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        if (Character.isDigit(iClassName.charAt(0))) {
            iClassName = "-" + iClassName;
        }
        try {
            return URLEncoder.encode(iClassName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            OLogManager.instance().error(null, "Error on encoding class name using encoding '%s'", (Throwable)e, new Object[]{"UTF-8"});
            return iClassName;
        }
    }

    public static String decodeClassName(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        if (iClassName.charAt(0) == '-') {
            iClassName = iClassName.substring(1);
        }
        try {
            return URLDecoder.decode(iClassName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            OLogManager.instance().error(null, "Error on decoding class name using encoding '%s'", (Throwable)e, new Object[]{"UTF-8"});
            return iClassName;
        }
    }

    protected static void checkForGraphSchema(ODatabaseDocumentTx iDatabase) {
        OSchemaProxy schema = iDatabase.getMetadata().getSchema();
        schema.getOrCreateClass("ORIDs");
        OClass vertexBaseClass = schema.getClass("V");
        OClass edgeBaseClass = schema.getClass("E");
        if (vertexBaseClass == null) {
            schema.createClass("V").setOverSize(2.0f);
        }
        if (edgeBaseClass == null) {
            schema.createClass("E");
        }
        boolean warn = false;
        String MSG_SUFFIX = ". Probably you are using a database created with a previous version of OrientDB. Export in graphml format and reimport it";
        if (vertexBaseClass != null) {
            if (!vertexBaseClass.getName().equals("V")) {
                OLogManager.instance().warn(null, "Found Vertex class %s. Probably you are using a database created with a previous version of OrientDB. Export in graphml format and reimport it", new Object[]{vertexBaseClass.getName()});
                warn = true;
            }
            if (vertexBaseClass.existsProperty(CONNECTION_OUT) || vertexBaseClass.existsProperty(CONNECTION_IN)) {
                OLogManager.instance().warn(null, "Found property in/out against V", new Object[0]);
                warn = true;
            }
        }
        if (edgeBaseClass != null) {
            if (!warn && !edgeBaseClass.getName().equals("E")) {
                OLogManager.instance().warn(null, "Found Edge class %s. Probably you are using a database created with a previous version of OrientDB. Export in graphml format and reimport it", new Object[]{edgeBaseClass.getName()});
                warn = true;
            }
            if (edgeBaseClass.existsProperty(CONNECTION_OUT) || edgeBaseClass.existsProperty(CONNECTION_IN)) {
                OLogManager.instance().warn(null, "Found property in/out against E", new Object[0]);
                warn = true;
            }
        }
    }

    public void makeActive() {
        activeGraph.set(this);
        ODatabaseDocumentInternal tlDb = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (this.database != null && tlDb != this.database) {
            ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.database);
        }
    }

    public OrientBaseGraph configure(OrientConfigurableGraph.Settings iSetting) {
        this.makeActive();
        if (iSetting != null) {
            if (this.settings == null) {
                this.settings = iSetting;
            } else {
                this.settings.copyFrom(iSetting);
            }
        }
        return this;
    }

    @Override
    public void drop() {
        this.makeActive();
        this.getRawGraph().drop();
        this.pollGraphFromStack(true);
    }

    public <T extends Element> Index<T> createIndex(final String indexName, final Class<T> indexClass, Parameter ... indexParameters) {
        this.makeActive();
        return (Index)this.executeOutsideTx(new OCallable<Index<T>, OrientBaseGraph>(){

            public Index<T> call(OrientBaseGraph g) {
                OIndexManagerProxy indexManager = OrientBaseGraph.this.database.getMetadata().getIndexManager();
                if (indexManager.getIndex(indexName) != null) {
                    throw ExceptionFactory.indexAlreadyExists((String)indexName);
                }
                OrientIndex index = new OrientIndex(g, indexName, indexClass, null);
                OrientBaseGraph.this.saveIndexConfiguration();
                return index;
            }
        }, "create index '", indexName, "'");
    }

    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        this.makeActive();
        OIndexManagerProxy indexManager = this.database.getMetadata().getIndexManager();
        OIndex idx = indexManager.getIndex(indexName);
        if (idx == null || !this.hasIndexClass(idx)) {
            return null;
        }
        OrientIndex index = new OrientIndex(this, idx);
        if (indexClass.isAssignableFrom(index.getIndexClass())) {
            return index;
        }
        throw ExceptionFactory.indexDoesNotSupportClass((String)indexName, indexClass);
    }

    public Iterable<Index<? extends Element>> getIndices() {
        this.makeActive();
        return this.loadManualIndexes();
    }

    public void dropIndex(final String indexName) {
        this.makeActive();
        this.executeOutsideTx(new OCallable<Object, OrientBaseGraph>(){

            public Object call(OrientBaseGraph g) {
                try {
                    OIndexManagerProxy indexManager = OrientBaseGraph.this.getRawGraph().getMetadata().getIndexManager();
                    OIndex index = indexManager.getIndex(indexName);
                    String recordMapIndexName = (String)index.getConfiguration().field("record_map_name");
                    indexManager.dropIndex(indexName);
                    if (recordMapIndexName != null) {
                        OrientBaseGraph.this.getRawGraph().getMetadata().getIndexManager().dropIndex(recordMapIndexName);
                    }
                    OrientBaseGraph.this.saveIndexConfiguration();
                    return null;
                }
                catch (Exception e) {
                    g.rollback();
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }, "drop index '", indexName, "'");
    }

    public OrientVertex addVertex(Object id) {
        this.makeActive();
        return this.addVertex(id, (Object[])null);
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        this.makeActive();
        return this.database.getStorage().getConflictStrategy();
    }

    @Override
    public OrientBaseGraph setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.makeActive();
        this.database.setConflictStrategy(iResolver);
        return this;
    }

    @Override
    public OrientBaseGraph setConflictStrategy(String iStrategyName) {
        this.makeActive();
        this.database.setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName));
        return this;
    }

    @Override
    public OrientVertex addVertex(Object id, Object ... prop) {
        this.makeActive();
        String className = null;
        String clusterName = null;
        Object[] fields = null;
        if (id != null) {
            if (id instanceof String) {
                String[] args;
                for (String s : args = ((String)id).split(",")) {
                    if (s.startsWith(CLASS_PREFIX)) {
                        className = s.substring(CLASS_PREFIX.length());
                        continue;
                    }
                    if (s.startsWith(CLUSTER_PREFIX)) {
                        clusterName = s.substring(CLUSTER_PREFIX.length());
                        continue;
                    }
                    id = s;
                }
            }
            if (this.isSaveOriginalIds()) {
                fields = new Object[]{OrientElement.DEF_ORIGINAL_ID_FIELDNAME, id};
            }
        }
        this.setCurrentGraphInThreadLocal();
        this.autoStartTransaction();
        OrientVertex vertex = new OrientVertex(this, className, fields);
        vertex.setPropertiesInternal(prop);
        if (clusterName != null) {
            vertex.save(clusterName);
        } else {
            vertex.save();
        }
        return vertex;
    }

    public OrientVertex addVertex(String iClassName, String iClusterName) {
        this.makeActive();
        this.setCurrentGraphInThreadLocal();
        this.autoStartTransaction();
        OrientVertex vertex = new OrientVertex(this, iClassName, new Object[0]);
        if (iClusterName != null) {
            vertex.save(iClusterName);
        } else {
            vertex.save();
        }
        return vertex;
    }

    @Override
    public OrientVertex addTemporaryVertex(String iClassName, Object ... prop) {
        this.makeActive();
        this.setCurrentGraphInThreadLocal();
        this.autoStartTransaction();
        OrientVertex vertex = new OrientVertex(this, iClassName, new Object[0]);
        vertex.setPropertiesInternal(prop);
        return vertex;
    }

    public OrientEdge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Object[] fields;
        Object[] objectArray;
        this.makeActive();
        String className = null;
        String clusterName = null;
        if (id != null && id instanceof String) {
            String[] args;
            for (String s : args = ((String)id).split(",")) {
                if (s.startsWith(CLASS_PREFIX)) {
                    className = s.substring(CLASS_PREFIX.length());
                    continue;
                }
                if (!s.startsWith(CLUSTER_PREFIX)) continue;
                clusterName = s.substring(CLUSTER_PREFIX.length());
            }
        }
        if (id != null && id instanceof String && id.toString().startsWith(CLASS_PREFIX)) {
            className = id.toString().substring(CLASS_PREFIX.length());
        }
        if (this.isSaveOriginalIds() && id != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = OrientElement.DEF_ORIGINAL_ID_FIELDNAME;
            objectArray = objectArray2;
            objectArray2[1] = id;
        } else {
            objectArray = fields = null;
        }
        if (outVertex instanceof PartitionVertex) {
            outVertex = ((PartitionVertex)outVertex).getBaseVertex();
        }
        if (inVertex instanceof PartitionVertex) {
            inVertex = ((PartitionVertex)inVertex).getBaseVertex();
        }
        return ((OrientVertex)outVertex).addEdge(label, (OrientVertex)inVertex, className, clusterName, fields);
    }

    public OrientVertex getVertex(Object id) {
        ORID rid;
        this.makeActive();
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        if (id instanceof OrientVertex) {
            return (OrientVertex)id;
        }
        if (id instanceof ODocument) {
            return new OrientVertex(this, (OIdentifiable)id);
        }
        this.setCurrentGraphInThreadLocal();
        if (id instanceof OIdentifiable) {
            rid = ((OIdentifiable)id).getIdentity();
        } else {
            try {
                rid = new ORecordId(id.toString());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        if (!rid.isValid()) {
            return null;
        }
        ORecord rec = rid.getRecord();
        if (rec == null || !(rec instanceof ODocument)) {
            return null;
        }
        return new OrientVertex(this, (OIdentifiable)rec);
    }

    @Override
    public void declareIntent(OIntent iIntent) {
        this.makeActive();
        this.getRawGraph().declareIntent(iIntent);
    }

    public void removeVertex(Vertex vertex) {
        this.makeActive();
        vertex.remove();
    }

    public Iterable<Vertex> getVertices() {
        this.makeActive();
        return this.getVerticesOfClass("V", true);
    }

    public Iterable<Vertex> getVertices(boolean iPolymorphic) {
        this.makeActive();
        return this.getVerticesOfClass("V", iPolymorphic);
    }

    public Iterable<Vertex> getVerticesOfClass(String iClassName) {
        this.makeActive();
        return this.getVerticesOfClass(iClassName, true);
    }

    public Iterable<Vertex> getVerticesOfClass(String iClassName, boolean iPolymorphic) {
        this.makeActive();
        return new OrientElementScanIterable(this, iClassName, iPolymorphic);
    }

    public Iterable<Vertex> getVertices(String iKey, Object iValue) {
        OIndex idx;
        String key;
        String indexName;
        this.makeActive();
        if (iKey.equals("@class")) {
            return this.getVerticesOfClass(iValue.toString());
        }
        int pos = iKey.indexOf(46);
        if (pos > -1) {
            indexName = iKey;
            String className = iKey.substring(0, pos);
            key = iKey.substring(iKey.indexOf(46) + 1);
            OClass clazz = this.database.getMetadata().getImmutableSchemaSnapshot().getClass(className);
            Set indexes = clazz.getIndexes();
            for (OIndex index : indexes) {
                int point;
                String oInName = index.getName();
                String okey = oInName.substring((point = oInName.indexOf(".")) + 1);
                if (!okey.equals(key)) continue;
                indexName = oInName;
                break;
            }
        } else {
            indexName = "V." + iKey;
            key = iKey;
        }
        if ((idx = this.database.getMetadata().getIndexManager().getIndex(indexName)) != null) {
            List<Object> indexValue = idx.get(iValue = this.convertKey(idx, iValue));
            if (indexValue != null && !(indexValue instanceof Iterable)) {
                indexValue = Arrays.asList(indexValue);
            }
            return new OrientElementIterable(this, (Iterable)indexValue);
        }
        return this.query().has(key, iValue).vertices();
    }

    public Vertex getVertexByKey(String iKey, Object iValue) {
        this.makeActive();
        String indexName = iKey.indexOf(46) > -1 ? iKey : "V." + iKey;
        OIndex idx = this.database.getMetadata().getIndexManager().getIndex(indexName);
        if (idx != null) {
            Object v = idx.get(iValue = this.convertKey(idx, iValue));
            if (v != null) {
                return this.getVertex(v);
            }
            return null;
        }
        throw new IllegalArgumentException("Index '" + indexName + "' not found");
    }

    public Iterable<Vertex> getVertices(String label, String[] iKey, Object[] iValue) {
        OIndex idx;
        this.makeActive();
        OClass clazz = this.database.getMetadata().getImmutableSchemaSnapshot().getClass(label);
        Set indexes = clazz.getInvolvedIndexes(Arrays.asList(iKey));
        if (indexes.iterator().hasNext() && (idx = (OIndex)indexes.iterator().next()) != null) {
            List<Object> keys = Arrays.asList(this.convertKeys(idx, iValue));
            Object key = keys.size() == 1 ? keys.get(0) : new OCompositeKey(keys);
            List<Object> indexValue = idx.get(key);
            if (indexValue != null && !(indexValue instanceof Iterable)) {
                indexValue = Arrays.asList(indexValue);
            }
            return new OrientElementIterable(this, (Iterable)indexValue);
        }
        OrientGraphQuery query = (OrientGraphQuery)this.query();
        query.labels(label);
        for (int i = 0; i < iKey.length; ++i) {
            query.has(iKey[i], iValue[i]);
        }
        return query.vertices();
    }

    public Iterable<Edge> getEdges() {
        this.makeActive();
        return this.getEdgesOfClass("E", true);
    }

    public Iterable<Edge> getEdges(boolean iPolymorphic) {
        this.makeActive();
        return this.getEdgesOfClass("E", iPolymorphic);
    }

    public Iterable<Edge> getEdgesOfClass(String iClassName) {
        this.makeActive();
        return this.getEdgesOfClass(iClassName, true);
    }

    public Iterable<Edge> getEdgesOfClass(String iClassName, boolean iPolymorphic) {
        this.makeActive();
        return new OrientElementScanIterable(this, iClassName, iPolymorphic);
    }

    public Iterable<Edge> getEdges(String iKey, Object iValue) {
        String key;
        String indexName;
        this.makeActive();
        if (iKey.equals("@class")) {
            return this.getEdgesOfClass(iValue.toString());
        }
        int pos = iKey.indexOf(46);
        if (pos > -1) {
            indexName = iKey;
            key = iKey.substring(iKey.indexOf(46) + 1);
        } else {
            indexName = "E." + iKey;
            key = iKey;
        }
        OIndex idx = this.database.getMetadata().getIndexManager().getIndex(indexName);
        if (idx != null) {
            List<Object> indexValue = idx.get(iValue = this.convertKey(idx, iValue));
            if (indexValue != null && !(indexValue instanceof Iterable)) {
                indexValue = Arrays.asList(indexValue);
            }
            return new OrientElementIterable(this, (Iterable)indexValue);
        }
        return this.query().has(key, iValue).edges();
    }

    public OrientEdge getEdge(Object id) {
        OIdentifiable rec;
        this.makeActive();
        if (null == id) {
            throw ExceptionFactory.edgeIdCanNotBeNull();
        }
        if (id instanceof OrientEdge) {
            return (OrientEdge)id;
        }
        if (id instanceof ODocument) {
            return new OrientEdge(this, (OIdentifiable)id);
        }
        if (id instanceof OIdentifiable) {
            rec = (OIdentifiable)id;
        } else {
            String str = id.toString();
            int pos = str.indexOf("->");
            if (pos > -1) {
                String from = str.substring(0, pos);
                String to = str.substring(pos + 2);
                return new OrientEdge(this, (OIdentifiable)new ORecordId(from), (OIdentifiable)new ORecordId(to));
            }
            try {
                rec = new ORecordId(str);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        ODocument doc = (ODocument)rec.getRecord();
        if (doc == null) {
            return null;
        }
        return new OrientEdge(this, rec);
    }

    public void removeEdge(Edge edge) {
        this.makeActive();
        edge.remove();
    }

    public OrientBaseGraph reuse(ODatabaseDocumentTx iDatabase) {
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)iDatabase);
        this.url = iDatabase.getURL();
        this.database = iDatabase;
        this.makeActive();
        return this;
    }

    public boolean isClosed() {
        this.makeActive();
        return this.database == null || this.database.isClosed();
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean closeDb) {
        this.shutdown(closeDb, true);
    }

    public void shutdown(boolean closeDb, boolean commitTx) {
        this.makeActive();
        try {
            OStorage storage;
            if (!this.database.isClosed() && commitTx && (storage = this.database.getStorage()) instanceof OAbstractPaginatedStorage && ((OAbstractPaginatedStorage)storage).getWALInstance() != null) {
                this.database.commit();
            }
        }
        catch (RuntimeException e) {
            OLogManager.instance().error((Object)this, "Error during context close for db " + this.url, (Throwable)e, new Object[0]);
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error during context close for db " + this.url, (Throwable)e, new Object[0]);
            throw new OException("Error during context close for db " + this.url, (Throwable)e);
        }
        finally {
            try {
                if (closeDb) {
                    this.database.close();
                }
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error during context close for db " + this.url, (Throwable)e, new Object[0]);
            }
        }
        this.url = null;
        this.username = null;
        this.password = null;
        this.pollGraphFromStack(closeDb);
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.getRawGraph().getURL());
    }

    public ODatabaseDocumentTx getRawGraph() {
        return this.database;
    }

    public void commit() {
        this.makeActive();
    }

    public void rollback() {
        this.makeActive();
    }

    @Override
    public OrientVertexType getVertexBaseType() {
        this.makeActive();
        return new OrientVertexType(this, this.getRawGraph().getMetadata().getSchema().getClass("V"));
    }

    @Override
    public final OrientVertexType getVertexType(String iTypeName) {
        this.makeActive();
        OClass cls = this.getRawGraph().getMetadata().getSchema().getClass(iTypeName);
        if (cls == null) {
            return null;
        }
        OrientVertexType.checkType(cls);
        return new OrientVertexType(this, cls);
    }

    @Override
    public OrientVertexType createVertexType(String iClassName) {
        this.makeActive();
        return this.createVertexType(iClassName, (String)null);
    }

    @Override
    public OrientVertexType createVertexType(String iClassName, String iSuperClassName) {
        this.makeActive();
        return this.createVertexType(iClassName, (OClass)(iSuperClassName == null ? this.getVertexBaseType() : this.getVertexType(iSuperClassName)));
    }

    @Override
    public OrientVertexType createVertexType(final String iClassName, final OClass iSuperClass) {
        this.makeActive();
        OrientVertexType.checkType(iSuperClass);
        return this.executeOutsideTx(new OCallable<OrientVertexType, OrientBaseGraph>(){

            public OrientVertexType call(OrientBaseGraph g) {
                return new OrientVertexType(g, OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().createClass(iClassName, iSuperClass));
            }
        }, "create vertex type '", iClassName, "' as subclass of '", iSuperClass.getName(), "'");
    }

    @Override
    public final void dropVertexType(final String iTypeName) {
        this.makeActive();
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            public OClass call(OrientBaseGraph g) {
                OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().dropClass(iTypeName);
                return null;
            }
        }, "drop vertex type '", iTypeName, "'");
    }

    @Override
    public OrientEdgeType getEdgeBaseType() {
        this.makeActive();
        return new OrientEdgeType(this);
    }

    @Override
    public final OrientEdgeType getEdgeType(String iTypeName) {
        this.makeActive();
        OClass cls = this.getRawGraph().getMetadata().getSchema().getClass(iTypeName);
        if (cls == null) {
            return null;
        }
        OrientEdgeType.checkType(cls);
        return new OrientEdgeType(this, cls);
    }

    @Override
    public OrientEdgeType createEdgeType(String iClassName) {
        this.makeActive();
        return this.createEdgeType(iClassName, (String)null);
    }

    @Override
    public OrientEdgeType createEdgeType(String iClassName, String iSuperClassName) {
        this.makeActive();
        return this.createEdgeType(iClassName, (OClass)(iSuperClassName == null ? this.getEdgeBaseType() : this.getEdgeType(iSuperClassName)));
    }

    @Override
    public OrientEdgeType createEdgeType(final String iClassName, final OClass iSuperClass) {
        this.makeActive();
        OrientEdgeType.checkType(iSuperClass);
        return this.executeOutsideTx(new OCallable<OrientEdgeType, OrientBaseGraph>(){

            public OrientEdgeType call(OrientBaseGraph g) {
                return new OrientEdgeType(g, OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().createClass(iClassName, iSuperClass));
            }
        }, "create edge type '", iClassName, "' as subclass of '", iSuperClass.getName(), "'");
    }

    @Override
    public final void dropEdgeType(final String iTypeName) {
        this.makeActive();
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            public OClass call(OrientBaseGraph g) {
                OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().dropClass(iTypeName);
                return null;
            }
        }, "drop edge type '", iTypeName, "'");
    }

    @Override
    public OrientElement detach(OrientElement iElement) {
        this.makeActive();
        iElement.detach();
        return iElement;
    }

    @Override
    public OrientElement attach(OrientElement iElement) {
        this.makeActive();
        return iElement.attach(this);
    }

    public OrientElement getElement(Object id) {
        OIdentifiable rec;
        this.makeActive();
        if (null == id) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (id instanceof OrientElement) {
            return (OrientElement)id;
        }
        if (id instanceof OIdentifiable) {
            rec = (OIdentifiable)id;
        } else {
            try {
                rec = new ORecordId(id.toString());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        ODocument doc = (ODocument)rec.getRecord();
        if (doc != null) {
            OClass schemaClass = ODocumentInternal.getImmutableSchemaClass((ODocument)doc);
            if (schemaClass != null && schemaClass.isSubClassOf("E")) {
                return new OrientEdge(this, (OIdentifiable)doc);
            }
            return new OrientVertex(this, (OIdentifiable)doc);
        }
        return null;
    }

    public <T extends Element> void dropKeyIndex(final String key, final Class<T> elementClass) {
        this.makeActive();
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            public OClass call(OrientBaseGraph g) {
                String className = OrientBaseGraph.this.getClassName(elementClass);
                OrientBaseGraph.this.getRawGraph().getMetadata().getIndexManager().dropIndex(className + "." + key);
                return null;
            }
        }, "drop key index '", elementClass.getSimpleName(), ".", key, "'");
    }

    public <T extends Element> void createKeyIndex(final String key, final Class<T> elementClass, final Parameter ... indexParameters) {
        this.makeActive();
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            public OClass call(OrientBaseGraph g) {
                ODatabaseDocumentTx db;
                OSchemaProxy schema;
                OClass cls;
                OProperty property;
                String indexType = OClass.INDEX_TYPE.NOTUNIQUE.name();
                OType keyType = OType.STRING;
                String className = null;
                ODocument metadata = null;
                String ancestorClassName = OrientBaseGraph.this.getClassName(elementClass);
                for (Parameter p : indexParameters) {
                    if (p.getKey().equals("type")) {
                        indexType = p.getValue().toString().toUpperCase();
                        continue;
                    }
                    if (p.getKey().equals("keytype")) {
                        keyType = OType.valueOf((String)p.getValue().toString().toUpperCase());
                        continue;
                    }
                    if (p.getKey().equals("class")) {
                        className = p.getValue().toString();
                        continue;
                    }
                    if (!p.getKey().toString().startsWith("metadata.")) continue;
                    if (metadata == null) {
                        metadata = new ODocument();
                    }
                    metadata.field(p.getKey().toString().substring("metadata.".length()), p.getValue());
                }
                if (className == null) {
                    className = ancestorClassName;
                }
                if ((property = (cls = (schema = (db = OrientBaseGraph.this.getRawGraph()).getMetadata().getSchema()).getOrCreateClass(className, schema.getClass(ancestorClassName))).getProperty(key)) != null) {
                    keyType = property.getType();
                }
                db.getMetadata().getIndexManager().createIndex(className + "." + key, indexType, (OIndexDefinition)new OPropertyIndexDefinition(className, key, keyType), cls.getPolymorphicClusterIds(), null, metadata);
                return null;
            }
        }, "create key index on '", elementClass.getSimpleName(), ".", key, "'");
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        this.makeActive();
        return this.getIndexedKeys(elementClass, false);
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass, boolean includeClassNames) {
        this.makeActive();
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        OImmutableSchema schema = this.getRawGraph().getMetadata().getImmutableSchemaSnapshot();
        String elementOClassName = this.getClassName(elementClass);
        HashSet<String> result = new HashSet<String>();
        Collection indexes = this.getRawGraph().getMetadata().getIndexManager().getIndexes();
        for (OIndex index : indexes) {
            String oClassName;
            OClass oClass;
            String indexName = index.getName();
            int point = indexName.indexOf(".");
            if (point <= 0 || !(oClass = schema.getClass(oClassName = indexName.substring(0, point))).isSubClassOf(elementOClassName)) continue;
            if (includeClassNames) {
                result.add(index.getName());
                continue;
            }
            result.add((String)index.getDefinition().getFields().get(0));
        }
        return result;
    }

    @Override
    public GraphQuery query() {
        this.makeActive();
        return new OrientGraphQuery((Graph)this);
    }

    @Override
    public OTraverse traverse() {
        this.makeActive();
        return new OTraverse();
    }

    @Override
    public OCommandRequest command(OCommandRequest iCommand) {
        this.makeActive();
        return new OrientGraphCommand(this, this.getRawGraph().command(iCommand));
    }

    @Override
    public long countVertices() {
        return this.countVertices("V");
    }

    @Override
    public long countVertices(String iClassName) {
        this.makeActive();
        return this.getRawGraph().countClass(iClassName);
    }

    @Override
    public long countEdges() {
        return this.countEdges("E");
    }

    @Override
    public long countEdges(String iClassName) {
        this.makeActive();
        if (this.isUseLightweightEdges()) {
            throw new UnsupportedOperationException("Graph set to use Lightweight Edges, count against edges is not supported");
        }
        return this.getRawGraph().countClass(iClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RET> RET executeOutsideTx(OCallable<RET, OrientBaseGraph> iCallable, String ... iOperationStrings) throws RuntimeException {
        boolean committed;
        this.makeActive();
        ODatabaseDocumentTx raw = this.getRawGraph();
        if (raw.getTransaction().isActive()) {
            if (this.isWarnOnForceClosingTx() && OLogManager.instance().isWarnEnabled() && iOperationStrings.length > 0) {
                StringBuilder msg = new StringBuilder(256);
                for (String s : iOperationStrings) {
                    msg.append(s);
                }
                OLogManager.instance().warn((Object)this, "Requested command '%s' must be executed outside active transaction: the transaction will be committed and reopen right after it. To avoid this behavior execute it outside a transaction", new Object[]{msg.toString()});
            }
            raw.commit();
            committed = true;
        } else {
            committed = false;
        }
        try {
            Object object = iCallable.call((Object)this);
            return (RET)object;
        }
        finally {
            if (committed) {
                ((OrientTransactionalGraph)this).begin();
            }
        }
    }

    protected void autoStartTransaction() {
    }

    protected void saveIndexConfiguration() {
        this.getRawGraph().getMetadata().getIndexManager().getConfiguration().save();
    }

    protected <T> String getClassName(Class<T> elementClass) {
        if (elementClass.isAssignableFrom(Vertex.class)) {
            return "V";
        }
        if (elementClass.isAssignableFrom(Edge.class)) {
            return "E";
        }
        throw new IllegalArgumentException("Class '" + elementClass + "' is neither a Vertex, nor an Edge");
    }

    protected Object convertKey(OIndex<?> idx, Object iValue) {
        if (iValue != null) {
            OType[] types = idx.getKeyTypes();
            iValue = types.length == 0 ? iValue.toString() : OType.convert((Object)iValue, (Class)types[0].getDefaultJavaType());
        }
        return iValue;
    }

    protected Object[] convertKeys(OIndex<?> idx, Object[] iValue) {
        OType[] types;
        if (iValue != null && (types = idx.getKeyTypes()).length == iValue.length) {
            Object[] newValue = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                newValue[i] = OType.convert((Object)iValue[i], (Class)types[i].getDefaultJavaType());
            }
            iValue = newValue;
        }
        return iValue;
    }

    protected void setCurrentGraphInThreadLocal() {
        if (this.getThreadMode() == OrientConfigurableGraph.THREAD_MODE.MANUAL) {
            return;
        }
        ODatabaseDocumentInternal tlDb = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if ((this.getThreadMode() == OrientConfigurableGraph.THREAD_MODE.ALWAYS_AUTOSET || tlDb == null) && this.database != null && tlDb != this.database) {
            ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.database);
        }
    }

    private void putInInitializationStack() {
        Deque<OrientBaseGraph> stack = initializationStack.get();
        stack.push(this);
    }

    private void pollGraphFromStack(boolean updateDb) {
        Deque<OrientBaseGraph> stack = initializationStack.get();
        stack.poll();
        OrientBaseGraph prevGraph = stack.peek();
        if (prevGraph != null) {
            activeGraph.set(prevGraph);
            prevGraph.makeActive();
        } else {
            activeGraph.set(null);
            if (updateDb) {
                ODatabaseRecordThreadLocal.INSTANCE.set(null);
            }
        }
    }

    private void readDatabaseConfiguration() {
        ODatabaseDocumentTx databaseDocumentTx = this.getRawGraph();
        List custom = (List)databaseDocumentTx.get(ODatabase.ATTRIBUTES.CUSTOM);
        for (OStorageEntryConfiguration c : custom) {
            if (c.name.equals("useLightweightEdges")) {
                this.setUseLightweightEdges(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("useClassForEdgeLabel")) {
                this.setUseClassForEdgeLabel(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("useClassForVertexLabel")) {
                this.setUseClassForVertexLabel(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("useVertexFieldsForEdgeLabels")) {
                this.setUseVertexFieldsForEdgeLabels(Boolean.parseBoolean(c.value));
                continue;
            }
            if (!c.name.equals("standardElementConstraints")) continue;
            this.setStandardElementConstraints(Boolean.parseBoolean(c.value));
        }
    }

    private void openOrCreate() {
        if (this.url == null) {
            throw new IllegalStateException("Database is closed");
        }
        if (this.pool == null) {
            this.database = new ODatabaseDocumentTx(this.url);
            if (this.url.startsWith("remote:") || this.database.exists()) {
                if (this.database.isClosed()) {
                    this.database.open(this.username, this.password);
                }
            } else {
                this.database.create();
            }
        } else {
            this.database = this.pool.acquire();
        }
        this.makeActive();
        this.putInInitializationStack();
        OrientBaseGraph.checkForGraphSchema(this.database);
    }

    private List<Index<? extends Element>> loadManualIndexes() {
        ArrayList<Index<? extends Element>> result = new ArrayList<Index<? extends Element>>();
        for (OIndex idx : this.database.getMetadata().getIndexManager().getIndexes()) {
            if (!this.hasIndexClass(idx)) continue;
            result.add(new OrientIndex(this, idx));
        }
        return result;
    }

    private boolean hasIndexClass(OIndex<?> idx) {
        ODocument metadata = idx.getMetadata();
        return metadata != null && metadata.field("blueprintsIndexClass") != null || idx.getConfiguration().field("blueprintsIndexClass") != null;
    }

    static {
        Orient.instance().registerListener((OOrientListener)new OOrientListenerAbstract(){

            public void onStartup() {
                if (activeGraph == null) {
                    activeGraph = new ThreadLocal();
                }
                if (initializationStack == null) {
                    initializationStack = new ThreadLocal<Deque<OrientBaseGraph>>(){

                        @Override
                        protected Deque<OrientBaseGraph> initialValue() {
                            return new LinkedList<OrientBaseGraph>();
                        }
                    };
                }
            }

            public void onShutdown() {
                activeGraph = null;
                initializationStack = null;
            }
        });
    }
}

