/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;
import java.util.NoSuchElementException;

class OrientElementIterator<T extends Element>
implements Iterator<T> {
    private final Iterator<?> itty;
    private final OrientBaseGraph graph;

    public OrientElementIterator(OrientBaseGraph graph, Iterator<?> itty) {
        this.itty = itty;
        this.graph = graph;
    }

    @Override
    public boolean hasNext() {
        return this.itty.hasNext();
    }

    @Override
    public T next() {
        OrientElement currentElement = null;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object current = this.itty.next();
        if (null == current) {
            throw new NoSuchElementException();
        }
        if (current instanceof OIdentifiable) {
            current = ((OIdentifiable)current).getRecord();
        }
        if (current instanceof ODocument) {
            ODocument currentDocument = (ODocument)current;
            if (currentDocument.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                currentDocument.load();
            }
            if (ODocumentInternal.getImmutableSchemaClass((ODocument)currentDocument) == null) {
                throw new IllegalArgumentException("Cannot determine the graph element type because the document class is null. Probably this is a projection, use the EXPAND() function");
            }
            if (this.graph == null) {
                throw new IllegalArgumentException("The element has been detached, the graph element cannot be retrieved. Reattach the element to a Graph instance");
            }
            currentElement = ODocumentInternal.getImmutableSchemaClass((ODocument)currentDocument).isSubClassOf((OClass)this.graph.getEdgeBaseType()) ? new OrientEdge(this.graph, (OIdentifiable)currentDocument) : new OrientVertex(this.graph, (OIdentifiable)currentDocument);
        }
        return (T)currentElement;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

