/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import org.apache.commons.configuration.Configuration;

public abstract class OrientTransactionalGraph
extends OrientBaseGraph
implements TransactionalGraph {
    protected boolean useLog = true;

    protected OrientTransactionalGraph(ODatabaseDocumentTx iDatabase) {
        this(iDatabase, true, null, null);
    }

    protected OrientTransactionalGraph(ODatabaseDocumentTx iDatabase, String iUserName, String iUserPasswd, OrientConfigurableGraph.Settings iConfiguration) {
        super(iDatabase, iUserName, iUserPasswd, iConfiguration);
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(this.isAutoStartTx());
        if (this.isAutoStartTx()) {
            this.begin();
        }
    }

    protected OrientTransactionalGraph(ODatabaseDocumentTx iDatabase, boolean iAutoStartTx, String iUserName, String iUserPasswd) {
        super(iDatabase, iUserName, iUserPasswd, null);
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(iAutoStartTx);
        if (iAutoStartTx) {
            this.begin();
        }
    }

    protected OrientTransactionalGraph(OPartitionedDatabasePool pool) {
        super(pool);
        this.setCurrentGraphInThreadLocal();
        this.begin();
    }

    protected OrientTransactionalGraph(OPartitionedDatabasePool pool, OrientConfigurableGraph.Settings configuration) {
        super(pool, configuration);
        this.setCurrentGraphInThreadLocal();
        if (configuration.isAutoStartTx()) {
            this.begin();
        }
    }

    protected OrientTransactionalGraph(String url) {
        this(url, true);
    }

    protected OrientTransactionalGraph(String url, boolean iAutoStartTx) {
        super(url, "admin", "admin");
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(iAutoStartTx);
        if (iAutoStartTx) {
            this.begin();
        }
    }

    protected OrientTransactionalGraph(String url, String username, String password) {
        this(url, username, password, true);
    }

    protected OrientTransactionalGraph(String url, String username, String password, boolean iAutoStartTx) {
        super(url, username, password);
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(iAutoStartTx);
        if (iAutoStartTx) {
            this.begin();
        }
    }

    protected OrientTransactionalGraph(Configuration configuration) {
        super(configuration);
        Boolean autoStartTx = configuration.getBoolean("blueprints.orientdb.autoStartTx", null);
        if (autoStartTx != null) {
            this.setAutoStartTx(autoStartTx);
        }
    }

    public boolean isUseLog() {
        this.makeActive();
        return this.useLog;
    }

    public OrientTransactionalGraph setUseLog(boolean useLog) {
        this.makeActive();
        this.useLog = useLog;
        return this;
    }

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        this.makeActive();
        if (this.database.isClosed() || this.database.getTransaction() instanceof OTransactionNoTx || this.database.getTransaction().getStatus() != OTransaction.TXSTATUS.BEGUN) {
            return;
        }
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    @Override
    public void commit() {
        this.makeActive();
        if (this.database == null) {
            return;
        }
        this.database.commit();
        if (this.isAutoStartTx()) {
            this.begin();
        }
    }

    @Override
    public void rollback() {
        this.makeActive();
        if (this.database == null) {
            return;
        }
        this.database.rollback();
        if (this.isAutoStartTx()) {
            this.begin();
        }
    }

    public void begin() {
        this.makeActive();
        boolean txBegun = this.database.getTransaction().isActive();
        if (!txBegun) {
            this.database.begin();
            this.database.getTransaction().setUsingLog(this.useLog);
        }
    }

    @Override
    protected void autoStartTransaction() {
        boolean txBegun = this.database.getTransaction().isActive();
        if (!this.isAutoStartTx()) {
            if (this.isRequireTransaction() && !txBegun) {
                throw new OTransactionException("Transaction required to change the Graph");
            }
            return;
        }
        if (!txBegun) {
            this.begin();
        }
    }
}

