/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.stresstest;

import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.graph.stresstest.OBaseGraphWorkload;
import com.orientechnologies.orient.stresstest.ODatabaseIdentifier;
import com.orientechnologies.orient.stresstest.OStressTesterSettings;
import com.orientechnologies.orient.stresstest.workload.OBaseWorkload;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class OGraphShortestPathWorkload
extends OBaseGraphWorkload {
    static final String INVALID_FORM_MESSAGE = "SHORTESTPATH workload must be in form of L<limit>.";
    private int limit = -1;
    private OBaseWorkload.OWorkLoadResult result = new OBaseWorkload.OWorkLoadResult((OBaseWorkload)this);
    private final AtomicLong totalDepth = new AtomicLong();
    private final AtomicLong maxDepth = new AtomicLong();
    private final AtomicLong notConnected = new AtomicLong();
    private final List<ORID> startingVertices = new ArrayList<ORID>(this.limit > -1 ? this.limit : 1000);

    public OGraphShortestPathWorkload() {
        this.connectionStrategy = OStorageRemote.CONNECTION_STRATEGY.ROUND_ROBIN_REQUEST;
    }

    public String getName() {
        return "GSP";
    }

    public void parseParameters(String args) {
        if (args == null) {
            return;
        }
        String ops = args.toUpperCase();
        char state = 'L';
        StringBuilder number = new StringBuilder();
        for (int pos = 0; pos < ops.length(); ++pos) {
            char c = ops.charAt(pos);
            if (c == ' ' || c == 'L') {
                state = this.assignState(state, number, c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                number.append(c);
                continue;
            }
            throw new IllegalArgumentException("Character '" + c + "' is not valid on " + this.getName() + " workload. " + INVALID_FORM_MESSAGE);
        }
        this.assignState(state, number, ' ');
        this.result.total = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OStressTesterSettings settings, ODatabaseIdentifier databaseIdentifier) {
        this.connectionStrategy = settings.loadBalancing;
        OrientGraphNoTx g = this.getGraphNoTx(databaseIdentifier);
        try {
            for (OIdentifiable id : g.getRawGraph().browseClass("V")) {
                this.startingVertices.add(id.getIdentity());
                if (this.limit <= -1 || this.startingVertices.size() < this.limit) continue;
                break;
            }
        }
        finally {
            g.shutdown();
        }
        this.result.total = this.startingVertices.size();
        this.executeOperation(databaseIdentifier, this.result, settings.concurrencyLevel, settings.operationsPerTransaction, (OCallable)new OCallable<Void, OBaseWorkload.OBaseWorkLoadContext>(){

            public Void call(OBaseWorkload.OBaseWorkLoadContext context) {
                OBaseGraphWorkload.OWorkLoadContext graphContext = (OBaseGraphWorkload.OWorkLoadContext)context;
                OrientBaseGraph graph = graphContext.graph;
                for (int i = 0; i < OGraphShortestPathWorkload.this.startingVertices.size(); ++i) {
                    Iterable commandResult = (Iterable)graph.command((OCommandRequest)new OCommandSQL("select shortestPath(?,?, 'both')")).execute(new Object[]{OGraphShortestPathWorkload.this.startingVertices.get(context.currentIdx), OGraphShortestPathWorkload.this.startingVertices.get(i)});
                    for (OrientVertex v : commandResult) {
                        Collection depth = (Collection)v.getRecord().field("shortestPath");
                        if (depth != null && !depth.isEmpty()) {
                            OGraphShortestPathWorkload.this.totalDepth.addAndGet(depth.size());
                            long max = OGraphShortestPathWorkload.this.maxDepth.get();
                            while ((long)depth.size() > max && !OGraphShortestPathWorkload.this.maxDepth.compareAndSet(max, depth.size())) {
                                max = OGraphShortestPathWorkload.this.maxDepth.get();
                            }
                            continue;
                        }
                        OGraphShortestPathWorkload.this.notConnected.incrementAndGet();
                    }
                }
                ((OGraphShortestPathWorkload)OGraphShortestPathWorkload.this).result.current.incrementAndGet();
                return null;
            }
        });
    }

    public String getPartialResult() {
        return String.format("%d%% [Shortest paths blocks (block size=%d) executed: %d/%d]", 100 * this.result.current.get() / this.result.total, this.startingVertices.size(), this.result.current.get(), this.startingVertices.size());
    }

    public String getFinalResult() {
        StringBuilder buffer = new StringBuilder(this.getErrors());
        buffer.append(String.format("- Executed %d shortest paths in %.3f secs", this.result.current.get(), Float.valueOf((float)this.result.totalTime / 1000.0f)));
        buffer.append(String.format("\n- Path depth: maximum %d, average %.3f, not connected %d", this.maxDepth.get(), Float.valueOf((float)this.totalDepth.get() / (float)this.startingVertices.size() / (float)this.startingVertices.size()), this.notConnected.get()));
        buffer.append(this.result.toOutput(1));
        return buffer.toString();
    }

    public String getFinalResultAsJson() {
        ODocument json = new ODocument();
        json.field("type", (Object)this.getName());
        json.field("shortestPath", (Object)this.result.toJSON(), new OType[]{OType.EMBEDDED});
        return json.toJSON("");
    }

    private char assignState(char state, StringBuilder number, char c) {
        if (number.length() == 0) {
            number.append("0");
        }
        if (state == 'L') {
            this.limit = Integer.parseInt(number.toString());
        }
        number.setLength(0);
        return c;
    }

    public int getShortestPaths() {
        return this.result.total;
    }

    public int getLimit() {
        return this.limit;
    }
}

